/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.operator.ExceptionalReceiver;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorTestHelper;
import org.apache.druid.query.operator.SegmentToRowsAndColumnsOperator;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.segment.ArrayListSegment;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestSegmentForAs;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;

public class SegmentToRowsAndColumnsOperatorTest {
    @Test
    public void testSanity() {
        ArrayList rows = Lists.newArrayList((Object[])new Object[][]{{1, 2, "a"}, {1, 2, "b"}});
        ArrayListSegment segment = new ArrayListSegment(SegmentId.dummy((String)"test"), rows, columnName -> objects -> objects[Integer.parseInt(columnName)], RowSignature.builder().add("0", ColumnType.LONG).add("1", ColumnType.DOUBLE).add("2", ColumnType.STRING).build());
        SegmentToRowsAndColumnsOperator op = new SegmentToRowsAndColumnsOperator((Segment)segment);
        new OperatorTestHelper().expectRowsAndColumns(new RowsAndColumnsHelper().expectColumn("0", new long[]{1L, 1L}).expectColumn("1", new double[]{2.0, 2.0}).expectColumn("2", ColumnType.STRING, "a", "b").allColumnsRegistered()).runToCompletion((Operator)op);
    }

    @Test
    public void testNotShapeshiftable() {
        SegmentToRowsAndColumnsOperator op = new SegmentToRowsAndColumnsOperator((Segment)new TestSegmentForAs(SegmentId.dummy((String)"test"), aClass -> {
            Assert.assertEquals(CloseableShapeshifter.class, (Object)aClass);
            return null;
        }));
        boolean exceptionThrown = false;
        try {
            Operator.go((Operator)op, (Operator.Receiver)new ExceptionalReceiver());
        }
        catch (ISE e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Segment[class org.apache.druid.segment.TestSegmentForAs] cannot shapeshift");
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testCanShiftButNotToARAC() {
        final AtomicBoolean closed = new AtomicBoolean(false);
        SegmentToRowsAndColumnsOperator op = new SegmentToRowsAndColumnsOperator((Segment)new TestSegmentForAs(SegmentId.dummy((String)"test"), aClass -> {
            Assert.assertEquals(CloseableShapeshifter.class, (Object)aClass);
            return new CloseableShapeshifter(){

                @Nullable
                public <T> T as(@Nonnull Class<T> clazz) {
                    Assert.assertEquals(RowsAndColumns.class, clazz);
                    return null;
                }

                public void close() {
                    closed.set(true);
                }
            };
        }));
        boolean exceptionThrown = false;
        try {
            Operator.go((Operator)op, (Operator.Receiver)new ExceptionalReceiver());
        }
        catch (ISE e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Cannot work with segment of type[class org.apache.druid.segment.TestSegmentForAs]");
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertTrue((boolean)closed.get());
    }

    @Test
    public void testExceptionWhileClosing() {
        final MapOfColumnsRowsAndColumns expectedRac = MapOfColumnsRowsAndColumns.of((String)"0", (Column)new IntArrayColumn(new int[]{0, 1}));
        final AtomicBoolean closed = new AtomicBoolean(false);
        SegmentToRowsAndColumnsOperator op = new SegmentToRowsAndColumnsOperator((Segment)new TestSegmentForAs(SegmentId.dummy((String)"test"), aClass -> {
            Assert.assertEquals(CloseableShapeshifter.class, (Object)aClass);
            return new CloseableShapeshifter(){

                public <T> T as(@Nonnull Class<T> clazz) {
                    Assert.assertEquals(RowsAndColumns.class, clazz);
                    return (T)expectedRac;
                }

                public void close() throws IOException {
                    closed.set(true);
                    throw new IOException("ain't no thang");
                }
            };
        }));
        boolean exceptionThrown = false;
        try {
            new OperatorTestHelper().withPushFn(rac -> {
                Assert.assertSame((Object)expectedRac, (Object)rac);
                return Operator.Signal.GO;
            }).runToCompletion((Operator)op);
        }
        catch (RE e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Problem closing resources for segment[test_-146136543-09-08T08:23:32.096Z_146140482-04-24T15:36:27.903Z_dummy_version]");
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        Assert.assertTrue((boolean)closed.get());
    }
}

