/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WindowOperatorQueryTest {
    WindowOperatorQuery query;

    @Before
    public void setUp() {
        this.query = new WindowOperatorQuery((DataSource)InlineDataSource.fromIterable(new ArrayList(), (RowSignature)RowSignature.empty()), (Map)ImmutableMap.of((Object)"sally", (Object)"sue"), RowSignature.empty(), new ArrayList());
    }

    @Test
    public void getOperators() {
        Assert.assertTrue((boolean)this.query.getOperators().isEmpty());
    }

    @Test
    public void getRowSignature() {
        Assert.assertEquals((long)0L, (long)this.query.getRowSignature().size());
    }

    @Test
    public void hasFilters() {
        Assert.assertFalse((boolean)this.query.hasFilters());
    }

    @Test
    public void getFilter() {
        Assert.assertNull((Object)this.query.getFilter());
    }

    @Test
    public void getType() {
        Assert.assertEquals((Object)"windowOperator", (Object)this.query.getType());
    }

    @Test
    public void withOverriddenContext() {
        Assert.assertEquals((Object)"sue", (Object)this.query.context().get("sally"));
        QueryContext context = this.query.withOverriddenContext((Map)ImmutableMap.of((Object)"sally", (Object)"soo")).context();
        Assert.assertEquals((Object)"soo", (Object)context.get("sally"));
    }

    @Test
    public void withDataSource() {
        Set tableNames = this.query.getDataSource().getTableNames();
        Assert.assertEquals((long)0L, (long)tableNames.size());
        boolean exceptionThrown = false;
        try {
            this.query.withDataSource((DataSource)new TableDataSource("bob"));
        }
        catch (IAE e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.query, (Object)this.query);
        Assert.assertEquals((Object)this.query, (Object)this.query.withDataSource(this.query.getDataSource()));
        Assert.assertNotEquals((Object)this.query, (Object)this.query.toString());
    }
}

