/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.junit.Assert;
import org.junit.Test;

public class ComposingProcessorTest {
    @Test
    public void testSanity() {
        ProcessorForTesting firstProcessor = new ProcessorForTesting();
        ProcessorForTesting secondProcessor = new ProcessorForTesting();
        ComposingProcessor proc = new ComposingProcessor(new Processor[]{firstProcessor, secondProcessor});
        proc.process(null);
        Assert.assertEquals((long)1L, (long)firstProcessor.processCounter);
        Assert.assertEquals((long)1L, (long)secondProcessor.processCounter);
        proc.process(null);
        Assert.assertEquals((long)2L, (long)firstProcessor.processCounter);
        Assert.assertEquals((long)2L, (long)secondProcessor.processCounter);
        Assert.assertTrue((boolean)proc.validateEquivalent((Processor)proc));
        Assert.assertEquals((long)1L, (long)firstProcessor.validateCounter);
        Assert.assertEquals((long)1L, (long)secondProcessor.validateCounter);
        firstProcessor.validationResult = false;
        Assert.assertFalse((boolean)proc.validateEquivalent((Processor)proc));
        Assert.assertEquals((long)2L, (long)firstProcessor.validateCounter);
        Assert.assertEquals((long)1L, (long)secondProcessor.validateCounter);
    }

    private static class ProcessorForTesting
    implements Processor {
        private int processCounter = 0;
        private int validateCounter = 0;
        private boolean validationResult = true;

        private ProcessorForTesting() {
        }

        public RowsAndColumns process(RowsAndColumns incomingPartition) {
            ++this.processCounter;
            return incomingPartition;
        }

        public boolean validateEquivalent(Processor otherProcessor) {
            ++this.validateCounter;
            return this.validationResult;
        }
    }
}

