/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.druid.query.operator.window.ComposingProcessor;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.ranking.WindowRankProcessor;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Test;

public class WindowRankProcessorTest {
    @Test
    public void testRankProcessing() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("vals", new IntArrayColumn(new int[]{7, 18, 18, 30, 120, 121, 122, 122, 8290, 8290}));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        List<String> orderingCols = Collections.singletonList("vals");
        ComposingProcessor processor = new ComposingProcessor(new Processor[]{new WindowRankProcessor(orderingCols, "rank", false), new WindowRankProcessor(orderingCols, "rankAsPercent", true)});
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("vals", new int[]{7, 18, 18, 30, 120, 121, 122, 122, 8290, 8290}).expectColumn("rank", new int[]{1, 2, 2, 4, 5, 6, 7, 7, 9, 9}).expectColumn("rankAsPercent", new double[]{0.0, 0.1111111111111111, 0.1111111111111111, 0.3333333333333333, 0.4444444444444444, 0.5555555555555556, 0.6666666666666666, 0.6666666666666666, 0.8888888888888888, 0.8888888888888888});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }

    @Test
    public void testRankSingle() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("vals", new IntArrayColumn(new int[]{7}));
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap(map);
        List<String> orderingCols = Collections.singletonList("vals");
        ComposingProcessor processor = new ComposingProcessor(new Processor[]{new WindowRankProcessor(orderingCols, "rank", false), new WindowRankProcessor(orderingCols, "rankAsPercent", true)});
        RowsAndColumnsHelper expectations = new RowsAndColumnsHelper().expectColumn("vals", new int[]{7}).expectColumn("rank", new int[]{1}).expectColumn("rankAsPercent", new double[]{0.0});
        RowsAndColumns results = processor.process((RowsAndColumns)rac);
        expectations.validate(results);
    }
}

