/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.ArrayListRowsAndColumns;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.column.RowSignature;

public class ArrayListRowsAndColumnsTest
extends RowsAndColumnsTestBase {
    @Nonnull
    public static Function<MapOfColumnsRowsAndColumns, ArrayListRowsAndColumns<Object[]>> MAKER = input -> {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(input.numRows());
        ArrayList cols = new ArrayList(input.getColumnNames());
        RowSignature.Builder sigBob = RowSignature.builder();
        for (int i = 0; i < input.numRows(); ++i) {
            rows.add(new Object[cols.size()]);
        }
        for (int colIndex = 0; colIndex < cols.size(); ++colIndex) {
            String col = (String)cols.get(colIndex);
            ColumnAccessor column = input.findColumn(col).toAccessor();
            sigBob.add(col, column.getType());
            for (int i = 0; i < column.numRows(); ++i) {
                ((Object[])rows.get((int)i))[colIndex] = column.getObject(i);
            }
        }
        return new ArrayListRowsAndColumns(rows, columnName -> {
            int i = cols.indexOf(columnName);
            if (i < 0) {
                throw new ISE("Couldn't find column[%s]!? i[%s]", new Object[]{columnName, i});
            }
            return objects -> objects[i];
        }, sigBob.build());
    };

    public ArrayListRowsAndColumnsTest() {
        super(ArrayListRowsAndColumns.class);
    }
}

