/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.ArrayListRowsAndColumns;
import org.apache.druid.query.rowsandcols.ArrayListRowsAndColumnsTest;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumns;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumnsTest;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RearrangedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RearrangedRowsAndColumnsTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class RowsAndColumnsTestBase {
    private final Class<?> expectedClass;
    private static final AtomicReference<Iterable<Object[]>> MAKERS;

    @Nonnull
    private static ArrayList<Object[]> getMakers() {
        return Lists.newArrayList((Object[])new Object[][]{{MapOfColumnsRowsAndColumns.class, Function.identity()}, {ArrayListRowsAndColumns.class, ArrayListRowsAndColumnsTest.MAKER}, {ConcatRowsAndColumns.class, ConcatRowsAndColumnsTest.MAKER}, {RearrangedRowsAndColumns.class, RearrangedRowsAndColumnsTest.MAKER}});
    }

    public static Iterable<Object[]> makerFeeder() {
        Iterable<Object[]> retVal = MAKERS.get();
        if (retVal == null) {
            retVal = RowsAndColumnsTestBase.getMakers();
            for (Object[] objects : retVal) {
                Class aClazz = (Class)objects[0];
                String expectedName = aClazz.getName() + "Test";
                try {
                    Class<?> testClass = Class.forName(expectedName);
                    if (RowsAndColumnsTestBase.class.isAssignableFrom(testClass)) continue;
                    throw new ISE("testClass[%s] doesn't extend RowsAndColumnsTestBase, please extend it.", new Object[]{testClass});
                }
                catch (ClassNotFoundException e) {
                    throw new ISE("aClazz[%s] didn't have test class[%s], please make it", new Object[]{aClazz, expectedName});
                }
            }
            MAKERS.set(retVal);
        }
        return retVal;
    }

    public RowsAndColumnsTestBase(Class<?> expectedClass) {
        this.expectedClass = expectedClass;
    }

    @Test
    public void testInListOfMakers() {
        boolean inList = false;
        for (Object[] objs : RowsAndColumnsTestBase.makerFeeder()) {
            if (!this.expectedClass.equals(objs[0])) continue;
            inList = true;
            break;
        }
        Assert.assertTrue((boolean)inList);
    }

    static {
        NullHandling.initializeForTests();
        MAKERS = new AtomicReference();
    }
}

