/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.DefaultClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;
import org.apache.druid.query.rowsandcols.semantic.NaiveSortMaker;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class CombinedSemanticInterfacesTest
extends SemanticTestBase {
    public CombinedSemanticInterfacesTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testPartitionAggregateAndSortTest() {
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}))));
        ClusteredGroupPartitioner parter = (ClusteredGroupPartitioner)rac.as(ClusteredGroupPartitioner.class);
        if (parter == null) {
            parter = new DefaultClusteredGroupPartitioner(rac);
        }
        ArrayList partitioned = parter.partitionOnBoundaries(Collections.singletonList("sorted"));
        Assert.assertEquals((long)4L, (long)partitioned.size());
        NaiveSortMaker.NaiveSorter sorter = null;
        for (RowsAndColumns rowsAndColumns : partitioned) {
            FramedOnHeapAggregatable aggregatable = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rowsAndColumns);
            RowsAndColumns aggedRAC = aggregatable.aggregateAll(WindowFrame.unbounded(), new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "unsorted")});
            if (sorter == null) {
                sorter = NaiveSortMaker.fromRAC((RowsAndColumns)aggedRAC).make(new ColumnWithDirection[]{ColumnWithDirection.ascending((String)"unsorted")});
                continue;
            }
            Assert.assertNull((Object)sorter.moreData(aggedRAC));
        }
        Assert.assertNotNull(sorter);
        RowsAndColumns completed = sorter.complete();
        Assert.assertNotNull((Object)completed);
        new RowsAndColumnsHelper().expectColumn("sorted", new int[]{1, 4, 0, 4, 1, 0, 0, 2, 4}).expectColumn("unsorted", new int[]{1, 2, 3, 3, 5, 21, 54, 54, 92}).expectColumn("sum", new long[]{6L, 97L, 78L, 97L, 6L, 78L, 78L, 54L, 97L}).allColumnsRegistered().validate(completed);
    }

    @Test
    public void testPartitionThenAggregateNoSortTest() {
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}))));
        ClusteredGroupPartitioner parter = ClusteredGroupPartitioner.fromRAC((RowsAndColumns)rac);
        ArrayList partitioned = parter.partitionOnBoundaries(Collections.singletonList("sorted"));
        Assert.assertEquals((long)4L, (long)partitioned.size());
        LinkedHashMap<String, ObjectArrayColumn> outputCols = new LinkedHashMap<String, ObjectArrayColumn>();
        outputCols.put("sorted", new ObjectArrayColumn(new Object[9], ColumnType.LONG));
        outputCols.put("unsorted", new ObjectArrayColumn(new Object[9], ColumnType.LONG));
        outputCols.put("sum", new ObjectArrayColumn(new Object[9], ColumnType.LONG));
        int rowCounter = 0;
        for (RowsAndColumns rowsAndColumns : partitioned) {
            FramedOnHeapAggregatable aggregatable = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rowsAndColumns);
            RowsAndColumns aggedRAC = aggregatable.aggregateAll(WindowFrame.unbounded(), new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "unsorted")});
            for (Map.Entry entry : outputCols.entrySet()) {
                Object[] objArray = ((ObjectArrayColumn)entry.getValue()).getObjects();
                ColumnAccessor columnAccessor = aggedRAC.findColumn((String)entry.getKey()).toAccessor();
                for (int i = 0; i < columnAccessor.numRows(); ++i) {
                    objArray[rowCounter + i] = columnAccessor.getObject(i);
                }
            }
            rowCounter += aggedRAC.numRows();
        }
        MapOfColumnsRowsAndColumns completed = MapOfColumnsRowsAndColumns.fromMap(outputCols);
        new RowsAndColumnsHelper().expectColumn("sorted", new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}).expectColumn("unsorted", new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92}).expectColumn("sum", new long[]{78L, 78L, 78L, 6L, 6L, 54L, 97L, 97L, 97L}).allColumnsRegistered().validate((RowsAndColumns)completed);
    }
}

