/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Test;

public class FramedOnHeapAggregatableTest
extends SemanticTestBase {
    public FramedOnHeapAggregatableTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRowsNoOffsets() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 0, false, 0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 1, false, 2), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{3L, 6L, 10L, 14L, 18L, 22L, 26L, 30L, 24L, 17L}).expectColumn("maxFromInt", new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 9.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRowsOnlyUpper() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 0, false, 2), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{3L, 6L, 9L, 12L, 15L, 18L, 21L, 24L, 17L, 9L}).expectColumn("maxFromInt", new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 9.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowSmallerThanRowsOnlyLower() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 2, false, 0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{0L, 1L, 3L, 6L, 9L, 12L, 15L, 18L, 21L, 24L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowLargerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 5, false, 7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{28L, 36L, 45L, 45L, 45L, 45L, 45L, 44L, 42L, 39L}).expectColumn("maxFromInt", new double[]{7.0, 8.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).expectColumn("longMin", new long[]{0L, 0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L, 4L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationLowerLargerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 5, false, 1), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{1L, 3L, 3L}).expectColumn("maxFromInt", new double[]{1.0, 2.0, 2.0}).expectColumn("longMin", new long[]{0L, 0L, 0L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationLowerLargerThanRowsNoUpper() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 5, false, 0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{0L, 1L, 3L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0}).expectColumn("longMin", new long[]{0L, 0L, 0L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationUpperLargerThanRows() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 1, false, 7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{3L, 3L, 3L}).expectColumn("maxFromInt", new double[]{2.0, 2.0, 2.0}).expectColumn("longMin", new long[]{0L, 0L, 1L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationUpperLargerThanRowsNoLower() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 0, false, 7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2}).expectColumn("sumFromLong", new long[]{3L, 3L, 2L}).expectColumn("maxFromInt", new double[]{2.0, 2.0, 2.0}).expectColumn("longMin", new long[]{0L, 1L, 2L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowLargerThanRowsOnlyUpper() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 0, false, 7), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{28L, 36L, 44L, 42L, 39L, 35L, 30L, 24L, 17L, 9L}).expectColumn("maxFromInt", new double[]{7.0, 8.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).expectColumn("longMin", new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testWindowedAggregationWindowLargerThanRowsOnlyLower() {
        LinkedHashMap<String, IntArrayColumn> map = new LinkedHashMap<String, IntArrayColumn>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 5, false, 0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new LongMinAggregatorFactory("longMin", "intCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("sumFromLong", new long[]{0L, 1L, 3L, 6L, 10L, 15L, 21L, 27L, 33L, 39L}).expectColumn("maxFromInt", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("longMin", new long[]{0L, 0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L, 4L}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testUnboundedWindowedAggregation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, true, 0, true, 0), new AggregatorFactory[]{new LongSumAggregatorFactory("sumFromLong", "intCol"), new LongSumAggregatorFactory("sumFromDouble", "doubleCol"), new DoubleMaxAggregatorFactory("maxFromInt", "intCol"), new DoubleMaxAggregatorFactory("maxFromDouble", "doubleCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("objectCol", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING).expectColumn("sumFromLong", new long[]{45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L}).expectColumn("sumFromDouble", new long[]{45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L, 45L}).expectColumn("maxFromInt", new double[]{9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).expectColumn("maxFromDouble", new double[]{9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testCumulativeAggregation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, true, 0, false, 0), new AggregatorFactory[]{new LongMaxAggregatorFactory("cummMax", "intCol"), new DoubleSumAggregatorFactory("cummSum", "doubleCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("objectCol", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING).expectColumn("cummMax", new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L}).expectColumn("cummSum", new double[]{0.0, 1.0, 3.0, 6.0, 10.0, 15.0, 21.0, 28.0, 36.0, 45.0}).allColumnsRegistered().validate(results);
    }

    @Test
    public void testReverseCumulativeAggregation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("intCol", new IntArrayColumn(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}));
        map.put("doubleCol", new DoubleArrayColumn(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}));
        map.put("objectCol", new ObjectArrayColumn((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING));
        RowsAndColumns rac = this.make(MapOfColumnsRowsAndColumns.fromMap(map));
        FramedOnHeapAggregatable agger = FramedOnHeapAggregatable.fromRAC((RowsAndColumns)rac);
        RowsAndColumns results = agger.aggregateAll(new WindowFrame(WindowFrame.PeerType.ROWS, false, 0, true, 0), new AggregatorFactory[]{new LongMaxAggregatorFactory("cummMax", "intCol"), new DoubleSumAggregatorFactory("cummSum", "doubleCol")});
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}).expectColumn("doubleCol", new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0}).expectColumn("objectCol", new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, ColumnType.STRING).expectColumn("cummMax", new long[]{9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L}).expectColumn("cummSum", new double[]{45.0, 45.0, 44.0, 42.0, 39.0, 35.0, 30.0, 24.0, 17.0, 9.0}).allColumnsRegistered().validate(results);
    }
}

