/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.Druids;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedDataScanQueryTest
extends InitializedNullHandlingTest {
    private static final Logger LOG = new Logger(NestedDataScanQueryTest.class);
    private final AggregationTestHelper helper;
    private final Closer closer;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    public NestedDataScanQueryTest() {
        NestedDataModule.registerHandlersAndSerde();
        List mods = NestedDataModule.getJacksonModulesList();
        this.helper = AggregationTestHelper.createScanQueryAggregationTestHelper(mods, this.tempFolder);
        this.closer = Closer.create();
    }

    @Test
    public void testIngestAndScanSegments() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSimpleNestedTestDataSegments(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestAndScanSegmentsRollup() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.long", "long")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList segs = ImmutableList.builder().addAll(NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-numeric-test-data.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, NestedDataTestUtils.COUNT, Granularities.YEAR, true, IndexSpec.DEFAULT)).build();
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testIngestAndScanSegmentsRealtime() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1"), new NestedFieldVirtualColumn("nester", "$.", "nester_root"), new NestedFieldVirtualColumn("dim", "$", "dim_root"), new NestedFieldVirtualColumn("dim", "$.x", "dim_path"), new NestedFieldVirtualColumn("count", "$", "count_root"), new NestedFieldVirtualColumn("count", "$.x", "count_path")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createSimpleNestedTestDataIncrementalIndex(this.tempFolder));
        List<Segment> segs = NestedDataTestUtils.createSimpleNestedTestDataSegments(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        if (NullHandling.sqlCompatible()) {
            Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
        }
    }

    @Test
    public void testIngestAndScanSegmentsRealtimeWithFallback() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).columns(new String[]{"x", "x_0", "y_c_1"}).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "x", ColumnType.LONG, null, Boolean.valueOf(true), "$.x", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "x_0", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.x[0]", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "y_c_1", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.y.c[1]", Boolean.valueOf(false)), new NestedFieldVirtualColumn("nester", "nester_root", ColumnType.NESTED_DATA, null, Boolean.valueOf(true), "$.", Boolean.valueOf(false))}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createSimpleNestedTestDataIncrementalIndex(this.tempFolder));
        List<Segment> segs = NestedDataTestUtils.createSimpleNestedTestDataSegments(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
    }

    @Test
    public void testIngestAndScanSegmentsTsvV4() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSimpleSegmentsTsvV4(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestAndScanSegmentsTsv() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x"), new NestedFieldVirtualColumn("nester", "$.x[0]", "x_0"), new NestedFieldVirtualColumn("nester", "$.y.c[1]", "y_c_1")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSimpleSegmentsTsv(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestWithMergesAndScanSegments() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSegmentsForJsonInput(this.tempFolder, this.closer, "nested-simple-test-data.json", Granularities.HOUR, true, IndexSpec.DEFAULT);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestWithMoreMergesAndScanSegments() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSegmentsWithConcatenatedJsonInput(this.tempFolder, this.closer, "nested-simple-test-data.json", Granularities.HOUR, false, 10, 1);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)80L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testIngestWithMoreMergesAndScanSegmentsRollup() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSegmentsWithConcatenatedJsonInput(this.tempFolder, this.closer, "nested-simple-test-data.json", Granularities.YEAR, true, 100, 1);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)8L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
        NestedDataScanQueryTest.logResults(results);
    }

    @Test
    public void testIngestAndScanSegmentsAndFilter() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x")}).filters((DimFilter)new SelectorDimFilter("x", "200", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSimpleNestedTestDataSegments(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testIngestAndScanSegmentsAndRangeFilter() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).virtualColumns(new VirtualColumn[]{new NestedFieldVirtualColumn("nest", "$.x", "x")}).filters((DimFilter)new BoundDimFilter("x", "100", "300", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        List<Segment> segs = NestedDataTestUtils.createSimpleNestedTestDataSegments(this.tempFolder, this.closer);
        Sequence seq = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List results = seq.toList();
        NestedDataScanQueryTest.logResults(results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)4L, (long)((List)((ScanResultValue)results.get(0)).getEvents()).size());
    }

    @Test
    public void testIngestAndScanSegmentsRealtimeSchemaDiscovery() throws Exception {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of()).build();
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createIncrementalIndex(this.tempFolder, "nested-types-test-data.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, NestedDataTestUtils.COUNT, Granularities.DAY, true));
        List<Segment> segs = NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-types-test-data.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, NestedDataTestUtils.COUNT, Granularities.DAY, true, IndexSpec.DEFAULT);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        Assert.assertEquals((Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString());
    }

    @Test
    public void testIngestAndScanSegmentsRealtimeSchemaDiscoveryArrayTypes() throws Exception {
        Druids.ScanQueryBuilder builder = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of());
        ScanQuery scanQuery = builder.build();
        AggregatorFactory[] aggs = new AggregatorFactory[]{new CountAggregatorFactory("count")};
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createIncrementalIndex(this.tempFolder, "nested-array-test-data.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, aggs, Granularities.NONE, true));
        List<Segment> segs = NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-array-test-data.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, aggs, Granularities.NONE, true, IndexSpec.DEFAULT);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
    }

    @Test
    public void testIngestAndScanSegmentsRealtimeSchemaDiscoveryMoreArrayTypes() throws Exception {
        Druids.ScanQueryBuilder builder = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of());
        ScanQuery scanQuery = builder.build();
        AggregatorFactory[] aggs = new AggregatorFactory[]{new CountAggregatorFactory("count")};
        ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createIncrementalIndex(this.tempFolder, "nested-array-test-data-2.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, aggs, Granularities.NONE, true));
        List<Segment> segs = NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-array-test-data-2.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, aggs, Granularities.NONE, true, IndexSpec.DEFAULT);
        Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
        Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
        List resultsRealtime = seq.toList();
        List resultsSegments = seq2.toList();
        NestedDataScanQueryTest.logResults(resultsSegments);
        NestedDataScanQueryTest.logResults(resultsRealtime);
        Assert.assertEquals((long)1L, (long)resultsRealtime.size());
        Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
        Assert.assertEquals((Object)"[[978652800000, [A, A], [null, null], [1, 1], [0.1, 0.1], [true, true], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1], [978739200000, [A, A], [null, null], [1, 1], [0.1, 0.1], [true, true], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1], [978825600000, [A, A], [null, null], [1, 1], [0.1, 0.1], [true, true], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1], [978912000000, [A, A], [null, null], [1, 1], [0.1, 0.1], [true, true], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1]]", (Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString());
        Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestAndScanSegmentsRealtimeSchemaDiscoveryMoreArrayTypesStrictBooleans() throws Exception {
        try {
            ExpressionProcessing.initializeForStrictBooleansTests((boolean)true);
            Druids.ScanQueryBuilder builder = Druids.newScanQueryBuilder().dataSource("test_datasource").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(100L).context((Map)ImmutableMap.of());
            ScanQuery scanQuery = builder.build();
            AggregatorFactory[] aggs = new AggregatorFactory[]{new CountAggregatorFactory("count")};
            ImmutableList realtimeSegs = ImmutableList.of((Object)NestedDataTestUtils.createIncrementalIndex(this.tempFolder, "nested-array-test-data-2.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, aggs, Granularities.NONE, true));
            List<Segment> segs = NestedDataTestUtils.createSegments(this.tempFolder, this.closer, "nested-array-test-data-2.json", (InputFormat)NestedDataTestUtils.DEFAULT_JSON_INPUT_FORMAT, NestedDataTestUtils.TIMESTAMP_SPEC, NestedDataTestUtils.AUTO_DISCOVERY, TransformSpec.NONE, aggs, Granularities.NONE, true, IndexSpec.DEFAULT);
            Sequence seq = this.helper.runQueryOnSegmentsObjs((List<Segment>)realtimeSegs, scanQuery);
            Sequence seq2 = this.helper.runQueryOnSegmentsObjs(segs, scanQuery);
            List resultsRealtime = seq.toList();
            List resultsSegments = seq2.toList();
            NestedDataScanQueryTest.logResults(resultsSegments);
            NestedDataScanQueryTest.logResults(resultsRealtime);
            Assert.assertEquals((long)1L, (long)resultsRealtime.size());
            Assert.assertEquals((long)resultsRealtime.size(), (long)resultsSegments.size());
            Assert.assertEquals((Object)"[[978652800000, [A, A], [null, null], [1, 1], [0.1, 0.1], [1, 1], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1], [978739200000, [A, A], [null, null], [1, 1], [0.1, 0.1], [1, 1], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1], [978825600000, [A, A], [null, null], [1, 1], [0.1, 0.1], [1, 1], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1], [978912000000, [A, A], [null, null], [1, 1], [0.1, 0.1], [1, 1], [null, null], {s_str1=[A, A], s_str2=[null, null], s_num_int=[1, 1], s_num_float=[0.1, 0.1], s_bool=[true, true], s_null=[null, null]}, 1]]", (Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString());
            Assert.assertEquals((Object)((ScanResultValue)resultsSegments.get(0)).getEvents().toString(), (Object)((ScanResultValue)resultsRealtime.get(0)).getEvents().toString());
        }
        finally {
            ExpressionProcessing.initializeForTests();
        }
    }

    private static void logResults(List<ScanResultValue> results) {
        StringBuilder bob = new StringBuilder();
        int ctr = 0;
        for (Object event : (List)results.get(0).getEvents()) {
            bob.append("row:").append(++ctr).append(" - ").append(event).append("\n");
        }
        LOG.info("results:\n%s", new Object[]{bob});
    }
}

