/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class ScanQueryQueryToolChestTest {
    private static final List<Object[]> ARRAY_RESULTS = ImmutableList.of((Object)new Object[]{null, 3.2}, (Object)new Object[]{"x", "y"});
    private final ScanQueryQueryToolChest toolChest = new ScanQueryQueryToolChest(new ScanQueryConfig(), (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory());

    @Test
    public void test_resultArraySignature_columnsNotSpecified() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).build();
        Assert.assertEquals((Object)RowSignature.empty(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultArraySignature_columnsNotSpecifiedLegacyMode() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).legacy(Boolean.valueOf(true)).build();
        Assert.assertEquals((Object)RowSignature.empty(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultArraySignature_columnsSpecified() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).build();
        Assert.assertEquals((Object)RowSignature.builder().add("foo", null).add("bar", null).build(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultArraySignature_columnsSpecifiedLegacyMode() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).legacy(Boolean.valueOf(true)).build();
        Assert.assertEquals((Object)RowSignature.builder().add("timestamp", null).add("foo", null).add("bar", null).build(), (Object)this.toolChest.resultArraySignature(scanQuery));
    }

    @Test
    public void test_resultsAsArrays_columnsNotSpecifiedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[0], (Object)new Object[0]), (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults(ScanQuery.ResultFormat.RESULT_FORMAT_LIST)));
    }

    @Test
    public void test_resultsAsArrays_columnsNotSpecifiedCompactedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals((List<Object[]>)ImmutableList.of((Object)new Object[0], (Object)new Object[0]), (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)));
    }

    @Test
    public void test_resultsAsArrays_columnsSpecifiedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals(ARRAY_RESULTS, (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults(ScanQuery.ResultFormat.RESULT_FORMAT_LIST)));
    }

    @Test
    public void test_resultsAsArrays_columnsSpecifiedCompactedListResults() {
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2000/3000")))).columns(new String[]{"foo", "bar"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        QueryToolChestTestHelper.assertArrayResultsEquals(ARRAY_RESULTS, (Sequence<Object[]>)this.toolChest.resultsAsArrays(scanQuery, ScanQueryQueryToolChestTest.makeResults(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST)));
    }

    private static Sequence<ScanResultValue> makeResults(ScanQuery.ResultFormat resultFormat) {
        ArrayList rows = new ArrayList();
        switch (resultFormat) {
            case RESULT_FORMAT_LIST: {
                ARRAY_RESULTS.forEach(arr -> {
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("foo", arr[0]);
                    m.put("bar", arr[1]);
                    rows.add(m);
                });
                break;
            }
            case RESULT_FORMAT_COMPACTED_LIST: {
                ARRAY_RESULTS.forEach(arr -> rows.add(Arrays.asList(arr)));
                break;
            }
            default: {
                throw new ISE("Cannot generate resultFormat '%s'", new Object[]{resultFormat});
            }
        }
        return Sequences.simple((Iterable)ImmutableList.of((Object)new ScanResultValue(null, (List)ImmutableList.of((Object)"foo", (Object)"bar"), rows)));
    }
}

