/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanQueryRunnerTest;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.DateTime;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnnestScanQueryRunnerTest
extends InitializedNullHandlingTest {
    public static final QuerySegmentSpec I_0112_0114 = ScanQueryRunnerTest.I_0112_0114;
    private static final ScanQueryQueryToolChest TOOL_CHEST = new ScanQueryQueryToolChest(new ScanQueryConfig(), DefaultGenericQueryMetricsFactory.instance());
    private static final ScanQueryRunnerFactory FACTORY = new ScanQueryRunnerFactory(TOOL_CHEST, new ScanQueryEngine(), new ScanQueryConfig());
    private final IncrementalIndex index;
    private final boolean legacy;

    public UnnestScanQueryRunnerTest(IncrementalIndex index, boolean legacy) {
        this.index = index;
        this.legacy = legacy;
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        NullHandling.initializeForTests();
        IncrementalIndex rtIndex = TestIndex.getIncrementalTestIndex();
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        constructors.add(new Object[]{rtIndex, true});
        constructors.add(new Object[]{rtIndex, false});
        return constructors;
    }

    private Druids.ScanQueryBuilder newTestUnnestQuery() {
        return Druids.newScanQueryBuilder().dataSource(QueryRunnerTestHelper.UNNEST_DATA_SOURCE).columns(Collections.emptyList()).eternityInterval().limit(3L).legacy(Boolean.valueOf(this.legacy));
    }

    @Test
    public void testScanOnUnnest() {
        ScanQuery query = this.newTestUnnestQuery().intervals(I_0112_0114).columns(new String[]{"placementish_unnest"}).limit(3L).build();
        QueryRunner queryRunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(FACTORY, (Segment)new IncrementalIndexSegment(this.index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List results = queryRunner.run(QueryPlus.wrap((Query)query)).toList();
        String[] columnNames = this.legacy ? new String[]{this.getTimestampName() + ":TIME", "placementish_unnest"} : new String[]{"placementish_unnest"};
        String[] values = this.legacy ? new String[]{"2011-01-12T00:00:00.000Z\ta", "2011-01-12T00:00:00.000Z\tpreferred", "2011-01-12T00:00:00.000Z\tb"} : new String[]{"a", "preferred", "b"};
        List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(columnNames, this.legacy, new String[][]{values});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "placementish_unnest"}) : Collections.singletonList("placementish_unnest"), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testUnnestRunnerVirtualColumnsUsingSingleColumn() {
        ScanQuery query = Druids.newScanQueryBuilder().intervals(I_0112_0114).dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "mv_to_array(placementish)", ColumnType.STRING, TestExprMacroTable.INSTANCE), null)).columns(new String[]{"placementish_unnest"}).eternityInterval().legacy(Boolean.valueOf(this.legacy)).limit(3L).build();
        QueryRunner vcrunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(FACTORY, (Segment)new IncrementalIndexSegment(this.index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List results = vcrunner.run(QueryPlus.wrap((Query)query)).toList();
        String[] columnNames = this.legacy ? new String[]{this.getTimestampName() + ":TIME", "placementish_unnest"} : new String[]{"placementish_unnest"};
        String[] values = this.legacy ? new String[]{"2011-01-12T00:00:00.000Z\ta", "2011-01-12T00:00:00.000Z\tpreferred", "2011-01-12T00:00:00.000Z\tb"} : new String[]{"a", "preferred", "b"};
        List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(columnNames, this.legacy, new String[][]{values});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "placementish_unnest"}) : Collections.singletonList("placementish_unnest"), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testUnnestRunnerVirtualColumnsUsingMultipleColumn() {
        ScanQuery query = Druids.newScanQueryBuilder().intervals(I_0112_0114).dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "array(\"market\",\"quality\")", ColumnType.STRING, TestExprMacroTable.INSTANCE), null)).columns(new String[]{"market", "placementish_unnest"}).eternityInterval().legacy(Boolean.valueOf(this.legacy)).limit(4L).build();
        QueryRunner vcrunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(FACTORY, (Segment)new IncrementalIndexSegment(this.index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List results = vcrunner.run(QueryPlus.wrap((Query)query)).toList();
        String[] columnNames = this.legacy ? new String[]{this.getTimestampName() + ":TIME", "market", "placementish_unnest"} : new String[]{"market", "placementish_unnest"};
        String[] values = this.legacy ? new String[]{"2011-01-12T00:00:00.000Z\tspot\tspot", "2011-01-12T00:00:00.000Z\tspot\tautomotive", "2011-01-12T00:00:00.000Z\tspot\tspot", "2011-01-12T00:00:00.000Z\tspot\tbusiness"} : new String[]{"spot\tspot", "spot\tautomotive", "spot\tspot", "spot\tbusiness"};
        List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(columnNames, this.legacy, new String[][]{values});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "market", "placementish_unnest"}) : Lists.newArrayList((Object[])new String[]{"market", "placementish_unnest"}), 0, 4);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testUnnestRunnerWithFilter() {
        ScanQuery query = this.newTestUnnestQuery().intervals(I_0112_0114).columns(new String[]{"placementish_unnest"}).limit(3L).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).build();
        QueryRunner queryRunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(FACTORY, (Segment)new IncrementalIndexSegment(this.index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List results = queryRunner.run(QueryPlus.wrap((Query)query)).toList();
        String[] columnNames = this.legacy ? new String[]{this.getTimestampName() + ":TIME", "placementish_unnest"} : new String[]{"placementish_unnest"};
        String[] values = this.legacy ? new String[]{"2011-01-12T00:00:00.000Z\ta", "2011-01-12T00:00:00.000Z\tpreferred", "2011-01-12T00:00:00.000Z\tb"} : new String[]{"a", "preferred", "b"};
        List<List<Map<String, Object>>> events = ScanQueryRunnerTest.toEvents(columnNames, this.legacy, new String[][]{values});
        List<ScanResultValue> expectedResults = this.toExpected(events, this.legacy ? Lists.newArrayList((Object[])new String[]{this.getTimestampName(), "placementish_unnest"}) : Collections.singletonList("placementish_unnest"), 0, 3);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    @Test
    public void testUnnestRunnerWithOrdering() {
        ScanQuery query = this.newTestUnnestQuery().intervals(I_0112_0114).columns(new String[]{"__time", "placementish_unnest"}).limit(3L).filters((DimFilter)new SelectorDimFilter("market", "spot", null)).order(ScanQuery.Order.ASCENDING).build();
        QueryRunner queryRunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(FACTORY, (Segment)new IncrementalIndexSegment(this.index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List results = queryRunner.run(QueryPlus.wrap((Query)query)).toList();
        String[] columnNames = this.legacy ? new String[]{this.getTimestampName() + ":TIME", "placementish_unnest"} : new String[]{"__time", "placementish_unnest"};
        String[] values = new String[]{"2011-01-12T00:00:00.000Z\ta", "2011-01-12T00:00:00.000Z\tpreferred", "2011-01-12T00:00:00.000Z\tb"};
        List<List<Map<String, Object>>> ascendingEvents = ScanQueryRunnerTest.toEvents(columnNames, this.legacy, new String[][]{values});
        if (this.legacy) {
            for (List<Map<String, Object>> batch : ascendingEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", ((DateTime)event.get("timestamp")).getMillis());
                }
            }
        } else {
            for (List<Map<String, Object>> batch : ascendingEvents) {
                for (Map<String, Object> event : batch) {
                    event.put("__time", DateTimes.of((String)((String)event.get("__time"))).getMillis());
                }
            }
        }
        List<ScanResultValue> ascendingExpectedResults = this.toExpected(ascendingEvents, this.legacy ? Lists.newArrayList((Object[])new String[]{"__time", this.getTimestampName(), "placementish_unnest"}) : Lists.newArrayList((Object[])new String[]{"__time", "placementish_unnest"}), 0, 3);
        ScanQueryRunnerTest.verify(ascendingExpectedResults, results);
    }

    private String getTimestampName() {
        return this.legacy ? "timestamp" : "__time";
    }

    private List<ScanResultValue> toExpected(List<List<Map<String, Object>>> targets, List<String> columns, int offset, int limit) {
        ArrayList expected = Lists.newArrayListWithExpectedSize((int)targets.size());
        for (List<Map<String, Object>> group : targets) {
            ArrayList events = Lists.newArrayListWithExpectedSize((int)limit);
            int end = Math.min(group.size(), offset + limit);
            if (end == 0) {
                end = group.size();
            }
            events.addAll(group.subList(offset, end));
            expected.add(new ScanResultValue(QueryRunnerTestHelper.SEGMENT_ID.toString(), columns, (Object)events));
        }
        return expected;
    }
}

