/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TestQueryRunners;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNUnionQueryTest
extends InitializedNullHandlingTest {
    private static final Closer RESOURCE_CLOSER = Closer.create();
    private final QueryRunner runner;

    @AfterClass
    public static void teardown() throws IOException {
        RESOURCE_CLOSER.close();
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        CloseableStupidPool<ByteBuffer> defaultPool = TestQueryRunners.createDefaultNonBlockingPool();
        CloseableStupidPool customPool = new CloseableStupidPool("TopNQueryRunnerFactory-bufferPool", () -> ByteBuffer.allocate(2000));
        return QueryRunnerTestHelper.cartesian(Iterables.concat(QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(defaultPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(customPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER))));
    }

    public TopNUnionQueryTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Test
    public void testTopNUnionQuery() {
        TopNQuery query = new TopNQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.UNION_DATA_SOURCE).granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT, QueryRunnerTestHelper.DEPENDENT_POST_AGG, QueryRunnerTestHelper.hyperUniqueFinalizingPostAgg}).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)744L).put((Object)"index", (Object)862719.3151855469).put((Object)"addRowsIndexConstant", (Object)863464.3151855469).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)864209.3151855469).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)744L).put((Object)"index", (Object)768184.4240722656).put((Object)"addRowsIndexConstant", (Object)768929.4240722656).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)769674.4240722656).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)3348L).put((Object)"index", (Object)382426.28929138184).put((Object)"addRowsIndexConstant", (Object)385775.28929138184).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)389124.28929138184).put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        TestHelper.assertExpectedResults(expectedResults, this.runner.run(QueryPlus.wrap((Query)query)));
    }
}

