/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.druid.collections.bitmap.BitSetBitmapFactory;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.segment.BitmapOffset;
import org.apache.druid.segment.data.Offset;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BitmapOffsetTest {
    private static final int[] TEST_VALS = new int[]{1, 2, 4, 291, 27412, 49120, 212312, 2412101};
    private static final int[] TEST_VALS_FLIP = new int[]{2412101, 212312, 49120, 27412, 291, 4, 2, 1};
    private final BitmapFactory factory;
    private final boolean descending;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return Iterables.transform((Iterable)Sets.cartesianProduct((Set[])new Set[]{ImmutableSet.of((Object)new ConciseBitmapFactory(), (Object)new RoaringBitmapFactory(), (Object)new BitSetBitmapFactory()), ImmutableSet.of((Object)false, (Object)true)}), (Function)new Function<List<?>, Object[]>(){

            public Object[] apply(List<?> input) {
                return input.toArray();
            }
        });
    }

    public BitmapOffsetTest(BitmapFactory factory, boolean descending) {
        this.factory = factory;
        this.descending = descending;
    }

    @Test
    public void testSanity() {
        MutableBitmap mutable = this.factory.makeEmptyMutableBitmap();
        for (int val : TEST_VALS) {
            mutable.add(val);
        }
        ImmutableBitmap bitmap = this.factory.makeImmutableBitmap(mutable);
        BitmapOffset offset = BitmapOffset.of((ImmutableBitmap)bitmap, (boolean)this.descending, (long)bitmap.size());
        int[] expected = this.descending ? TEST_VALS_FLIP : TEST_VALS;
        int count = 0;
        while (offset.withinBounds()) {
            Assert.assertEquals((long)expected[count], (long)offset.getOffset());
            int cloneCount = count;
            Offset clonedOffset = offset.clone();
            while (clonedOffset.withinBounds()) {
                Assert.assertEquals((long)expected[cloneCount], (long)clonedOffset.getOffset());
                ++cloneCount;
                clonedOffset.increment();
            }
            ++count;
            offset.increment();
        }
        Assert.assertEquals((long)count, (long)expected.length);
    }
}

