/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.SegmentId;

public class IndexBuilder {
    private static final int ROWS_PER_INDEX_FOR_MERGING = 1;
    private static final int DEFAULT_MAX_ROWS = Integer.MAX_VALUE;
    private final ObjectMapper jsonMapper;
    private final IndexIO indexIO;
    private final List<InputRow> rows = new ArrayList<InputRow>();
    private SegmentWriteOutMediumFactory segmentWriteOutMediumFactory = OffHeapMemorySegmentWriteOutMediumFactory.instance();
    private IndexMerger indexMerger;
    private File tmpDir;
    private IndexSpec indexSpec = IndexSpec.DEFAULT;
    private int maxRows = Integer.MAX_VALUE;
    private int intermediatePersistSize = 1;
    private IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
    @Nullable
    private InputSource inputSource = null;
    @Nullable
    private InputFormat inputFormat = null;
    @Nullable
    private TransformSpec transformSpec = null;
    @Nullable
    private File inputSourceTmpDir = null;

    private IndexBuilder(ObjectMapper jsonMapper, ColumnConfig columnConfig) {
        this.jsonMapper = jsonMapper;
        this.indexIO = new IndexIO(jsonMapper, columnConfig);
        this.indexMerger = new IndexMergerV9(jsonMapper, this.indexIO, this.segmentWriteOutMediumFactory);
    }

    public static IndexBuilder create() {
        return new IndexBuilder(TestHelper.JSON_MAPPER, TestHelper.NO_CACHE_ALWAYS_USE_INDEXES_COLUMN_CONFIG);
    }

    public static IndexBuilder create(ColumnConfig columnConfig) {
        return new IndexBuilder(TestHelper.JSON_MAPPER, columnConfig);
    }

    public static IndexBuilder create(ObjectMapper jsonMapper) {
        return new IndexBuilder(jsonMapper, TestHelper.NO_CACHE_ALWAYS_USE_INDEXES_COLUMN_CONFIG);
    }

    public static IndexBuilder create(ObjectMapper jsonMapper, ColumnConfig columnConfig) {
        return new IndexBuilder(jsonMapper, columnConfig);
    }

    public IndexBuilder schema(IncrementalIndexSchema schema) {
        this.schema = schema;
        return this;
    }

    public IndexBuilder segmentWriteOutMediumFactory(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.indexMerger = new IndexMergerV9(this.jsonMapper, this.indexIO, segmentWriteOutMediumFactory);
        return this;
    }

    public IndexBuilder writeNullColumns(boolean shouldWriteNullColumns) {
        this.indexMerger = new IndexMergerV9(this.jsonMapper, this.indexIO, this.segmentWriteOutMediumFactory, shouldWriteNullColumns);
        return this;
    }

    public IndexBuilder indexSpec(IndexSpec indexSpec) {
        this.indexSpec = indexSpec;
        return this;
    }

    public IndexBuilder tmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    public IndexBuilder inputSource(InputSource inputSource) {
        this.inputSource = inputSource;
        return this;
    }

    public IndexBuilder inputFormat(InputFormat inputFormat) {
        this.inputFormat = inputFormat;
        return this;
    }

    public IndexBuilder transform(TransformSpec transformSpec) {
        this.transformSpec = transformSpec;
        return this;
    }

    public IndexBuilder inputTmpDir(File inputSourceTmpDir) {
        this.inputSourceTmpDir = inputSourceTmpDir;
        return this;
    }

    public IndexBuilder rows(InputSource inputSource, InputFormat inputFormat, InputRowSchema rowSchema, TransformSpec transformSpec, File tmp) throws IOException {
        this.rows.clear();
        InputSourceReader reader = inputSource.reader(rowSchema, inputFormat, tmp);
        InputSourceReader transformingReader = transformSpec.decorate(reader);
        try (CloseableIterator rowIterator = transformingReader.read();){
            while (rowIterator.hasNext()) {
                this.rows.add((InputRow)rowIterator.next());
            }
        }
        return this;
    }

    public IndexBuilder rows(Iterable<InputRow> rows) {
        this.rows.clear();
        Iterables.addAll(this.rows, rows);
        return this;
    }

    public IndexBuilder maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public IndexBuilder intermediaryPersistSize(int rows) {
        this.intermediatePersistSize = rows;
        return this;
    }

    public IndexBuilder mapSchema(Function<IncrementalIndexSchema, IncrementalIndexSchema> f) {
        this.schema = f.apply(this.schema);
        return this;
    }

    public IncrementalIndex buildIncrementalIndex() {
        if (this.inputSource != null) {
            return IndexBuilder.buildIncrementalIndexWithInputSource(this.schema, this.inputSource, this.inputFormat, this.transformSpec, this.inputSourceTmpDir, this.maxRows);
        }
        return IndexBuilder.buildIncrementalIndexWithRows(this.schema, this.maxRows, this.rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryableIndex buildMMappedIndex() {
        Preconditions.checkNotNull((Object)this.indexMerger, (Object)"indexMerger");
        Preconditions.checkNotNull((Object)this.tmpDir, (Object)"tmpDir");
        try (IncrementalIndex incrementalIndex = this.buildIncrementalIndex();){
            List<QueryableIndexIndexableAdapter> adapters = Collections.singletonList(new QueryableIndexIndexableAdapter(this.indexIO.loadIndex(this.indexMerger.persist(incrementalIndex, new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)})), this.indexSpec, null))));
            QueryableIndex queryableIndex = this.indexIO.loadIndex(this.indexMerger.merge(adapters, this.schema.isRollup(), this.schema.getMetrics(), this.tmpDir, this.schema.getDimensionsSpec(), this.indexSpec, Integer.MAX_VALUE));
            return queryableIndex;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public QueryableIndex buildMMappedMergedIndex() {
        Preconditions.checkNotNull((Object)this.tmpDir, (Object)"tmpDir");
        ArrayList<QueryableIndex> persisted = new ArrayList<QueryableIndex>();
        if (this.inputSource != null) {
            Preconditions.checkNotNull((Object)this.inputSource, (Object)"inputSource");
            Preconditions.checkNotNull((Object)this.inputFormat, (Object)"inputFormat");
            Preconditions.checkNotNull((Object)this.inputSourceTmpDir, (Object)"inputSourceTmpDir");
            TransformSpec transformer = this.transformSpec != null ? this.transformSpec : TransformSpec.NONE;
            InputRowSchema rowSchema = new InputRowSchema(this.schema.getTimestampSpec(), this.schema.getDimensionsSpec(), null);
            InputSourceReader reader = this.inputSource.reader(rowSchema, this.inputFormat, this.inputSourceTmpDir);
            InputSourceReader transformingReader = transformer.decorate(reader);
            return this.mergeIndexes(this.indexMerger, persisted, () -> ((InputSourceReader)transformingReader).read());
        }
        return this.mergeIndexes(this.indexMerger, persisted, () -> CloseableIterators.withEmptyBaggage(this.rows.iterator()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private QueryableIndex mergeIndexes(IndexMerger indexMerger, List<QueryableIndex> persisted, IteratorSupplier iteratorSupplier) {
        try (CloseableIterator<InputRow> rowIterator = iteratorSupplier.get();){
            int i = 0;
            IncrementalIndex incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(this.schema).setMaxRowCount(this.maxRows).build();
            while (rowIterator.hasNext()) {
                if (i < this.intermediatePersistSize) {
                    incrementalIndex.add((InputRow)rowIterator.next());
                    ++i;
                    continue;
                }
                persisted.add(TestHelper.getTestIndexIO().loadIndex(indexMerger.persist(incrementalIndex, new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID().toString()})), this.indexSpec, null)));
                incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(this.schema).setMaxRowCount(this.maxRows).build();
                i = 0;
            }
            if (i != 0) {
                persisted.add(TestHelper.getTestIndexIO().loadIndex(indexMerger.persist(incrementalIndex, new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID().toString()})), this.indexSpec, null)));
            }
            QueryableIndex merged = TestHelper.getTestIndexIO().loadIndex(indexMerger.mergeQueryableIndex(persisted, true, (AggregatorFactory[])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList(this.schema.getMetrics()), AggregatorFactory::getCombiningFactory), AggregatorFactory.class), null, new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID()})), this.indexSpec, this.indexSpec, (ProgressIndicator)new BaseProgressIndicator(), null, -1));
            for (QueryableIndex index : persisted) {
                index.close();
            }
            QueryableIndex queryableIndex = merged;
            return queryableIndex;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RowBasedSegment<InputRow> buildRowBasedSegmentWithoutTypeSignature() {
        return new RowBasedSegment(SegmentId.dummy((String)"IndexBuilder"), Sequences.simple(this.rows), RowAdapters.standardRow(), RowSignature.empty());
    }

    public RowBasedSegment<InputRow> buildRowBasedSegmentWithTypeSignature() {
        try (QueryableIndex index = this.buildMMappedIndex();){
            RowSignature signature = new QueryableIndexStorageAdapter(index).getRowSignature();
            RowBasedSegment rowBasedSegment = new RowBasedSegment(SegmentId.dummy((String)"IndexBuilder"), Sequences.simple(this.rows), RowAdapters.standardRow(), signature);
            return rowBasedSegment;
        }
    }

    public FrameSegment buildFrameSegment(FrameType frameType) {
        try (QueryableIndex index = this.buildMMappedIndex();){
            FrameSegment frameSegment = FrameTestUtil.adapterToFrameSegment((StorageAdapter)new QueryableIndexStorageAdapter(index), frameType, SegmentId.dummy((String)"IndexBuilder"));
            return frameSegment;
        }
    }

    private static IncrementalIndex buildIncrementalIndexWithRows(IncrementalIndexSchema schema, int maxRows, Iterable<InputRow> rows) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        IncrementalIndex incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRows).build();
        for (InputRow row : rows) {
            try {
                incrementalIndex.add(row);
            }
            catch (IndexSizeExceededException e) {
                throw new RuntimeException(e);
            }
        }
        return incrementalIndex;
    }

    private static IncrementalIndex buildIncrementalIndexWithInputSource(IncrementalIndexSchema schema, InputSource inputSource, InputFormat inputFormat, @Nullable TransformSpec transformSpec, File inputSourceTmpDir, int maxRows) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        Preconditions.checkNotNull((Object)inputSource, (Object)"inputSource");
        Preconditions.checkNotNull((Object)inputFormat, (Object)"inputFormat");
        Preconditions.checkNotNull((Object)inputSourceTmpDir, (Object)"inputSourceTmpDir");
        IncrementalIndex incrementalIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRows).build();
        TransformSpec tranformer = transformSpec != null ? transformSpec : TransformSpec.NONE;
        InputRowSchema rowSchema = new InputRowSchema(schema.getTimestampSpec(), schema.getDimensionsSpec(), null);
        InputSourceReader reader = inputSource.reader(rowSchema, inputFormat, inputSourceTmpDir);
        InputSourceReader transformingReader = tranformer.decorate(reader);
        try (CloseableIterator rowIterator = transformingReader.read();){
            while (rowIterator.hasNext()) {
                incrementalIndex.add((InputRow)rowIterator.next());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return incrementalIndex;
    }

    @FunctionalInterface
    static interface IteratorSupplier {
        public CloseableIterator<InputRow> get() throws IOException;
    }
}

