/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;

public class ListCursor
implements Cursor {
    private final List<Object> baseList;
    private int index;

    public ListCursor(List<Object> inputList) {
        this.baseList = inputList;
    }

    public ColumnSelectorFactory getColumnSelectorFactory() {
        return new ColumnSelectorFactory(){

            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return new DimensionSelector(){

                    public IndexedInts getRow() {
                        throw new UnsupportedOperationException();
                    }

                    public ValueMatcher makeValueMatcher(@Nullable String value) {
                        throw new UnsupportedOperationException();
                    }

                    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                        throw new UnsupportedOperationException();
                    }

                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }

                    @Nullable
                    public Object getObject() {
                        if (ListCursor.this.index < ListCursor.this.baseList.size()) {
                            return ListCursor.this.baseList.get(ListCursor.this.index);
                        }
                        return null;
                    }

                    public Class<?> classOfObject() {
                        return Object.class;
                    }

                    public int getValueCardinality() {
                        return -1;
                    }

                    @Nullable
                    public String lookupName(int id) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean nameLookupPossibleInAdvance() {
                        return false;
                    }

                    @Nullable
                    public IdLookup idLookup() {
                        return null;
                    }
                };
            }

            public ColumnValueSelector makeColumnValueSelector(String columnName) {
                return new ColumnValueSelector(){

                    public double getDouble() {
                        return 0.0;
                    }

                    public float getFloat() {
                        return 0.0f;
                    }

                    public long getLong() {
                        return 0L;
                    }

                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }

                    public boolean isNull() {
                        return false;
                    }

                    @Nullable
                    public Object getObject() {
                        if (ListCursor.this.index < ListCursor.this.baseList.size()) {
                            return ListCursor.this.baseList.get(ListCursor.this.index);
                        }
                        return null;
                    }

                    public Class classOfObject() {
                        return Object.class;
                    }
                };
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return null;
            }
        };
    }

    public DateTime getTime() {
        throw new UnsupportedOperationException();
    }

    public void advance() {
        this.advanceUninterruptibly();
        BaseQuery.checkInterrupted();
    }

    public void advanceUninterruptibly() {
        ++this.index;
    }

    public boolean isDone() {
        return this.index > this.baseList.size() - 1;
    }

    public boolean isDoneOrInterrupted() {
        return false;
    }

    public void reset() {
        this.index = 0;
    }
}

