/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.NestedDataColumnIndexer;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NestedDataColumnIndexerTest
extends InitializedNullHandlingTest {
    private static final String TIME_COL = "time";
    private static final String STRING_COL = "string";
    private static final String STRING_ARRAY_COL = "string_array";
    private static final String LONG_COL = "long";
    private static final String DOUBLE_COL = "double";
    private static final String VARIANT_COL = "variant";
    private static final String NESTED_COL = "nested";

    @BeforeClass
    public static void setup() {
        NestedDataModule.registerHandlersAndSerde();
    }

    @Test
    public void testKeySizeEstimation() {
        NestedDataColumnIndexer indexer = new NestedDataColumnIndexer();
        int baseCardinality = NullHandling.sqlCompatible() ? 0 : 2;
        Assert.assertEquals((long)baseCardinality, (long)indexer.getCardinality());
        EncodedKeyComponent key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)"foo"), false);
        Assert.assertEquals((long)228L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 1), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)"foo"), false);
        Assert.assertEquals((long)112L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 1), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)10L, false);
        Assert.assertEquals((long)94L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 2), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)10L, false);
        Assert.assertEquals((long)16L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 2), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)11L, false);
        Assert.assertEquals((long)48L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 3), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L), false);
        Assert.assertEquals((long)276L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L), false);
        Assert.assertEquals((long)56L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L)), false);
        Assert.assertEquals((long)286L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L)), false);
        Assert.assertEquals((long)118L, (long)key.getEffectiveSizeBytes());
        Assert.assertEquals((long)(baseCardinality + 5), (long)indexer.getCardinality());
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)"", false);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)0L, (long)key.getEffectiveSizeBytes());
            Assert.assertEquals((long)(baseCardinality + 6), (long)indexer.getCardinality());
        } else {
            Assert.assertEquals((long)104L, (long)key.getEffectiveSizeBytes());
            Assert.assertEquals((long)(baseCardinality + 6), (long)indexer.getCardinality());
        }
        key = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)0, false);
        if (NullHandling.replaceWithDefault()) {
            Assert.assertEquals((long)16L, (long)key.getEffectiveSizeBytes());
            Assert.assertEquals((long)(baseCardinality + 6), (long)indexer.getCardinality());
        } else {
            Assert.assertEquals((long)48L, (long)key.getEffectiveSizeBytes());
            Assert.assertEquals((long)(baseCardinality + 7), (long)indexer.getCardinality());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootString() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerTest.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, STRING_COL, "a"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, STRING_COL, "b"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, STRING_COL, "c"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, STRING_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, STRING_COL, null));
        IncrementalIndexStorageAdapter storageAdapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.NONE, false, null);
        DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(STRING_COL, STRING_COL, ColumnType.STRING);
        List cursorList = cursorSequence.toList();
        ColumnSelectorFactory columnSelectorFactory = ((Cursor)cursorList.get(0)).getColumnSelectorFactory();
        ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_COL);
        DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)"a", (Object)valueSelector.getObject());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"a", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"a", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(1)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)"b", (Object)valueSelector.getObject());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"b", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"b", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(2)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)"c", (Object)valueSelector.getObject());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"c", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"c", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(3)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertNull((Object)valueSelector.getObject());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertNull((Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(4)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertNull((Object)valueSelector.getObject());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertNull((Object)dimensionSelector.getObject());
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootLong() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerTest.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, LONG_COL, 1L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, LONG_COL, 2L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, LONG_COL, 3L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, LONG_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, LONG_COL, null));
        IncrementalIndexStorageAdapter storageAdapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.NONE, false, null);
        DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(LONG_COL, LONG_COL, ColumnType.LONG);
        List cursorList = cursorSequence.toList();
        ColumnSelectorFactory columnSelectorFactory = ((Cursor)cursorList.get(0)).getColumnSelectorFactory();
        ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(LONG_COL);
        DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)1L, (Object)valueSelector.getObject());
        Assert.assertEquals((long)1L, (long)valueSelector.getLong());
        Assert.assertFalse((boolean)valueSelector.isNull());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"1", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(1)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(LONG_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)2L, (Object)valueSelector.getObject());
        Assert.assertEquals((long)2L, (long)valueSelector.getLong());
        Assert.assertFalse((boolean)valueSelector.isNull());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"2", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"2", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(2)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(LONG_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)3L, (Object)valueSelector.getObject());
        Assert.assertEquals((long)3L, (long)valueSelector.getLong());
        Assert.assertFalse((boolean)valueSelector.isNull());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"3", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"3", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(3)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(LONG_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        if (NullHandling.sqlCompatible()) {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        } else {
            Assert.assertEquals((Object)NullHandling.defaultLongValue(), (Object)valueSelector.getObject());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultLongValue()), (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultLongValue()), (Object)dimensionSelector.getObject());
        }
        columnSelectorFactory = ((Cursor)cursorList.get(4)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(LONG_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        if (NullHandling.sqlCompatible()) {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        } else {
            Assert.assertEquals((Object)NullHandling.defaultLongValue(), (Object)valueSelector.getObject());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultLongValue()), (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultLongValue()), (Object)dimensionSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootDouble() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerTest.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, DOUBLE_COL, 1.1));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, DOUBLE_COL, 2.2));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, DOUBLE_COL, 3.3));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, DOUBLE_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, DOUBLE_COL, null));
        IncrementalIndexStorageAdapter storageAdapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.NONE, false, null);
        DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(DOUBLE_COL, DOUBLE_COL, ColumnType.DOUBLE);
        List cursorList = cursorSequence.toList();
        ColumnSelectorFactory columnSelectorFactory = ((Cursor)cursorList.get(0)).getColumnSelectorFactory();
        ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(DOUBLE_COL);
        DimensionSelector dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)1.1, (Object)valueSelector.getObject());
        Assert.assertEquals((double)1.1, (double)valueSelector.getDouble(), (double)0.0);
        Assert.assertFalse((boolean)valueSelector.isNull());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"1.1", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"1.1", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(1)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(DOUBLE_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)2.2, (Object)valueSelector.getObject());
        Assert.assertEquals((double)2.2, (double)valueSelector.getDouble(), (double)0.0);
        Assert.assertFalse((boolean)valueSelector.isNull());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"2.2", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"2.2", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(2)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(DOUBLE_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        Assert.assertEquals((Object)3.3, (Object)valueSelector.getObject());
        Assert.assertEquals((double)3.3, (double)valueSelector.getDouble(), (double)0.0);
        Assert.assertFalse((boolean)valueSelector.isNull());
        Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
        Assert.assertEquals((Object)"3.3", (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
        Assert.assertEquals((Object)"3.3", (Object)dimensionSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(3)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(DOUBLE_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        if (NullHandling.sqlCompatible()) {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        } else {
            Assert.assertEquals((Object)NullHandling.defaultDoubleValue(), (Object)valueSelector.getObject());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultDoubleValue()), (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultDoubleValue()), (Object)dimensionSelector.getObject());
        }
        columnSelectorFactory = ((Cursor)cursorList.get(4)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(DOUBLE_COL);
        dimensionSelector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)dimensionSpec);
        if (NullHandling.sqlCompatible()) {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertNull((Object)dimensionSelector.getObject());
        } else {
            Assert.assertEquals((Object)NullHandling.defaultDoubleValue(), (Object)valueSelector.getObject());
            Assert.assertFalse((boolean)valueSelector.isNull());
            Assert.assertEquals((long)1L, (long)dimensionSelector.getRow().size());
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultDoubleValue()), (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
            Assert.assertEquals((Object)String.valueOf(NullHandling.defaultDoubleValue()), (Object)dimensionSelector.getObject());
        }
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootStringArray() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerTest.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, STRING_ARRAY_COL, new String[]{"a"}));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, STRING_ARRAY_COL, new Object[]{"b", "c"}));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, STRING_ARRAY_COL, ImmutableList.of((Object)"d", (Object)"e")));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, STRING_ARRAY_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, STRING_ARRAY_COL, null));
        IncrementalIndexStorageAdapter storageAdapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.NONE, false, null);
        DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(STRING_ARRAY_COL, STRING_ARRAY_COL, ColumnType.STRING);
        List cursorList = cursorSequence.toList();
        ColumnSelectorFactory columnSelectorFactory = ((Cursor)cursorList.get(0)).getColumnSelectorFactory();
        ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_ARRAY_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$0(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])((Object[])valueSelector.getObject()));
        columnSelectorFactory = ((Cursor)cursorList.get(1)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_ARRAY_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$1(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertArrayEquals((Object[])new Object[]{"b", "c"}, (Object[])((Object[])valueSelector.getObject()));
        columnSelectorFactory = ((Cursor)cursorList.get(2)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_ARRAY_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$2(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertArrayEquals((Object[])new Object[]{"d", "e"}, (Object[])((Object[])valueSelector.getObject()));
        columnSelectorFactory = ((Cursor)cursorList.get(3)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_ARRAY_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$3(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertNull((Object)valueSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(4)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(STRING_ARRAY_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$4(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertNull((Object)valueSelector.getObject());
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryRootVariant() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerTest.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, VARIANT_COL, "a"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, VARIANT_COL, 2L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, VARIANT_COL, 3.3));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, VARIANT_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, VARIANT_COL, null));
        IncrementalIndexStorageAdapter storageAdapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.NONE, false, null);
        DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(VARIANT_COL, VARIANT_COL, ColumnType.STRING);
        List cursorList = cursorSequence.toList();
        ColumnSelectorFactory columnSelectorFactory = ((Cursor)cursorList.get(0)).getColumnSelectorFactory();
        ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(VARIANT_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$5(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertEquals((Object)StructuredData.wrap((Object)"a"), (Object)valueSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(1)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(VARIANT_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$6(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertEquals((Object)StructuredData.wrap((Object)2L), (Object)valueSelector.getObject());
        Assert.assertFalse((boolean)valueSelector.isNull());
        columnSelectorFactory = ((Cursor)cursorList.get(2)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(VARIANT_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$7(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertEquals((Object)StructuredData.wrap((Object)3.3), (Object)valueSelector.getObject());
        Assert.assertFalse((boolean)valueSelector.isNull());
        columnSelectorFactory = ((Cursor)cursorList.get(3)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(VARIANT_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$8(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertNull((Object)valueSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(4)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(VARIANT_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$9(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertNull((Object)valueSelector.getObject());
    }

    @Test
    public void testNestedColumnIndexerSchemaDiscoveryNested() throws IndexSizeExceededException {
        long minTimestamp = System.currentTimeMillis();
        IncrementalIndex index = NestedDataColumnIndexerTest.makeIncrementalIndex(minTimestamp);
        index.add((InputRow)this.makeInputRow(minTimestamp + 1L, true, NESTED_COL, "a"));
        index.add((InputRow)this.makeInputRow(minTimestamp + 2L, true, NESTED_COL, 2L));
        index.add((InputRow)this.makeInputRow(minTimestamp + 3L, true, NESTED_COL, ImmutableMap.of((Object)"x", (Object)1.1, (Object)"y", (Object)2L)));
        index.add((InputRow)this.makeInputRow(minTimestamp + 4L, true, NESTED_COL, null));
        index.add((InputRow)this.makeInputRow(minTimestamp + 5L, false, NESTED_COL, null));
        IncrementalIndexStorageAdapter storageAdapter = new IncrementalIndexStorageAdapter(index);
        Sequence cursorSequence = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.NONE, false, null);
        DefaultDimensionSpec dimensionSpec = new DefaultDimensionSpec(NESTED_COL, NESTED_COL, ColumnType.STRING);
        List cursorList = cursorSequence.toList();
        ColumnSelectorFactory columnSelectorFactory = ((Cursor)cursorList.get(0)).getColumnSelectorFactory();
        ColumnValueSelector valueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryNested$10(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertEquals((Object)StructuredData.wrap((Object)"a"), (Object)valueSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(1)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryNested$11(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertEquals((Object)StructuredData.wrap((Object)2L), (Object)valueSelector.getObject());
        Assert.assertFalse((boolean)valueSelector.isNull());
        columnSelectorFactory = ((Cursor)cursorList.get(2)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryNested$12(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertEquals((Object)StructuredData.wrap((Object)ImmutableMap.of((Object)"x", (Object)1.1, (Object)"y", (Object)2L)), (Object)valueSelector.getObject());
        Assert.assertFalse((boolean)valueSelector.isNull());
        columnSelectorFactory = ((Cursor)cursorList.get(3)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryNested$13(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertNull((Object)valueSelector.getObject());
        columnSelectorFactory = ((Cursor)cursorList.get(4)).getColumnSelectorFactory();
        valueSelector = columnSelectorFactory.makeColumnValueSelector(NESTED_COL);
        Assert.assertThrows(UnsupportedOperationException.class, () -> NestedDataColumnIndexerTest.lambda$testNestedColumnIndexerSchemaDiscoveryNested$14(cursorList, (DimensionSpec)dimensionSpec));
        Assert.assertNull((Object)valueSelector.getObject());
    }

    @Nonnull
    private static IncrementalIndex makeIncrementalIndex(long minTimestamp) {
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema(minTimestamp, new TimestampSpec(TIME_COL, "millis", null), Granularities.NONE, VirtualColumns.EMPTY, DimensionsSpec.builder().useSchemaDiscovery(true).build(), new AggregatorFactory[0], false)).setMaxRowCount(1000).build();
        return index;
    }

    private MapBasedInputRow makeInputRow(long timestamp, boolean explicitNull, Object ... kv) {
        Map<String, Object> event = TestHelper.makeMap(explicitNull, kv);
        event.put(TIME_COL, timestamp);
        return new MapBasedInputRow(timestamp, (List)ImmutableList.copyOf(event.keySet()), event);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryNested$14(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(4)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryNested$13(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(3)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryNested$12(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(2)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryNested$11(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(1)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryNested$10(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(0)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$9(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(4)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$8(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(3)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$7(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(2)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$6(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(1)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootVariant$5(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(0)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$4(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(4)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$3(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(3)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$2(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(2)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$1(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(1)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }

    private static /* synthetic */ void lambda$testNestedColumnIndexerSchemaDiscoveryRootStringArray$0(List cursorList, DimensionSpec dimensionSpec) throws Throwable {
        ((Cursor)cursorList.get(0)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec);
    }
}

