/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class QueryableIndexColumnCapabilitiesTest
extends InitializedNullHandlingTest {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static IncrementalIndex INC_INDEX;
    private static QueryableIndex MMAP_INDEX;
    private static IncrementalIndex INC_INDEX_WITH_NULLS;
    private static QueryableIndex MMAP_INDEX_WITH_NULLS;

    @BeforeClass
    public static void setup() throws IOException {
        InputRowSchema rowSchema = new InputRowSchema(new TimestampSpec("time", "auto", null), new DimensionsSpec((List)ImmutableList.builder().addAll((Iterable)DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"d1", (Object)"d2"))).add((Object)new DoubleDimensionSchema("d3")).add((Object)new FloatDimensionSchema("d4")).add((Object)new LongDimensionSchema("d5")).build()), null);
        AggregatorFactory[] metricsSpecs = new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "d3"), new FloatSumAggregatorFactory("m2", "d4"), new LongSumAggregatorFactory("m3", "d5"), new HyperUniquesAggregatorFactory("m4", "d1")};
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        ImmutableMap event = ImmutableMap.builder().put((Object)"time", (Object)DateTimes.nowUtc().getMillis()).put((Object)"d1", (Object)"some string").put((Object)"d2", (Object)ImmutableList.of((Object)"some", (Object)"list")).put((Object)"d3", (Object)1.234).put((Object)"d4", (Object)Float.valueOf(1.234f)).put((Object)"d5", (Object)10L).build();
        rows.add(MapInputRowParser.parse((InputRowSchema)rowSchema, (Map)event));
        IndexBuilder builder = IndexBuilder.create().rows(rows).schema(new IncrementalIndexSchema.Builder().withMetrics(metricsSpecs).withDimensionsSpec(rowSchema.getDimensionsSpec()).withRollup(false).build()).tmpDir(temporaryFolder.newFolder());
        INC_INDEX = builder.buildIncrementalIndex();
        MMAP_INDEX = builder.buildMMappedIndex();
        ArrayList<InputRow> rowsWithNulls = new ArrayList<InputRow>();
        rowsWithNulls.add(MapInputRowParser.parse((InputRowSchema)rowSchema, (Map)event));
        HashMap<String, Long> eventWithNulls = new HashMap<String, Long>();
        eventWithNulls.put("time", DateTimes.nowUtc().getMillis());
        eventWithNulls.put("d1", null);
        eventWithNulls.put("d2", (Long)ImmutableList.of());
        eventWithNulls.put("d3", null);
        eventWithNulls.put("d4", null);
        eventWithNulls.put("d5", null);
        rowsWithNulls.add(MapInputRowParser.parse((InputRowSchema)rowSchema, eventWithNulls));
        IndexBuilder builderWithNulls = IndexBuilder.create().rows(rowsWithNulls).schema(new IncrementalIndexSchema.Builder().withMetrics(metricsSpecs).withDimensionsSpec(rowSchema.getDimensionsSpec()).withRollup(false).build()).tmpDir(temporaryFolder.newFolder());
        INC_INDEX_WITH_NULLS = builderWithNulls.buildIncrementalIndex();
        MMAP_INDEX_WITH_NULLS = builderWithNulls.buildMMappedIndex();
    }

    @AfterClass
    public static void teardown() {
        INC_INDEX.close();
        MMAP_INDEX.close();
        INC_INDEX_WITH_NULLS.close();
        MMAP_INDEX_WITH_NULLS.close();
    }

    @Test
    public void testNumericColumns() {
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("__time"), ColumnType.LONG);
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("d3"), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("d4"), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("d5"), ColumnType.LONG);
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("m1"), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("m2"), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilities(INC_INDEX.getColumnCapabilities("m3"), ColumnType.LONG);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("__time").getCapabilities(), ColumnType.LONG);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("d3").getCapabilities(), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("d4").getCapabilities(), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("d5").getCapabilities(), ColumnType.LONG);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("m1").getCapabilities(), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("m2").getCapabilities(), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilities(MMAP_INDEX.getColumnHolder("m3").getCapabilities(), ColumnType.LONG);
    }

    @Test
    public void testNumericColumnsWithNulls() {
        this.assertNonStringColumnCapabilities(INC_INDEX_WITH_NULLS.getColumnCapabilities("__time"), ColumnType.LONG);
        this.assertNonStringColumnCapabilitiesWithNulls(INC_INDEX_WITH_NULLS.getColumnCapabilities("d3"), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilitiesWithNulls(INC_INDEX_WITH_NULLS.getColumnCapabilities("d4"), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilitiesWithNulls(INC_INDEX_WITH_NULLS.getColumnCapabilities("d5"), ColumnType.LONG);
        this.assertNonStringColumnCapabilitiesWithNulls(INC_INDEX_WITH_NULLS.getColumnCapabilities("m1"), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilitiesWithNulls(INC_INDEX_WITH_NULLS.getColumnCapabilities("m2"), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilitiesWithNulls(INC_INDEX_WITH_NULLS.getColumnCapabilities("m3"), ColumnType.LONG);
        this.assertNonStringColumnCapabilities(MMAP_INDEX_WITH_NULLS.getColumnHolder("__time").getCapabilities(), ColumnType.LONG);
        this.assertNonStringColumnCapabilitiesWithNulls(MMAP_INDEX_WITH_NULLS.getColumnHolder("d3").getCapabilities(), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilitiesWithNulls(MMAP_INDEX_WITH_NULLS.getColumnHolder("d4").getCapabilities(), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilitiesWithNulls(MMAP_INDEX_WITH_NULLS.getColumnHolder("d5").getCapabilities(), ColumnType.LONG);
        this.assertNonStringColumnCapabilitiesWithNulls(MMAP_INDEX_WITH_NULLS.getColumnHolder("m1").getCapabilities(), ColumnType.DOUBLE);
        this.assertNonStringColumnCapabilitiesWithNulls(MMAP_INDEX_WITH_NULLS.getColumnHolder("m2").getCapabilities(), ColumnType.FLOAT);
        this.assertNonStringColumnCapabilitiesWithNulls(MMAP_INDEX_WITH_NULLS.getColumnHolder("m3").getCapabilities(), ColumnType.LONG);
    }

    @Test
    public void testStringColumn() {
        ColumnCapabilities caps = INC_INDEX.getColumnCapabilities("d1");
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isMaybeTrue());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)ColumnCapabilitiesImpl.snapshot((ColumnCapabilities)caps, (ColumnCapabilities.CoercionLogic)CapabilitiesBasedFormat.DIMENSION_CAPABILITY_MERGE_LOGIC).hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertTrue((boolean)caps.hasNulls().isUnknown());
        caps = MMAP_INDEX.getColumnHolder("d1").getCapabilities();
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertFalse((boolean)caps.hasNulls().isMaybeTrue());
    }

    @Test
    public void testStringColumnWithNulls() {
        ColumnCapabilities caps = INC_INDEX_WITH_NULLS.getColumnCapabilities("d1");
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)ColumnCapabilitiesImpl.snapshot((ColumnCapabilities)caps, (ColumnCapabilities.CoercionLogic)CapabilitiesBasedFormat.DIMENSION_CAPABILITY_MERGE_LOGIC).hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertTrue((boolean)caps.hasNulls().isTrue());
        caps = MMAP_INDEX_WITH_NULLS.getColumnHolder("d1").getCapabilities();
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertTrue((boolean)caps.hasNulls().isTrue());
    }

    @Test
    public void testMultiStringColumn() {
        ColumnCapabilities caps = INC_INDEX.getColumnCapabilities("d2");
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertTrue((boolean)caps.hasNulls().isUnknown());
        caps = MMAP_INDEX.getColumnHolder("d2").getCapabilities();
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertFalse((boolean)caps.hasNulls().isMaybeTrue());
    }

    @Test
    public void testMultiStringColumnWithNulls() {
        ColumnCapabilities caps = INC_INDEX_WITH_NULLS.getColumnCapabilities("d2");
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertTrue((boolean)caps.hasNulls().isTrue());
        caps = MMAP_INDEX_WITH_NULLS.getColumnHolder("d2").getCapabilities();
        Assert.assertEquals((Object)ValueType.STRING, (Object)caps.getType());
        Assert.assertTrue((boolean)caps.hasBitmapIndexes());
        Assert.assertTrue((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertTrue((boolean)caps.hasMultipleValues().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertTrue((boolean)caps.hasNulls().isTrue());
    }

    @Test
    public void testComplexColumn() {
        this.assertComplexColumnCapabilites(INC_INDEX.getColumnCapabilities("m4"));
        this.assertComplexColumnCapabilites(MMAP_INDEX.getColumnHolder("m4").getCapabilities());
        this.assertComplexColumnCapabilites(INC_INDEX_WITH_NULLS.getColumnCapabilities("m4"));
        this.assertComplexColumnCapabilites(MMAP_INDEX_WITH_NULLS.getColumnHolder("m4").getCapabilities());
    }

    private void assertComplexColumnCapabilites(ColumnCapabilities caps) {
        Assert.assertEquals((Object)HyperUniquesAggregatorFactory.TYPE, (Object)caps.toColumnType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isUnknown());
        Assert.assertTrue((boolean)caps.hasNulls().isTrue());
    }

    private void assertNonStringColumnCapabilities(ColumnCapabilities caps, ColumnType valueType) {
        Assert.assertEquals((Object)valueType, (Object)caps.toColumnType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertFalse((boolean)caps.hasNulls().isTrue());
    }

    private void assertNonStringColumnCapabilitiesWithNulls(ColumnCapabilities caps, ColumnType valueType) {
        Assert.assertEquals((Object)valueType, (Object)caps.toColumnType());
        Assert.assertFalse((boolean)caps.hasBitmapIndexes());
        Assert.assertFalse((boolean)caps.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesSorted().isTrue());
        Assert.assertFalse((boolean)caps.areDictionaryValuesUnique().isTrue());
        Assert.assertFalse((boolean)caps.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)caps.hasSpatialIndexes());
        Assert.assertEquals((Object)NullHandling.sqlCompatible(), (Object)caps.hasNulls().isMaybeTrue());
    }
}

