/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedStorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowBasedStorageAdapterTest {
    private static final String UNKNOWN_TYPE_NAME = "unknownType";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add(ValueType.FLOAT.name(), ColumnType.FLOAT).add(ValueType.DOUBLE.name(), ColumnType.DOUBLE).add(ValueType.LONG.name(), ColumnType.LONG).add(ValueType.STRING.name(), ColumnType.STRING).add(ValueType.COMPLEX.name(), ColumnType.UNKNOWN_COMPLEX).add("unknownType", null).build();
    private static final List<Function<Cursor, Supplier<Object>>> READ_STRING = ImmutableList.of(cursor -> {
        ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(ValueType.STRING.name());
        return () -> ((BaseObjectColumnValueSelector)selector).getObject();
    });
    private static final List<Function<Cursor, Supplier<Object>>> READ_TIME_AND_STRING = ImmutableList.of(cursor -> () -> ((Cursor)cursor).getTime(), cursor -> {
        ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(ValueType.STRING.name());
        return () -> ((BaseObjectColumnValueSelector)selector).getObject();
    });
    private static final LinkedHashMap<String, Function<Cursor, Supplier<Object>>> PROCESSORS = new LinkedHashMap();
    private static final RowAdapter<Integer> ROW_ADAPTER = new RowAdapter<Integer>(){

        public ToLongFunction<Integer> timestampFunction() {
            return i -> (long)i.intValue() * Duration.standardHours((long)1L).getMillis();
        }

        public Function<Integer, Object> columnFunction(String columnName) {
            if (RowBasedStorageAdapterTest.UNKNOWN_TYPE_NAME.equals(columnName)) {
                return i -> i;
            }
            ValueType valueType = (ValueType)GuavaUtils.getEnumIfPresent(ValueType.class, (String)columnName);
            if (valueType == null || valueType == ValueType.COMPLEX) {
                return i -> null;
            }
            return i -> DimensionHandlerUtils.convertObjectToType((Object)i, (TypeSignature)ROW_SIGNATURE.getColumnType(columnName).orElse(null));
        }
    };
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public final AtomicLong numCloses = new AtomicLong();

    @BeforeClass
    public static void setUpClass() {
        NullHandling.initializeForTests();
        PROCESSORS.clear();
        PROCESSORS.put("cursor-time", cursor -> () -> ((Cursor)cursor).getTime());
        for (String valueTypeName : ROW_SIGNATURE.getColumnNames()) {
            PROCESSORS.put(StringUtils.format((String)"%s-float", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> RowBasedStorageAdapterTest.lambda$null$4((BaseFloatColumnValueSelector)selector);
            });
            PROCESSORS.put(StringUtils.format((String)"%s-double", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> RowBasedStorageAdapterTest.lambda$null$6((BaseDoubleColumnValueSelector)selector);
            });
            PROCESSORS.put(StringUtils.format((String)"%s-long", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> RowBasedStorageAdapterTest.lambda$null$8((BaseLongColumnValueSelector)selector);
            });
            PROCESSORS.put(StringUtils.format((String)"%s-string", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)valueTypeName));
                return () -> ((DimensionSelector)selector).defaultGetObject();
            });
            PROCESSORS.put(StringUtils.format((String)"%s-object", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> ((BaseObjectColumnValueSelector)selector).getObject();
            });
        }
    }

    private RowBasedStorageAdapter<Integer> createIntAdapter(int ... ints) {
        return new RowBasedStorageAdapter(Sequences.simple((Iterable)Arrays.stream(ints).boxed().collect(Collectors.toList())).withBaggage(this.numCloses::incrementAndGet), ROW_ADAPTER, ROW_SIGNATURE);
    }

    @Test
    public void test_getInterval() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(new int[0]);
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)adapter.getInterval());
    }

    @Test
    public void test_getAvailableDimensions() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(new int[0]);
        Assert.assertEquals(ROW_SIGNATURE.getColumnNames().stream().sorted().collect(Collectors.toList()), Lists.newArrayList((Iterable)adapter.getAvailableDimensions()).stream().sorted().collect(Collectors.toList()));
    }

    @Test
    public void test_getAvailableMetrics() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(new int[0]);
        Assert.assertEquals(Collections.emptyList(), (Object)Lists.newArrayList((Iterable)adapter.getAvailableMetrics()));
    }

    @Test
    public void test_getRowSignature() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(new int[0]);
        Assert.assertEquals((Object)ROW_SIGNATURE, (Object)adapter.getRowSignature());
    }

    @Test
    public void test_getDimensionCardinality_knownColumns() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        for (String column : ROW_SIGNATURE.getColumnNames()) {
            Assert.assertEquals((long)-1L, (long)adapter.getDimensionCardinality(column));
        }
    }

    @Test
    public void test_getDimensionCardinality_unknownColumn() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertEquals((long)-1L, (long)adapter.getDimensionCardinality("unknown"));
    }

    @Test
    public void test_getDimensionCardinality_timeColumn() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertEquals((long)-1L, (long)adapter.getDimensionCardinality("__time"));
    }

    @Test
    public void test_getMinTime() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertEquals((Object)Intervals.ETERNITY.getStart(), (Object)adapter.getMinTime());
    }

    @Test
    public void test_getMaxTime() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertEquals((Object)Intervals.ETERNITY.getEnd().minus(1L), (Object)adapter.getMaxTime());
    }

    @Test
    public void test_getMinValue() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ImmutableList columns = ImmutableList.builder().addAll((Iterable)ROW_SIGNATURE.getColumnNames()).add((Object[])new String[]{"unknown", "__time"}).build();
        for (String column : columns) {
            Assert.assertNull((String)column, (Object)adapter.getMinValue(column));
        }
    }

    @Test
    public void test_getMaxValue() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ImmutableList columns = ImmutableList.builder().addAll((Iterable)ROW_SIGNATURE.getColumnNames()).add((Object[])new String[]{"unknown", "__time"}).build();
        for (String column : columns) {
            Assert.assertNull((String)column, (Object)adapter.getMaxValue(column));
        }
    }

    @Test
    public void test_getCapabilities() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        for (String column : ROW_SIGNATURE.getColumnNames()) {
            Assert.assertEquals((long)-1L, (long)adapter.getDimensionCardinality(column));
        }
    }

    @Test
    public void test_getColumnCapabilities_float() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.FLOAT.name());
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    @Test
    public void test_getColumnCapabilities_double() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.DOUBLE.name());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    @Test
    public void test_getColumnCapabilities_long() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.LONG.name());
        Assert.assertEquals((Object)ValueType.LONG, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    @Test
    public void test_getColumnCapabilities_string() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.STRING.name());
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isUnknown());
    }

    @Test
    public void test_getColumnCapabilities_complex() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.COMPLEX.name());
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)capabilities.toColumnType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isTrue());
        Assert.assertTrue((boolean)capabilities.isDictionaryEncoded().isUnknown());
    }

    @Test
    public void test_getColumnCapabilities_unknownType() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(UNKNOWN_TYPE_NAME);
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void test_getColumnCapabilities_nonexistent() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertNull((Object)adapter.getColumnCapabilities("nonexistent"));
    }

    @Test
    public void test_getColumnTypeString() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        for (String columnName : ROW_SIGNATURE.getColumnNames()) {
            if (UNKNOWN_TYPE_NAME.equals(columnName)) {
                Assert.assertNull((String)columnName, (Object)adapter.getColumnCapabilities(columnName));
                continue;
            }
            Assert.assertEquals((String)columnName, (Object)ValueType.valueOf((String)columnName).name(), (Object)adapter.getColumnCapabilities(columnName).asTypeString());
        }
    }

    @Test
    public void test_getNumRows() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        this.expectedException.expect(UnsupportedOperationException.class);
        adapter.getMetadata();
    }

    @Test
    public void test_getMaxIngestedEventTime() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertEquals((Object)Intervals.ETERNITY.getEnd().minus(1L), (Object)adapter.getMaxIngestedEventTime());
    }

    @Test
    public void test_getMetadata() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        this.expectedException.expect(UnsupportedOperationException.class);
        adapter.getMetadata();
    }

    @Test
    public void test_makeCursors_filterOnLong() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Sequence cursors = adapter.makeCursors(new SelectorDimFilter(ValueType.LONG.name(), "1.0", null).toFilter(), Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_filterOnNonexistentColumnEqualsNull() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1);
        Sequence cursors = adapter.makeCursors(new SelectorDimFilter("nonexistent", null, null).toFilter(), Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"0"), (Object)ImmutableList.of((Object)"1")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_filterOnVirtualColumn() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1);
        Sequence cursors = adapter.makeCursors(new SelectorDimFilter("vc", "2", null).toFilter(), Intervals.ETERNITY, VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("vc", "\"LONG\" + 1", ColumnType.LONG, ExprMacroTable.nil()))), Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_descending() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Sequence cursors = adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, true, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"2"), (Object)ImmutableList.of((Object)"1"), (Object)ImmutableList.of((Object)"0")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_intervalDoesNotMatch() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Sequence cursors = adapter.makeCursors(null, Intervals.of((String)"2000/P1D"), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of(), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_intervalPartiallyMatches() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Sequence cursors = adapter.makeCursors(null, Intervals.of((String)"1970-01-01T01/PT1H"), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_hourGranularity() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 1, 2, 3);
        Sequence cursors = adapter.makeCursors(null, Intervals.of((String)"1970/1971"), VirtualColumns.EMPTY, Granularities.HOUR, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T00"), (Object)"0"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T02"), (Object)"2"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T03"), (Object)"3")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_TIME_AND_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_hourGranularityWithInterval() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 1, 2, 3);
        Sequence cursors = adapter.makeCursors(null, Intervals.of((String)"1970-01-01T01/PT2H"), VirtualColumns.EMPTY, Granularities.HOUR, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T02"), (Object)"2")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_TIME_AND_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_hourGranularityWithIntervalDescending() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1, 1, 2, 3);
        Sequence cursors = adapter.makeCursors(null, Intervals.of((String)"1970-01-01T01/PT2H"), VirtualColumns.EMPTY, Granularities.HOUR, true, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T02"), (Object)"2"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1")), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, READ_TIME_AND_STRING));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_allProcessors() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1);
        Sequence cursors = adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of((Object)Lists.newArrayList((Object[])new Serializable[]{Intervals.ETERNITY.getStart(), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0.0", Float.valueOf(0.0f), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0.0", Double.valueOf(0.0), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0", Long.valueOf(0L), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0", "0", NullHandling.defaultFloatValue(), NullHandling.defaultDoubleValue(), NullHandling.defaultLongValue(), null, null, Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0", Integer.valueOf(0)}), (Object)Lists.newArrayList((Object[])new Serializable[]{Intervals.ETERNITY.getStart(), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1.0", Float.valueOf(1.0f), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1.0", Double.valueOf(1.0), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1", Long.valueOf(1L), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1", "1", NullHandling.defaultFloatValue(), NullHandling.defaultDoubleValue(), NullHandling.defaultLongValue(), null, null, Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1", Integer.valueOf(1)})), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, new ArrayList<Function<Cursor, Supplier<Object>>>(PROCESSORS.values())));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_filterOnNonexistentColumnEqualsNonnull() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1);
        Sequence cursors = adapter.makeCursors(new SelectorDimFilter("nonexistent", "abc", null).toFilter(), Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Assert.assertEquals((Object)ImmutableList.of(), RowBasedStorageAdapterTest.walkCursors((Sequence<Cursor>)cursors, new ArrayList<Function<Cursor, Supplier<Object>>>(PROCESSORS.values())));
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursors_eternityIntervalWithMonthGranularity() {
        RowBasedStorageAdapter<Integer> adapter = this.createIntAdapter(0, 1);
        Assert.assertThrows(IAE.class, () -> adapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.MONTH, false, null));
    }

    private static List<List<Object>> walkCursors(Sequence<Cursor> cursors, List<Function<Cursor, Supplier<Object>>> processors) {
        return cursors.flatMap(cursor -> {
            ArrayList suppliers = new ArrayList();
            for (Function processor : processors) {
                suppliers.add(processor.apply(cursor));
            }
            ArrayList retVal = new ArrayList();
            while (!cursor.isDone()) {
                ArrayList row = new ArrayList();
                for (Supplier supplier : suppliers) {
                    row.add(supplier.get());
                }
                retVal.add(row);
                cursor.advanceUninterruptibly();
            }
            return Sequences.simple(retVal);
        }).toList();
    }

    private static /* synthetic */ Object lambda$null$8(BaseLongColumnValueSelector selector) {
        if (selector.isNull()) {
            return null;
        }
        return selector.getLong();
    }

    private static /* synthetic */ Object lambda$null$6(BaseDoubleColumnValueSelector selector) {
        if (selector.isNull()) {
            return null;
        }
        return selector.getDouble();
    }

    private static /* synthetic */ Object lambda$null$4(BaseFloatColumnValueSelector selector) {
        if (selector.isNull()) {
            return null;
        }
        return Float.valueOf(selector.getFloat());
    }
}

