/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.Overshadowable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class SchemalessIndexTest {
    private static final Logger log = new Logger(SchemalessIndexTest.class);
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final String TEST_FILE = "druid.sample.json";
    private static final String TIMESTAMP = "timestamp";
    private static final List<String> METRICS = Collections.singletonList("index");
    private static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final AggregatorFactory[] METRIC_AGGS_NO_UNIQ = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count")};
    private static final IndexSpec INDEX_SPEC = IndexSpec.DEFAULT;
    private static final List<Map<String, Object>> EVENTS = new ArrayList<Map<String, Object>>();
    private static final Map<Integer, Map<Integer, QueryableIndex>> INCREMENTAL_INDEXES = new HashMap<Integer, Map<Integer, QueryableIndex>>();
    private static final Map<Integer, Map<Integer, QueryableIndex>> MERGED_INDEXES = new HashMap<Integer, Map<Integer, QueryableIndex>>();
    private static final List<QueryableIndex> ROW_PERSISTED_INDEXES = new ArrayList<QueryableIndex>();
    private static IncrementalIndex index = null;
    private static QueryableIndex mergedIndex = null;
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;

    public SchemalessIndexTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.indexMerger = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
        this.indexIO = TestHelper.getTestIndexIO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalIndex getIncrementalIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (index != null) {
                return index;
            }
            index = SchemalessIndexTest.makeIncrementalIndex(TEST_FILE, METRIC_AGGS);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryableIndex getIncrementalIndex(int index1, int index2) {
        Logger logger = log;
        synchronized (logger) {
            Map<Integer, QueryableIndex> entry;
            if (EVENTS.isEmpty()) {
                SchemalessIndexTest.makeEvents();
            }
            if ((entry = INCREMENTAL_INDEXES.get(index1)) != null) {
                QueryableIndex index = entry.get(index2);
                if (index != null) {
                    return index;
                }
            } else {
                entry = new HashMap<Integer, QueryableIndex>();
                INCREMENTAL_INDEXES.put(index1, entry);
            }
            IncrementalIndex theIndex = null;
            int count = 0;
            for (Map<String, Object> event : EVENTS) {
                if (count != index1 && count != index2) {
                    ++count;
                    continue;
                }
                long timestamp = new DateTime(event.get(TIMESTAMP), (Chronology)ISOChronology.getInstanceUTC()).getMillis();
                if (theIndex == null) {
                    theIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(timestamp).withQueryGranularity(Granularities.MINUTE).withMetrics(METRIC_AGGS).build()).setMaxRowCount(1000).build();
                }
                ArrayList<String> dims = new ArrayList<String>();
                for (Map.Entry<String, Object> val : event.entrySet()) {
                    if (val.getKey().equalsIgnoreCase(TIMESTAMP) || METRICS.contains(val.getKey())) continue;
                    dims.add(val.getKey());
                }
                try {
                    theIndex.add((InputRow)new MapBasedInputRow(timestamp, dims, event));
                }
                catch (IndexSizeExceededException e) {
                    throw new RuntimeException(e);
                }
                ++count;
            }
            QueryableIndex retVal = TestIndex.persistRealtimeAndLoadMMapped(theIndex);
            entry.put(index2, retVal);
            return retVal;
        }
    }

    public QueryableIndex getMergedIncrementalIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mergedIndex != null) {
                return mergedIndex;
            }
            try {
                IncrementalIndex top = SchemalessIndexTest.makeIncrementalIndex("druid.sample.json.top", METRIC_AGGS);
                IncrementalIndex bottom = SchemalessIndexTest.makeIncrementalIndex("druid.sample.json.bottom", METRIC_AGGS);
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File topFile = new File(tmpFile, "top");
                File bottomFile = new File(tmpFile, "bottom");
                File mergedFile = new File(tmpFile, "merged");
                FileUtils.mkdirp((File)topFile);
                FileUtils.mkdirp((File)bottomFile);
                FileUtils.mkdirp((File)mergedFile);
                topFile.deleteOnExit();
                bottomFile.deleteOnExit();
                mergedFile.deleteOnExit();
                this.indexMerger.persist(top, topFile, INDEX_SPEC, null);
                this.indexMerger.persist(bottom, bottomFile, INDEX_SPEC, null);
                mergedIndex = this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(this.indexIO.loadIndex(topFile), this.indexIO.loadIndex(bottomFile)), true, METRIC_AGGS, mergedFile, INDEX_SPEC, null, -1));
                return mergedIndex;
            }
            catch (IOException e) {
                mergedIndex = null;
                throw new RuntimeException(e);
            }
        }
    }

    public QueryableIndex getMergedIncrementalIndex(int index1, int index2) {
        Logger logger = log;
        synchronized (logger) {
            Map<Integer, QueryableIndex> entry;
            if (ROW_PERSISTED_INDEXES.isEmpty()) {
                this.makeRowPersistedIndexes();
            }
            if ((entry = MERGED_INDEXES.get(index1)) != null) {
                QueryableIndex index = entry.get(index2);
                if (index != null) {
                    return index;
                }
            } else {
                entry = new HashMap<Integer, QueryableIndex>();
                MERGED_INDEXES.put(index1, entry);
            }
            try {
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File mergedFile = new File(tmpFile, "merged");
                FileUtils.mkdirp((File)mergedFile);
                mergedFile.deleteOnExit();
                QueryableIndex index = this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(ROW_PERSISTED_INDEXES.get(index1), ROW_PERSISTED_INDEXES.get(index2)), true, METRIC_AGGS, mergedFile, INDEX_SPEC, null, -1));
                entry.put(index2, index);
                return index;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public QueryableIndex getMergedIncrementalIndex(int[] indexes) {
        Logger logger = log;
        synchronized (logger) {
            if (ROW_PERSISTED_INDEXES.isEmpty()) {
                this.makeRowPersistedIndexes();
            }
            try {
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File mergedFile = new File(tmpFile, "merged");
                FileUtils.mkdirp((File)mergedFile);
                mergedFile.deleteOnExit();
                ArrayList<QueryableIndex> indexesToMerge = new ArrayList<QueryableIndex>();
                for (int index : indexes) {
                    indexesToMerge.add(ROW_PERSISTED_INDEXES.get(index));
                }
                return this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(indexesToMerge, true, METRIC_AGGS, mergedFile, INDEX_SPEC, null, -1));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public QueryableIndex getMergedIncrementalIndexDiffMetrics() {
        return this.getMergedIncrementalIndex(Arrays.asList(new Pair((Object)"druid.sample.json.top", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"druid.sample.json.bottom", (Object)METRIC_AGGS)));
    }

    public QueryableIndex getMergedIncrementalIndex(Iterable<Pair<String, AggregatorFactory[]>> files) {
        return this.makeMergedMMappedIndex(files);
    }

    private static void makeEvents() {
        URL resource = TestIndex.class.getClassLoader().getResource(TEST_FILE);
        String filename = resource.getFile();
        log.info("Realtime loading index file[%s]", new Object[]{filename});
        try {
            for (Object obj : (List)JSON_MAPPER.readValue(new File(filename), List.class)) {
                Map event = (Map)JSON_MAPPER.convertValue(obj, Map.class);
                EVENTS.add(event);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRowPersistedIndexes() {
        Logger logger = log;
        synchronized (logger) {
            try {
                if (EVENTS.isEmpty()) {
                    SchemalessIndexTest.makeEvents();
                }
                for (Map<String, Object> event : EVENTS) {
                    long timestamp = new DateTime(event.get(TIMESTAMP), (Chronology)ISOChronology.getInstanceUTC()).getMillis();
                    ArrayList<String> dims = new ArrayList<String>();
                    for (Map.Entry<String, Object> entry : event.entrySet()) {
                        if (entry.getKey().equalsIgnoreCase(TIMESTAMP) || METRICS.contains(entry.getKey())) continue;
                        dims.add(entry.getKey());
                    }
                    IncrementalIndex rowIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(timestamp).withQueryGranularity(Granularities.MINUTE).withMetrics(METRIC_AGGS).build()).setMaxRowCount(1000).build();
                    rowIndex.add((InputRow)new MapBasedInputRow(timestamp, dims, event));
                    File tmpFile = File.createTempFile("billy", "yay");
                    tmpFile.delete();
                    FileUtils.mkdirp((File)tmpFile);
                    tmpFile.deleteOnExit();
                    this.indexMerger.persist(rowIndex, tmpFile, INDEX_SPEC, null);
                    ROW_PERSISTED_INDEXES.add(this.indexIO.loadIndex(tmpFile));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static IncrementalIndex makeIncrementalIndex(String resourceFilename, AggregatorFactory[] aggs) {
        URL resource = TestIndex.class.getClassLoader().getResource(resourceFilename);
        log.info("Realtime loading resource[%s]", new Object[]{resource});
        String filename = resource.getFile();
        log.info("Realtime loading index file[%s]", new Object[]{filename});
        IncrementalIndex retVal = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).withQueryGranularity(Granularities.MINUTE).withMetrics(aggs).build()).setMaxRowCount(1000).build();
        try {
            List events = (List)JSON_MAPPER.readValue(new File(filename), List.class);
            for (Object obj : events) {
                Map event = (Map)JSON_MAPPER.convertValue(obj, Map.class);
                ArrayList dims = new ArrayList();
                for (Map.Entry entry : event.entrySet()) {
                    if (((String)entry.getKey()).equalsIgnoreCase(TIMESTAMP) || METRICS.contains(entry.getKey())) continue;
                    dims.add(entry.getKey());
                }
                retVal.add((InputRow)new MapBasedInputRow(new DateTime(event.get(TIMESTAMP), (Chronology)ISOChronology.getInstanceUTC()).getMillis(), dims, event));
            }
        }
        catch (IOException e) {
            index = null;
            throw new RuntimeException(e);
        }
        return retVal;
    }

    private List<File> makeFilesToMap(File tmpFile, Iterable<Pair<String, AggregatorFactory[]>> files) throws IOException {
        ArrayList<File> filesToMap = new ArrayList<File>();
        for (Pair<String, AggregatorFactory[]> file : files) {
            IncrementalIndex index = SchemalessIndexTest.makeIncrementalIndex((String)file.lhs, (AggregatorFactory[])file.rhs);
            File theFile = new File(tmpFile, (String)file.lhs);
            FileUtils.mkdirp((File)theFile);
            theFile.deleteOnExit();
            filesToMap.add(theFile);
            this.indexMerger.persist(index, theFile, INDEX_SPEC, null);
        }
        return filesToMap;
    }

    private QueryableIndex makeMergedMMappedIndex(Iterable<Pair<String, AggregatorFactory[]>> files) {
        try {
            File tmpFile = File.createTempFile("yay", "who");
            tmpFile.delete();
            File mergedFile = new File(tmpFile, "merged");
            FileUtils.mkdirp((File)mergedFile);
            mergedFile.deleteOnExit();
            List<File> filesToMap = this.makeFilesToMap(tmpFile, files);
            return this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex((List)Lists.newArrayList((Iterable)Iterables.transform(filesToMap, (Function)new Function<File, QueryableIndex>(){

                public QueryableIndex apply(@Nullable File input) {
                    try {
                        return SchemalessIndexTest.this.indexIO.loadIndex(input);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            })), true, METRIC_AGGS, mergedFile, INDEX_SPEC, null, -1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
    }

    private static class OvershadowableFile
    implements Overshadowable<OvershadowableFile> {
        private final String majorVersion;
        private final File file;

        OvershadowableFile(int majorVersion, File file) {
            this.majorVersion = Integer.toString(majorVersion);
            this.file = file;
        }

        public boolean overshadows(OvershadowableFile other) {
            return false;
        }

        public int getStartRootPartitionId() {
            return 0;
        }

        public int getEndRootPartitionId() {
            return 0;
        }

        public String getVersion() {
            return this.majorVersion;
        }

        public short getMinorVersion() {
            return 0;
        }

        public short getAtomicUpdateGroupSize() {
            return 0;
        }
    }
}

