/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestStorageAdapter;
import org.apache.druid.segment.UnnestStorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UnnestStorageAdapterTest
extends InitializedNullHandlingTest {
    private static Closer CLOSER;
    private static IncrementalIndex INCREMENTAL_INDEX;
    private static IncrementalIndexStorageAdapter INCREMENTAL_INDEX_STORAGE_ADAPTER;
    private static UnnestStorageAdapter UNNEST_STORAGE_ADAPTER;
    private static UnnestStorageAdapter UNNEST_STORAGE_ADAPTER1;
    private static List<StorageAdapter> ADAPTERS;
    private static String COLUMNNAME;
    private static String OUTPUT_COLUMN_NAME;
    private static String OUTPUT_COLUMN_NAME1;

    @BeforeClass
    public static void setup() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        int numRows = 2;
        INCREMENTAL_INDEX = (IncrementalIndex)CLOSER.register((Closeable)segmentGenerator.generateIncrementalIndex(dataSegment, schemaInfo, Granularities.HOUR, 2));
        INCREMENTAL_INDEX_STORAGE_ADAPTER = new IncrementalIndexStorageAdapter(INCREMENTAL_INDEX);
        UNNEST_STORAGE_ADAPTER = new UnnestStorageAdapter((StorageAdapter)INCREMENTAL_INDEX_STORAGE_ADAPTER, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + COLUMNNAME + "\"", null, ExprMacroTable.nil()), null);
        UNNEST_STORAGE_ADAPTER1 = new UnnestStorageAdapter((StorageAdapter)UNNEST_STORAGE_ADAPTER, (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME1, "\"" + COLUMNNAME + "\"", null, ExprMacroTable.nil()), null);
        ADAPTERS = ImmutableList.of((Object)UNNEST_STORAGE_ADAPTER, (Object)UNNEST_STORAGE_ADAPTER1);
    }

    @AfterClass
    public static void teardown() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)CLOSER, throwable -> {});
    }

    @Test
    public void test_group_of_unnest_adapters_methods() {
        String colName = "multi-string1";
        for (StorageAdapter adapter : ADAPTERS) {
            Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01T23:00:00.000Z"), (Object)adapter.getMaxTime());
            Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01T12:00:00.000Z"), (Object)adapter.getMinTime());
            adapter.getColumnCapabilities(colName);
            Assert.assertEquals((long)adapter.getNumRows(), (long)0L);
            Assert.assertNotNull((Object)adapter.getMetadata());
            Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01T23:59:59.999Z"), (Object)adapter.getMaxIngestedEventTime());
            Assert.assertEquals((Object)adapter.getColumnCapabilities(colName).toColumnType(), (Object)INCREMENTAL_INDEX_STORAGE_ADAPTER.getColumnCapabilities(colName).toColumnType());
            UnnestStorageAdapterTest.assertColumnReadsIdentifier(((UnnestStorageAdapter)adapter).getUnnestColumn(), colName);
        }
    }

    @Test
    public void test_group_of_unnest_adapters_column_capabilities() {
        String colName = "multi-string1";
        List<String> columnsInTable = Arrays.asList("string1", "long1", "double1", "float1", "multi-string1", OUTPUT_COLUMN_NAME);
        List<ValueType> valueTypes = Arrays.asList(ValueType.STRING, ValueType.LONG, ValueType.DOUBLE, ValueType.FLOAT, ValueType.STRING, ValueType.STRING);
        UnnestStorageAdapter adapter = UNNEST_STORAGE_ADAPTER;
        for (int i = 0; i < columnsInTable.size(); ++i) {
            ColumnCapabilities capabilities = adapter.getColumnCapabilities(columnsInTable.get(i));
            Assert.assertEquals((Object)capabilities.getType(), (Object)valueTypes.get(i));
        }
        UnnestStorageAdapterTest.assertColumnReadsIdentifier(adapter.getUnnestColumn(), colName);
    }

    @Test
    public void test_unnest_adapters_basic() {
        Sequence cursorSequence = UNNEST_STORAGE_ADAPTER.makeCursors(null, UNNEST_STORAGE_ADAPTER.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        cursorSequence.accumulate(null, (accumulated, cursor) -> {
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)OUTPUT_COLUMN_NAME));
            int count = 0;
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                if (dimSelectorVal == null) {
                    Assert.assertNull((Object)dimSelectorVal);
                }
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)16L);
            return null;
        });
    }

    @Test
    public void test_two_levels_of_unnest_adapters() {
        Sequence cursorSequence = UNNEST_STORAGE_ADAPTER1.makeCursors(null, UNNEST_STORAGE_ADAPTER1.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        cursorSequence.accumulate(null, (accumulated, cursor) -> {
            ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
            DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)OUTPUT_COLUMN_NAME1));
            ColumnValueSelector valueSelector = factory.makeColumnValueSelector(OUTPUT_COLUMN_NAME1);
            int count = 0;
            while (!cursor.isDone()) {
                Object dimSelectorVal = dimSelector.getObject();
                Object valueSelectorVal = valueSelector.getObject();
                if (dimSelectorVal == null) {
                    Assert.assertNull((Object)dimSelectorVal);
                } else if (valueSelectorVal == null) {
                    Assert.assertNull((Object)valueSelectorVal);
                }
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)count, (long)128L);
            Assert.assertEquals((long)dimSelector.getValueCardinality(), (long)16L);
            return null;
        });
    }

    private static void assertColumnReadsIdentifier(VirtualColumn column, String identifier) {
        MatcherAssert.assertThat((Object)column, (Matcher)CoreMatchers.instanceOf(ExpressionVirtualColumn.class));
        Assert.assertEquals((Object)("\"" + identifier + "\""), (Object)((ExpressionVirtualColumn)column).getExpression());
    }

    @Test
    public void test_pushdown_or_filters_unnested_and_original_dimension_with_unnest_adapters() {
        UnnestStorageAdapter unnestStorageAdapter = new UnnestStorageAdapter((StorageAdapter)new TestStorageAdapter(INCREMENTAL_INDEX), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + COLUMNNAME + "\"", null, ExprMacroTable.nil()), null);
        VirtualColumn vc = unnestStorageAdapter.getUnnestColumn();
        String inputColumn = unnestStorageAdapter.getUnnestInputIfDirectAccess(vc);
        OrFilter baseFilter = new OrFilter((List)ImmutableList.of((Object)new SelectorDimFilter(OUTPUT_COLUMN_NAME, "1", null).toFilter(), (Object)new SelectorDimFilter(inputColumn, "2", null).toFilter()));
        OrFilter expectedPushDownFilter = new OrFilter((List)ImmutableList.of((Object)new SelectorDimFilter(inputColumn, "1", null).toFilter(), (Object)new SelectorDimFilter(inputColumn, "2", null).toFilter()));
        Sequence cursorSequence = unnestStorageAdapter.makeCursors((Filter)baseFilter, unnestStorageAdapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        TestStorageAdapter base = (TestStorageAdapter)unnestStorageAdapter.getBaseAdapter();
        Filter pushDownFilter = base.getPushDownFilter();
        Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
        cursorSequence.accumulate(null, (accumulated, cursor) -> {
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)baseFilter, (Object)postFilter);
            return null;
        });
    }

    @Test
    public void test_pushdown_filters_unnested_dimension_with_unnest_adapters() {
        UnnestStorageAdapter unnestStorageAdapter = new UnnestStorageAdapter((StorageAdapter)new TestStorageAdapter(INCREMENTAL_INDEX), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + COLUMNNAME + "\"", null, ExprMacroTable.nil()), (DimFilter)new SelectorDimFilter(OUTPUT_COLUMN_NAME, "1", null));
        VirtualColumn vc = unnestStorageAdapter.getUnnestColumn();
        String inputColumn = unnestStorageAdapter.getUnnestInputIfDirectAccess(vc);
        Filter expectedPushDownFilter = new SelectorDimFilter(inputColumn, "1", null).toFilter();
        Sequence cursorSequence = unnestStorageAdapter.makeCursors(null, unnestStorageAdapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        TestStorageAdapter base = (TestStorageAdapter)unnestStorageAdapter.getBaseAdapter();
        Filter pushDownFilter = base.getPushDownFilter();
        Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
        cursorSequence.accumulate(null, (accumulated, cursor) -> {
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)unnestStorageAdapter.getUnnestFilter(), (Object)postFilter);
            int count = 0;
            while (!cursor.isDone()) {
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
            return null;
        });
    }

    @Test
    public void test_pushdown_filters_unnested_dimension_outside() {
        UnnestStorageAdapter unnestStorageAdapter = new UnnestStorageAdapter((StorageAdapter)new TestStorageAdapter(INCREMENTAL_INDEX), (VirtualColumn)new ExpressionVirtualColumn(OUTPUT_COLUMN_NAME, "\"" + COLUMNNAME + "\"", null, ExprMacroTable.nil()), null);
        VirtualColumn vc = unnestStorageAdapter.getUnnestColumn();
        String inputColumn = unnestStorageAdapter.getUnnestInputIfDirectAccess(vc);
        Filter expectedPushDownFilter = new SelectorDimFilter(inputColumn, "1", null).toFilter();
        Filter queryFilter = new SelectorDimFilter(OUTPUT_COLUMN_NAME, "1", null).toFilter();
        Sequence cursorSequence = unnestStorageAdapter.makeCursors(queryFilter, unnestStorageAdapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        TestStorageAdapter base = (TestStorageAdapter)unnestStorageAdapter.getBaseAdapter();
        Filter pushDownFilter = base.getPushDownFilter();
        Assert.assertEquals((Object)expectedPushDownFilter, (Object)pushDownFilter);
        cursorSequence.accumulate(null, (accumulated, cursor) -> {
            Assert.assertEquals(cursor.getClass(), PostJoinCursor.class);
            Filter postFilter = ((PostJoinCursor)cursor).getPostJoinFilter();
            Assert.assertEquals((Object)queryFilter, (Object)postFilter);
            int count = 0;
            while (!cursor.isDone()) {
                cursor.advance();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
            return null;
        });
    }

    static {
        COLUMNNAME = "multi-string1";
        OUTPUT_COLUMN_NAME = "unnested-multi-string1";
        OUTPUT_COLUMN_NAME1 = "unnested-multi-string1-again";
    }
}

