/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.ColumnComparisonFilterTest;
import org.apache.druid.segment.filter.ExpressionFilter;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dim0"), (Object)new LongDimensionSchema("dim1"), (Object)new FloatDimensionSchema("dim2"), (Object)new StringDimensionSchema("dim3"), (Object)new StringDimensionSchema("dim4")))));
    private static final List<InputRow> ROWS = ImmutableList.of((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)0L, (Object)"dim2", (Object)Float.valueOf(0.0f), (Object)"dim3", (Object)"", (Object)"dim4", (Object)ImmutableList.of((Object)"1", (Object)"2")), (Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)1L, (Object)"dim2", (Object)Float.valueOf(1.0f), (Object)"dim3", (Object)"10", (Object)"dim4", (Object)ImmutableList.of()), (Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)2L, (Object)"dim2", (Object)Float.valueOf(2.0f), (Object)"dim3", (Object)"2", (Object)"dim4", (Object)ImmutableList.of((Object)"")), (Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)3L, (Object)"dim2", (Object)Float.valueOf(3.0f), (Object)"dim3", (Object)"1", (Object)"dim4", (Object)ImmutableList.of((Object)"3")), (Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)4L, (Object)"dim2", (Object)Float.valueOf(4.0f), (Object)"dim3", (Object)"1", (Object)"dim4", (Object)ImmutableList.of((Object)"4", (Object)"5")), (Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)5L, (Object)"dim2", (Object)Float.valueOf(5.0f), (Object)"dim3", (Object)"5", (Object)"dim4", (Object)ImmutableList.of((Object)"4", (Object)"5")), (Object)ImmutableMap.of((Object)"dim0", (Object)"6", (Object)"dim1", (Object)6L, (Object)"dim2", (Object)Float.valueOf(6.0f), (Object)"dim3", (Object)"1"), (Object)ImmutableMap.of((Object)"dim0", (Object)"7", (Object)"dim1", (Object)7L, (Object)"dim2", (Object)Float.valueOf(7.0f), (Object)"dim3", (Object)"a"), (Object)ImmutableMap.of((Object)"dim0", (Object)"8", (Object)"dim1", (Object)8L, (Object)"dim2", (Object)Float.valueOf(8.0f), (Object)"dim3", (Object)8L), (Object)ImmutableMap.of((Object)"dim0", (Object)"9", (Object)"dim1", (Object)9L, (Object)"dim2", (Object)Float.valueOf(9.0f), (Object)"dim3", (Object)1.234, (Object)"dim4", (Object)1.234)).stream().map(e -> (InputRow)PARSER.parseBatch(e).get(0)).collect(Collectors.toList());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public ExpressionFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder.schema(new IncrementalIndexSchema.Builder().withDimensionsSpec(PARSER.getParseSpec().getDimensionsSpec()).build()), finisher, cnf, optimize);
    }

    @Before
    public void setup() {
        ExpressionProcessing.initializeForStrictBooleansTests((boolean)false);
    }

    @After
    public void teardown() {
        ExpressionProcessing.initializeForTests();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(ColumnComparisonFilterTest.class.getName());
    }

    @Test
    public void testOneSingleValuedStringColumn() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == '1'"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 'a'"), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 1"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 1.0"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 == 1.234"), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < 2"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim3 < 2.0"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim3, '1%')"), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"6", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_contains(dim3, '1')"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"6"));
    }

    @Test
    public void testOneMultiValuedStringColumn() {
        if (this.testName.contains("AutoTypes")) {
            return;
        }
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == ''"), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"6", (Object)"7", (Object)"8"));
        } else {
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == ''"), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == null"), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == '1'"), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == '3'"), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim4 == '4'"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("concat(dim4, dim4) == '33'"), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim4, '4%')"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_contains(dim4, '5')"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_to_string(dim4, ':') == '4:5'"), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testSingleAndMultiValuedStringColumn() {
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("array_contains(dim4, dim3)"), (List<String>)ImmutableList.of((Object)"5", (Object)"9"));
    }

    @Test
    public void testOneLongColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == ''"), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == '1'"), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == 2"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim1, '1%')"), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testOneFloatColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == ''"), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == ''"), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == '1'"), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == 2"), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(dim2, '1%')"), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testConstantExpression() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("1 + 1"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("'true'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("0 + 0"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("'false'"), (List<String>)ImmutableList.of());
    }

    @Test
    public void testCompareColumns() {
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim0 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == dim3"), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"8"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == dim3"), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"8"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim1 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("dim2 == dim3"), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        }
        if (this.testName.contains("AutoTypes")) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("dim0 == dim4"), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testMissingColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == ''"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == otherMissing"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == null"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == otherMissing"), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == '1'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing == 2"), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < '2'"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < 2"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing < 2.0"), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing > '2'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing > 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterTest.edf("missing > 2.0"), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterTest.edf("like(missing, '1%')"), (List<String>)ImmutableList.of());
    }

    @Test
    public void testGetRequiredColumn() {
        Assert.assertEquals((Object)ExpressionFilterTest.edf("like(dim1, '1%')").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim1"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim2 == '1'").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim2"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim3 < '2'").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim3"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim4 == ''").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim4"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("1 + 1").getRequiredColumns(), new HashSet());
        Assert.assertEquals((Object)ExpressionFilterTest.edf("dim0 == dim3").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"dim0", "dim3"}));
        Assert.assertEquals((Object)ExpressionFilterTest.edf("missing == ''").getRequiredColumns(), (Object)Sets.newHashSet((Object[])new String[]{"missing"}));
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(ExpressionFilter.class).withIgnoredFields(new String[]{"bindingDetails"}).usingGetClass().verify();
    }

    @Test
    public void testRequiredColumnRewrite() {
        Filter filter = ExpressionFilterTest.edf("dim1 == '1'").toFilter();
        Assert.assertFalse((boolean)filter.supportsRequiredColumnRewrite());
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Required column rewrite is not supported by this filter.");
        filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1"));
    }

    private static ExpressionDimFilter edf(String expression) {
        return new ExpressionDimFilter(expression, null, TestExprMacroTable.INSTANCE);
    }
}

