/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LongFilteringTest
extends BaseFilterTest {
    private static final String LONG_COLUMN = "lng";
    private static final String TIMESTAMP_COLUMN = "ts";
    private static int EXECUTOR_NUM_THREADS = 16;
    private static int EXECUTOR_NUM_TASKS = 2000;
    private static final int NUM_FILTER_VALUES = 32;
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("ts", "millis", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2", (Object)"dim3")))));
    private static final List<InputRow> ROWS = ImmutableList.of(PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)1L, (Object)"dim0", (Object)"1", (Object)"lng", (Object)1L, (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"a", (Object)"b"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)2L, (Object)"dim0", (Object)"2", (Object)"lng", (Object)2L, (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)3L, (Object)"dim0", (Object)"3", (Object)"lng", (Object)3L, (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)4L, (Object)"dim0", (Object)"4", (Object)"lng", (Object)4L, (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)5L, (Object)"dim0", (Object)"5", (Object)"lng", (Object)5L, (Object)"dim1", (Object)"def", (Object)"dim2", (Object)ImmutableList.of((Object)"c"))).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)6L, (Object)"dim0", (Object)"6", (Object)"lng", (Object)6L, (Object)"dim1", (Object)"abc")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)7L, (Object)"dim0", (Object)"7", (Object)"lng", (Object)100000000L, (Object)"dim1", (Object)"xyz")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)8L, (Object)"dim0", (Object)"8", (Object)"lng", (Object)100000001L, (Object)"dim1", (Object)"xyz")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)9L, (Object)"dim0", (Object)"9", (Object)"lng", (Object)-25L, (Object)"dim1", (Object)"ghi")).get(0), PARSER.parseBatch((Object)ImmutableMap.of((Object)"ts", (Object)10L, (Object)"dim0", (Object)"10", (Object)"lng", (Object)-100000001L, (Object)"dim1", (Object)"qqq")).get(0));

    public LongFilteringTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder.schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory(LONG_COLUMN, LONG_COLUMN)}).build()), finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(LongFilteringTest.class.getName());
    }

    @Test
    public void testLongColumnFiltering() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "0", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "3", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "3.0", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "3.00000000000000000000001", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "100000001.0", null), (List<String>)ImmutableList.of((Object)"8"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "-100000001.0", null), (List<String>)ImmutableList.of((Object)"10"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "111119223372036854775807.674398674398", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2", "5", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "1", "4", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2.0", "5.0", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2.0", "5.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "1.9", "5.9", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2.1", "5.9", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "111119223372036854775807.67", "5.9", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "-111119223372036854775807.67", "5.9", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"9", (Object)"10"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2.1", "111119223372036854775807.67", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2.1", "-111119223372036854775807.67", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "100000000.0", "100000001.0", Boolean.valueOf(true), Boolean.valueOf(true), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "100000000.0", "100000001.0", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"7", (Object)"8"));
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, Arrays.asList("2", "4", "8"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, Arrays.asList("1.999999999999999999", "4.00000000000000000000001"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, Arrays.asList("100000001.0", "99999999.999999999"), null), (List<String>)ImmutableList.of((Object)"8"));
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, Arrays.asList("-25.0", "-99999999.999999999"), null), (List<String>)ImmutableList.of((Object)"9"));
        ArrayList<String> infilterValues = new ArrayList<String>(32);
        for (int i = 0; i < 32; ++i) {
            infilterValues.add(String.valueOf(i * 2));
        }
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, infilterValues, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4", (Object)"6"));
        String jsFn = "function(x) { return(x === 3 || x === 5) }";
        this.assertFilterMatchesSkipVectorize((DimFilter)new JavaScriptDimFilter(LONG_COLUMN, jsFn, null, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"3", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter(LONG_COLUMN, "4", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter(LONG_COLUMN, (SearchQuerySpec)new ContainsSearchQuerySpec("2", true), null), (List<String>)ImmutableList.of((Object)"2", (Object)"9"));
    }

    @Test
    public void testLongColumnFilteringWithNonNumbers() {
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, null, null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "abc", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "a", "b", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, " ", "4", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"9", (Object)"10"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, " ", "4", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"7", (Object)"8", (Object)"9", (Object)"10"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, " ", "A", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, " ", "A", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.LEXICOGRAPHIC), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9", (Object)"10"));
    }

    @Test
    public void testLongFilterWithExtractionFn() {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("1", "Monday");
        stringMap.put("2", "Tuesday");
        stringMap.put("3", "Wednesday");
        stringMap.put("4", "Thursday");
        stringMap.put("5", "Friday");
        stringMap.put("6", "Saturday");
        MapLookupExtractor mapExtractor = new MapLookupExtractor(stringMap, false);
        LookupExtractionFn exfn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "Monday", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter(LONG_COLUMN, "Notaday", (ExtractionFn)exfn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "Fridax", "Fridaz", Boolean.valueOf(false), Boolean.valueOf(false), null, (ExtractionFn)exfn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "Friday", "Friday", Boolean.valueOf(true), Boolean.valueOf(true), null, (ExtractionFn)exfn, StringComparators.ALPHANUMERIC), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, Arrays.asList("Caturday", "Saturday", "Tuesday"), (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"2", (Object)"6"));
        List<String> bigList = Arrays.asList("Saturday", "Tuesday", "Caturday", "Xanaday", "Vojuday", "Gribaday", "Kipoday", "Dheferday", "Fakeday", "Qeearaday", "Hello", "World", "1", "2", "3", "4", "5", "6", "7");
        this.assertFilterMatches((DimFilter)new InDimFilter(LONG_COLUMN, bigList, (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"2", (Object)"6"));
        String jsFn = "function(x) { return(x === 'Wednesday' || x === 'Thursday') }";
        this.assertFilterMatchesSkipVectorize((DimFilter)new JavaScriptDimFilter(LONG_COLUMN, jsFn, (ExtractionFn)exfn, JavaScriptConfig.getEnabledInstance()), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter(LONG_COLUMN, ".*day", (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
        this.assertFilterMatches((DimFilter)new SearchQueryDimFilter(LONG_COLUMN, (SearchQuerySpec)new ContainsSearchQuerySpec("s", true), (ExtractionFn)exfn), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
    }

    @Test
    public void testMultithreaded() {
        this.assertFilterMatchesMultithreaded((DimFilter)new SelectorDimFilter(LONG_COLUMN, "3", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesMultithreaded((DimFilter)new InDimFilter(LONG_COLUMN, Arrays.asList("2", "4", "8"), null), (List<String>)ImmutableList.of((Object)"2", (Object)"4"));
        ArrayList<String> infilterValues = new ArrayList<String>(32);
        for (int i = 0; i < 32; ++i) {
            infilterValues.add(String.valueOf(i * 2));
        }
        this.assertFilterMatchesMultithreaded((DimFilter)new InDimFilter(LONG_COLUMN, infilterValues, null), (List<String>)ImmutableList.of((Object)"2", (Object)"4", (Object)"6"));
        this.assertFilterMatches((DimFilter)new BoundDimFilter(LONG_COLUMN, "2", "5", Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    private void assertFilterMatchesMultithreaded(DimFilter filter, List<String> expectedRows) {
        this.testWithExecutor(filter, expectedRows);
    }

    private Runnable makeFilterRunner(final DimFilter filter, final List<String> expectedRows) {
        return new Runnable(){

            @Override
            public void run() {
                LongFilteringTest.this.assertFilterMatches(filter, expectedRows);
            }
        };
    }

    private void testWithExecutor(DimFilter filter, List<String> expectedRows) {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)EXECUTOR_NUM_THREADS, (String)"LongFilteringTest-%d"));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (int i = 0; i < EXECUTOR_NUM_TASKS; ++i) {
            Runnable runnable = this.makeFilterRunner(filter, expectedRows);
            ListenableFuture fut = executor.submit(runnable);
            futures.add(fut);
        }
        try {
            Futures.allAsList(futures).get(60L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        executor.shutdown();
    }
}

