/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.lookup.LookupJoinMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LookupJoinMatcherTest {
    private final Map<String, String> lookupMap = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"null", (Object)"", (Object)"empty String", (Object)"", (Object)"", (Object)"empty_string");
    private static final String PREFIX = "j.";
    @Mock
    private LookupExtractor extractor;
    @Mock
    private ColumnSelectorFactory leftSelectorFactory;
    @Mock
    private DimensionSelector dimensionSelector;
    private LookupJoinMatcher target;

    @Before
    public void setUp() {
        ((LookupExtractor)Mockito.doReturn((Object)true).when((Object)this.extractor)).canIterate();
        ((LookupExtractor)Mockito.doReturn(this.lookupMap.entrySet()).when((Object)this.extractor)).iterable();
    }

    @Test
    public void testCreateConditionAlwaysFalseShouldReturnSuccessfullyAndNotThrowException() {
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)"0", (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)false);
        Assert.assertNotNull((Object)this.target);
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        Assert.assertNotNull((Object)this.target);
    }

    @Test
    public void testCreateConditionAlwaysTrueShouldReturnSuccessfullyAndNotThrowException() {
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)"1", (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        ((LookupExtractor)Mockito.doReturn((Object)true).when((Object)this.extractor)).canIterate();
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)false);
        Assert.assertNotNull((Object)this.target);
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        Assert.assertNotNull((Object)this.target);
    }

    @Test
    public void testMatchConditionAlwaysTrue() {
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)"1", (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        this.target.matchCondition();
        Assert.assertTrue((boolean)this.target.hasMatch());
        this.verifyMatch("foo", "bar");
        this.target.nextMatch();
        Assert.assertTrue((boolean)this.target.hasMatch());
        this.verifyMatch("null", "");
        this.target.nextMatch();
        Assert.assertTrue((boolean)this.target.hasMatch());
        this.verifyMatch("empty String", "");
        this.target.nextMatch();
        Assert.assertTrue((boolean)this.target.hasMatch());
        this.verifyMatch("", "empty_string");
        this.target.nextMatch();
        Assert.assertFalse((boolean)this.target.hasMatch());
    }

    @Test
    public void testMatchConditionAlwaysFalse() {
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)"0", (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        this.target.matchCondition();
        Assert.assertFalse((boolean)this.target.hasMatch());
        this.verifyMatch(null, null);
    }

    @Test
    public void testMatchConditionSometimesTrueSometimesFalse() {
        boolean index = true;
        SingleIndexedInt row = new SingleIndexedInt();
        row.setValue(1);
        ((ColumnSelectorFactory)Mockito.doReturn((Object)this.dimensionSelector).when((Object)this.leftSelectorFactory)).makeDimensionSelector((DimensionSpec)ArgumentMatchers.any(DimensionSpec.class));
        ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
        ((DimensionSelector)Mockito.doReturn((Object)"foo").when((Object)this.dimensionSelector)).lookupName(1);
        ((LookupExtractor)Mockito.doReturn((Object)"bar").when((Object)this.extractor)).apply("foo");
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == foo", (Object[])new Object[]{PREFIX}), (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        this.target.matchCondition();
        Assert.assertTrue((boolean)this.target.hasMatch());
        this.verifyMatch("foo", "bar");
        this.target.nextMatch();
        Assert.assertFalse((boolean)this.target.hasMatch());
    }

    @Test(expected=QueryUnsupportedException.class)
    public void testMatchMultiValuedRowShouldThrowException() {
        ArrayBasedIndexedInts row = new ArrayBasedIndexedInts(new int[]{2, 4, 6});
        ((ColumnSelectorFactory)Mockito.doReturn((Object)this.dimensionSelector).when((Object)this.leftSelectorFactory)).makeDimensionSelector((DimensionSpec)ArgumentMatchers.any(DimensionSpec.class));
        ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == foo", (Object[])new Object[]{PREFIX}), (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        this.target.matchCondition();
    }

    @Test
    public void testMatchEmptyRow() {
        ArrayBasedIndexedInts row = new ArrayBasedIndexedInts(new int[0]);
        ((ColumnSelectorFactory)Mockito.doReturn((Object)this.dimensionSelector).when((Object)this.leftSelectorFactory)).makeDimensionSelector((DimensionSpec)ArgumentMatchers.any(DimensionSpec.class));
        ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"\"%sk\" == foo", (Object[])new Object[]{PREFIX}), (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        this.target = LookupJoinMatcher.create((LookupExtractor)this.extractor, (ColumnSelectorFactory)this.leftSelectorFactory, (JoinConditionAnalysis)condition, (boolean)true);
        this.target.matchCondition();
        Assert.assertFalse((boolean)this.target.hasMatch());
    }

    private void verifyMatch(String expectedKey, String expectedValue) {
        DimensionSelector selector = this.target.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"k"));
        Assert.assertEquals((long)-1L, (long)selector.getValueCardinality());
        Assert.assertEquals((Object)expectedKey, (Object)selector.lookupName(0));
        Assert.assertEquals((Object)expectedKey, (Object)selector.lookupName(0));
        Assert.assertNull((Object)selector.idLookup());
        selector = this.target.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"v"));
        Assert.assertEquals((long)-1L, (long)selector.getValueCardinality());
        Assert.assertEquals((Object)expectedValue, (Object)selector.lookupName(0));
        Assert.assertEquals((Object)expectedValue, (Object)selector.lookupName(0));
        Assert.assertNull((Object)selector.idLookup());
    }
}

