/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.MapIndex;
import org.apache.druid.segment.join.table.RowBasedIndexBuilder;
import org.apache.druid.segment.join.table.UniqueLongArrayIndex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowBasedIndexBuilderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_stringKey_uniqueKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ColumnType.STRING).add((Object)"abc").add((Object)"").add(null).add((Object)"1").add((Object)"def");
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)index.keyType());
        Assert.assertTrue((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intSet(0), (Object)index.find((Object)"abc"));
        Assert.assertEquals((Object)this.intSet(1), (Object)index.find((Object)""));
        Assert.assertEquals((Object)this.intSet(3), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intSet(3), (Object)index.find((Object)"1"));
        Assert.assertEquals((Object)this.intSet(4), (Object)index.find((Object)"def"));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find(null));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find((Object)"nonexistent"));
        this.expectedException.expect(UnsupportedOperationException.class);
        index.findUniqueLong(0L);
    }

    @Test
    public void test_stringKey_duplicateKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ColumnType.STRING).add((Object)"abc").add((Object)"").add(null).add((Object)"abc").add((Object)"1").add((Object)"def");
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)index.keyType());
        Assert.assertFalse((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intSet(0, 3), (Object)index.find((Object)"abc"));
        Assert.assertEquals((Object)this.intSet(1), (Object)index.find((Object)""));
        Assert.assertEquals((Object)this.intSet(4), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intSet(4), (Object)index.find((Object)"1"));
        Assert.assertEquals((Object)this.intSet(5), (Object)index.find((Object)"def"));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find(null));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find((Object)"nonexistent"));
        this.expectedException.expect(UnsupportedOperationException.class);
        index.findUniqueLong(0L);
    }

    @Test
    public void test_longKey_uniqueKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ColumnType.LONG).add((Object)1).add((Object)5).add((Object)2);
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(UniqueLongArrayIndex.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)index.keyType());
        Assert.assertTrue((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intSet(0), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intSet(1), (Object)index.find((Object)5L));
        Assert.assertEquals((Object)this.intSet(2), (Object)index.find((Object)2L));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find((Object)3L));
        Assert.assertEquals((long)0L, (long)index.findUniqueLong(1L));
        Assert.assertEquals((long)1L, (long)index.findUniqueLong(5L));
        Assert.assertEquals((long)2L, (long)index.findUniqueLong(2L));
        Assert.assertEquals((long)-1L, (long)index.findUniqueLong(3L));
    }

    @Test
    public void test_longKey_uniqueKeys_farApart() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ColumnType.LONG).add((Object)1).add((Object)10000000).add((Object)2);
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)index.keyType());
        Assert.assertTrue((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intSet(0), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intSet(1), (Object)index.find((Object)10000000L));
        Assert.assertEquals((Object)this.intSet(2), (Object)index.find((Object)2L));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find((Object)3L));
        Assert.assertEquals((long)0L, (long)index.findUniqueLong(1L));
        Assert.assertEquals((long)1L, (long)index.findUniqueLong(10000000L));
        Assert.assertEquals((long)2L, (long)index.findUniqueLong(2L));
        Assert.assertEquals((long)-1L, (long)index.findUniqueLong(3L));
    }

    @Test
    public void test_longKey_duplicateKeys() {
        RowBasedIndexBuilder builder = new RowBasedIndexBuilder(ColumnType.LONG).add((Object)1).add((Object)5).add((Object)1).add((Object)2);
        IndexedTable.Index index = builder.build();
        Assert.assertThat((Object)index, (Matcher)CoreMatchers.instanceOf(MapIndex.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)index.keyType());
        Assert.assertFalse((boolean)index.areKeysUnique());
        Assert.assertEquals((Object)this.intSet(0, 2), (Object)index.find((Object)"1"));
        Assert.assertEquals((Object)this.intSet(0, 2), (Object)index.find((Object)1));
        Assert.assertEquals((Object)this.intSet(0, 2), (Object)index.find((Object)1L));
        Assert.assertEquals((Object)this.intSet(1), (Object)index.find((Object)5L));
        Assert.assertEquals((Object)this.intSet(3), (Object)index.find((Object)2L));
        Assert.assertEquals((Object)this.intSet(new int[0]), (Object)index.find((Object)3L));
        this.expectedException.expect(UnsupportedOperationException.class);
        index.findUniqueLong(5L);
    }

    public IntSortedSet intSet(int ... ints) {
        IntAVLTreeSet retVal = new IntAVLTreeSet();
        for (int i : ints) {
            retVal.add(i);
        }
        return retVal;
    }
}

