/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowBasedIndexedTableTest {
    private static final int INDEX_COUNTRIES_COUNTRY_NUMBER = 0;
    private static final int INDEX_COUNTRIES_COUNTRY_ISO_CODE = 1;
    private static final int INDEX_COUNTRIES_COUNTRY_NAME = 2;
    private static final int INDEX_REGIONS_REGION_ISO_CODE = 0;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public RowBasedIndexedTable<Map<String, Object>> countriesTable;
    public RowBasedIndexedTable<Map<String, Object>> regionsTable;

    @BeforeClass
    public static void setUpStatic() {
        NullHandling.initializeForTests();
    }

    @Before
    public void setUp() throws IOException {
        this.countriesTable = JoinTestHelper.createCountriesIndexedTable();
        this.regionsTable = JoinTestHelper.createRegionsIndexedTable();
    }

    @Test
    public void test_keyColumns_countries() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"countryNumber", (Object)"countryIsoCode"), (Object)this.countriesTable.keyColumns());
    }

    @Test
    public void test_rowSignature_countries() {
        Assert.assertEquals((Object)RowSignature.builder().add("countryNumber", ColumnType.LONG).add("countryIsoCode", ColumnType.STRING).add("countryName", ColumnType.STRING).build(), (Object)this.countriesTable.rowSignature());
    }

    @Test
    public void test_numRows_countries() {
        Assert.assertEquals((long)18L, (long)this.countriesTable.numRows());
    }

    @Test
    public void test_columnIndex_countriesCountryIsoCode() {
        IndexedTable.Index index = this.countriesTable.columnIndex(1);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)index.find(null));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)index.find((Object)2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)13), (Object)index.find((Object)"US"));
    }

    @Test
    public void test_columnIndex_countriesCountryNumber() {
        IndexedTable.Index index = this.countriesTable.columnIndex(0);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)index.find(null));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)index.find((Object)0));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)index.find((Object)0.0));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)index.find((Object)"0"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)2), (Object)index.find((Object)2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)2), (Object)index.find((Object)2.0));
        Assert.assertEquals((Object)ImmutableSet.of((Object)2), (Object)index.find((Object)"2"));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)index.find((Object)20));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)index.find((Object)"US"));
    }

    @Test
    public void test_columnIndex_countriesCountryName() {
        this.expectedException.expectMessage("Column[2] is not a key column");
        this.countriesTable.columnIndex(2);
    }

    @Test
    public void test_columnIndex_countriesOutOfBounds() {
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.countriesTable.columnIndex(99);
    }

    @Test
    public void test_columnIndex_regionsRegionIsoCode() {
        IndexedTable.Index index = this.regionsTable.columnIndex(0);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)index.find(null));
        Assert.assertEquals((Object)ImmutableSet.of((Object)0), (Object)index.find((Object)"11"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)1), (Object)index.find((Object)13));
        Assert.assertEquals((Object)ImmutableSet.of((Object)12), (Object)index.find((Object)"QC"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)15, (Object)16), (Object)index.find((Object)"VA"));
    }

    @Test
    public void test_columnReader_countriesCountryNumber() {
        IndexedTable.Reader reader = this.countriesTable.columnReader(0);
        Assert.assertEquals((Object)0L, (Object)reader.read(0));
        Assert.assertEquals((Object)1L, (Object)reader.read(1));
    }

    @Test
    public void test_columnReader_countriesCountryName() {
        IndexedTable.Reader reader = this.countriesTable.columnReader(2);
        Assert.assertEquals((Object)"Australia", (Object)reader.read(0));
        Assert.assertEquals((Object)"Canada", (Object)reader.read(1));
        Assert.assertEquals((Object)"Atlantis", (Object)reader.read(14));
    }

    @Test
    public void test_columnReader_countriesOutOfBoundsRow() {
        IndexedTable.Reader reader = this.countriesTable.columnReader(0);
        this.expectedException.expect(IndexOutOfBoundsException.class);
        reader.read(99);
    }

    @Test
    public void test_columnReader_countriesOutOfBoundsColumn() {
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.countriesTable.columnReader(99);
    }

    @Test
    public void testVersion() {
        Assert.assertEquals((Object)JoinTestHelper.INDEXED_TABLE_VERSION, (Object)this.countriesTable.version());
        Assert.assertEquals((Object)JoinTestHelper.INDEXED_TABLE_VERSION, (Object)this.regionsTable.version());
    }

    @Test
    public void testIsCacheable() throws IOException {
        Assert.assertFalse((boolean)this.countriesTable.isCacheable());
        RowBasedIndexedTable<Map<String, Object>> countriesTableWithCacheKey = JoinTestHelper.createCountriesIndexedTableWithCacheKey();
        Assert.assertTrue((boolean)countriesTableWithCacheKey.isCacheable());
        Assert.assertArrayEquals((byte[])JoinTestHelper.INDEXED_TABLE_CACHE_KEY, (byte[])countriesTableWithCacheKey.computeCacheKey());
    }
}

