/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.NestedDataColumnIndexer;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.BitmapColumnIndex;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedDataColumnSerializerV4;
import org.apache.druid.segment.nested.NestedDataColumnSupplierV4;
import org.apache.druid.segment.nested.NestedDataColumnV3;
import org.apache.druid.segment.nested.NestedDataColumnV4;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplierTest;
import org.apache.druid.segment.nested.NestedFieldDictionaryEncodedColumn;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.utils.CompressionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedDataColumnSupplierV4Test
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    private static final String NO_MATCH = "no";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory((BitmapFactory)new RoaringBitmapFactory());
    List<Map<String, Object>> data = ImmutableList.of(TestHelper.makeMap("x", 1L, "y", 1.0, "z", "a", "v", "100", "nullish", "notnull"), TestHelper.makeMap("y", 3.0, "z", "d", "v", 1000L, "nullish", null), TestHelper.makeMap("x", 5L, "y", 5.0, "z", "b", "nullish", ""), TestHelper.makeMap("x", 3L, "y", 4.0, "z", "c", "v", 3000.333, "nullish", "null"), TestHelper.makeMap("x", 2L, "v", "40000"), TestHelper.makeMap("x", 4L, "y", 2.0, "z", "e", "v", 11111L, "nullish", null));
    List<Map<String, Object>> arrayTestData = ImmutableList.of(TestHelper.makeMap("s", new Object[]{"a", "b", "c"}, "l", new Object[]{1L, 2L, 3L}, "d", new Object[]{1.1, 2.2}), TestHelper.makeMap("s", new Object[]{null, "b", "c"}, "l", new Object[]{1L, null, 3L}, "d", new Object[]{2.2, 2.2}), TestHelper.makeMap("s", new Object[]{"b", "c"}, "l", new Object[]{null, null}, "d", new Object[]{1.1, null, 2.2}), TestHelper.makeMap("s", new Object[]{"a", "b", "c", "d"}, "l", new Object[]{4L, 2L, 3L}), TestHelper.makeMap("s", new Object[]{"d", "b", "c", "a"}, "d", new Object[]{1.1, 2.2}), TestHelper.makeMap("l", new Object[]{1L, 2L, 3L}, "d", new Object[]{3.1, 2.2, 1.9}));
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;
    SmooshedFileMapper arrayFileMapper;
    ByteBuffer arrayBaseBuffer;

    @BeforeClass
    public static void staticSetup() {
        NestedDataModule.registerHandlersAndSerde();
    }

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test";
        String arrayFileNameBase = "array";
        this.fileMapper = this.smooshify("test", this.tempFolder.newFolder(), this.data);
        this.baseBuffer = this.fileMapper.mapFile("test");
        this.arrayFileMapper = this.smooshify("array", this.tempFolder.newFolder(), this.arrayTestData);
        this.arrayBaseBuffer = this.arrayFileMapper.mapFile("array");
    }

    private SmooshedFileMapper smooshify(String fileNameBase, File tmpFile, List<Map<String, Object>> data) throws IOException {
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            NestedDataColumnSerializerV4 serializer = new NestedDataColumnSerializerV4(fileNameBase, IndexSpec.DEFAULT, writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), this.closer);
            NestedDataColumnIndexer indexer = new NestedDataColumnIndexer();
            for (Map<String, Object> o : data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            IndexableAdapter.NestedColumnMergable mergable = (IndexableAdapter.NestedColumnMergable)this.closer.register((Closeable)new IndexableAdapter.NestedColumnMergable(indexer.getSortedValueLookups(), indexer.getFieldTypeInfo()));
            SortedValueDictionary globalDictionarySortedCollector = mergable.getValueDictionary();
            mergable.mergeFieldsInto(sortedFields);
            serializer.open();
            serializer.serializeFields(sortedFields);
            serializer.serializeDictionaries((Iterable)globalDictionarySortedCollector.getSortedStrings(), (Iterable)globalDictionarySortedCollector.getSortedLongs(), (Iterable)globalDictionarySortedCollector.getSortedDoubles());
            SettableSelector valueSelector = new SettableSelector();
            for (Map<String, Object> o : data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileNameBase, serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            SmooshedFileMapper smooshedFileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            return smooshedFileMapper;
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() throws IOException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ComplexColumnPartSerde partSerde = ComplexColumnPartSerde.createDeserializer((String)"json");
        ColumnPartSerde.Deserializer deserializer = partSerde.getDeserializer();
        deserializer.read(this.baseBuffer, bob, NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        ColumnHolder holder = bob.build();
        ColumnCapabilities capabilities = holder.getCapabilities();
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)capabilities.toColumnType());
        Assert.assertTrue((boolean)capabilities.isFilterable());
        Assert.assertTrue((boolean)(holder.getColumnFormat() instanceof NestedDataComplexTypeSerde.NestedColumnFormatV4));
        try (NestedDataComplexColumn column = (NestedDataComplexColumn)holder.getColumn();){
            this.smokeTest(column);
        }
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        NestedDataColumnSupplierV4 supplier = NestedDataColumnSupplierV4.read((ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES, (ObjectMapper)NestedDataComplexTypeSerde.OBJECT_MAPPER);
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)10, (String)"NestedDataColumnSupplierTest-%d"));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        CountDownLatch threadsStartLatch = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    threadsStartLatch.await();
                    for (int iter = 0; iter < 5000; ++iter) {
                        try (NestedDataComplexColumn column = (NestedDataComplexColumn)supplier.get();){
                            this.smokeTest(column);
                            continue;
                        }
                    }
                }
                catch (Throwable ex) {
                    failureReason.set(ex.getMessage());
                }
            }));
        }
        threadsStartLatch.countDown();
        Futures.allAsList(futures).get();
        Assert.assertEquals((Object)"none", (Object)failureReason.get());
    }

    @Test
    public void testLegacyV3ReaderFormat() throws IOException {
        String columnName = "shipTo";
        String firstValue = "Cole";
        File tmpLocation = this.tempFolder.newFolder();
        CompressionUtils.unzip((InputStream)NestedDataColumnSupplierV4Test.class.getClassLoader().getResourceAsStream("nested_segment_v3/index.zip"), (File)tmpLocation);
        try (Closer closer = Closer.create();){
            QueryableIndex theIndex = (QueryableIndex)closer.register((Closeable)TestHelper.getTestIndexIO().loadIndex(tmpLocation));
            ColumnHolder holder = theIndex.getColumnHolder(columnName);
            Assert.assertNotNull((Object)holder);
            Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)holder.getCapabilities().toColumnType());
            NestedDataColumnV3 v3 = (NestedDataColumnV3)closer.register((Closeable)((NestedDataColumnV3)holder.getColumn()));
            Assert.assertNotNull((Object)v3);
            ImmutableList path = ImmutableList.of((Object)new NestedPathField("lastName"));
            ColumnHolder nestedColumnHolder = v3.getColumnHolder((List)path);
            Assert.assertNotNull((Object)nestedColumnHolder);
            Assert.assertEquals((Object)ColumnType.STRING, (Object)nestedColumnHolder.getCapabilities().toColumnType());
            NestedFieldDictionaryEncodedColumn nestedColumn = (NestedFieldDictionaryEncodedColumn)nestedColumnHolder.getColumn();
            Assert.assertNotNull((Object)nestedColumn);
            ColumnValueSelector selector = nestedColumn.makeColumnValueSelector((ReadableOffset)new SimpleAscendingOffset(theIndex.getNumRows()));
            ColumnIndexSupplier indexSupplier = v3.getColumnIndexSupplier((List)path);
            Assert.assertNotNull((Object)indexSupplier);
            StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
            Assert.assertNotNull((Object)valueSetIndex);
            BitmapColumnIndex indexForValue = valueSetIndex.forValue(firstValue);
            Assert.assertEquals((Object)firstValue, (Object)selector.getObject());
            Assert.assertTrue((boolean)((ImmutableBitmap)indexForValue.computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(0));
        }
    }

    @Test
    public void testLegacyV4ReaderFormat() throws IOException {
        String columnName = "shipTo";
        String firstValue = "Beatty";
        File tmpLocation = this.tempFolder.newFolder();
        CompressionUtils.unzip((InputStream)NestedDataColumnSupplierV4Test.class.getClassLoader().getResourceAsStream("nested_segment_v4/index.zip"), (File)tmpLocation);
        try (Closer closer = Closer.create();){
            QueryableIndex theIndex = (QueryableIndex)closer.register((Closeable)TestHelper.getTestIndexIO().loadIndex(tmpLocation));
            ColumnHolder holder = theIndex.getColumnHolder(columnName);
            Assert.assertNotNull((Object)holder);
            Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)holder.getCapabilities().toColumnType());
            NestedDataColumnV4 v4 = (NestedDataColumnV4)closer.register((Closeable)((NestedDataColumnV4)holder.getColumn()));
            Assert.assertNotNull((Object)v4);
            ImmutableList path = ImmutableList.of((Object)new NestedPathField("lastName"));
            ColumnHolder nestedColumnHolder = v4.getColumnHolder((List)path);
            Assert.assertNotNull((Object)nestedColumnHolder);
            Assert.assertEquals((Object)ColumnType.STRING, (Object)nestedColumnHolder.getCapabilities().toColumnType());
            NestedFieldDictionaryEncodedColumn nestedColumn = (NestedFieldDictionaryEncodedColumn)nestedColumnHolder.getColumn();
            Assert.assertNotNull((Object)nestedColumn);
            ColumnValueSelector selector = nestedColumn.makeColumnValueSelector((ReadableOffset)new SimpleAscendingOffset(theIndex.getNumRows()));
            ColumnIndexSupplier indexSupplier = v4.getColumnIndexSupplier((List)path);
            Assert.assertNotNull((Object)indexSupplier);
            StringValueSetIndex valueSetIndex = (StringValueSetIndex)indexSupplier.as(StringValueSetIndex.class);
            Assert.assertNotNull((Object)valueSetIndex);
            BitmapColumnIndex indexForValue = valueSetIndex.forValue(firstValue);
            Assert.assertEquals((Object)firstValue, (Object)selector.getObject());
            Assert.assertTrue((boolean)((ImmutableBitmap)indexForValue.computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(0));
        }
    }

    private void smokeTest(NestedDataComplexColumn column) throws IOException {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        ColumnValueSelector rawSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        List xPath = NestedPathFinder.parseJsonPath((String)"$.x");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.LONG), (Object)column.getColumnTypes(xPath));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)column.getColumnHolder(xPath).getCapabilities().toColumnType());
        ColumnValueSelector xSelector = column.makeColumnValueSelector(xPath, (ReadableOffset)offset);
        DimensionSelector xDimSelector = column.makeDimensionSelector(xPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier xIndexSupplier = column.getColumnIndexSupplier(xPath);
        Assert.assertNotNull((Object)xIndexSupplier);
        StringValueSetIndex xValueIndex = (StringValueSetIndex)xIndexSupplier.as(StringValueSetIndex.class);
        DruidPredicateIndex xPredicateIndex = (DruidPredicateIndex)xIndexSupplier.as(DruidPredicateIndex.class);
        NullValueIndex xNulls = (NullValueIndex)xIndexSupplier.as(NullValueIndex.class);
        List yPath = NestedPathFinder.parseJsonPath((String)"$.y");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.DOUBLE), (Object)column.getColumnTypes(yPath));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)column.getColumnHolder(yPath).getCapabilities().toColumnType());
        ColumnValueSelector ySelector = column.makeColumnValueSelector(yPath, (ReadableOffset)offset);
        DimensionSelector yDimSelector = column.makeDimensionSelector(yPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier yIndexSupplier = column.getColumnIndexSupplier(yPath);
        Assert.assertNotNull((Object)yIndexSupplier);
        StringValueSetIndex yValueIndex = (StringValueSetIndex)yIndexSupplier.as(StringValueSetIndex.class);
        DruidPredicateIndex yPredicateIndex = (DruidPredicateIndex)yIndexSupplier.as(DruidPredicateIndex.class);
        NullValueIndex yNulls = (NullValueIndex)yIndexSupplier.as(NullValueIndex.class);
        List zPath = NestedPathFinder.parseJsonPath((String)"$.z");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING), (Object)column.getColumnTypes(zPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(zPath).getCapabilities().toColumnType());
        ColumnValueSelector zSelector = column.makeColumnValueSelector(zPath, (ReadableOffset)offset);
        DimensionSelector zDimSelector = column.makeDimensionSelector(zPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier zIndexSupplier = column.getColumnIndexSupplier(zPath);
        Assert.assertNotNull((Object)zIndexSupplier);
        StringValueSetIndex zValueIndex = (StringValueSetIndex)zIndexSupplier.as(StringValueSetIndex.class);
        DruidPredicateIndex zPredicateIndex = (DruidPredicateIndex)zIndexSupplier.as(DruidPredicateIndex.class);
        NullValueIndex zNulls = (NullValueIndex)zIndexSupplier.as(NullValueIndex.class);
        List vPath = NestedPathFinder.parseJsonPath((String)"$.v");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING, (Object)ColumnType.LONG, (Object)ColumnType.DOUBLE), (Object)column.getColumnTypes(vPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(vPath).getCapabilities().toColumnType());
        ColumnValueSelector vSelector = column.makeColumnValueSelector(vPath, (ReadableOffset)offset);
        DimensionSelector vDimSelector = column.makeDimensionSelector(vPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier vIndexSupplier = column.getColumnIndexSupplier(vPath);
        Assert.assertNotNull((Object)vIndexSupplier);
        StringValueSetIndex vValueIndex = (StringValueSetIndex)vIndexSupplier.as(StringValueSetIndex.class);
        DruidPredicateIndex vPredicateIndex = (DruidPredicateIndex)vIndexSupplier.as(DruidPredicateIndex.class);
        NullValueIndex vNulls = (NullValueIndex)vIndexSupplier.as(NullValueIndex.class);
        List nullishPath = NestedPathFinder.parseJsonPath((String)"$.nullish");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING), (Object)column.getColumnTypes(nullishPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(nullishPath).getCapabilities().toColumnType());
        ColumnValueSelector nullishSelector = column.makeColumnValueSelector(nullishPath, (ReadableOffset)offset);
        DimensionSelector nullishDimSelector = column.makeDimensionSelector(nullishPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier nullishIndexSupplier = column.getColumnIndexSupplier(nullishPath);
        Assert.assertNotNull((Object)nullishIndexSupplier);
        StringValueSetIndex nullishValueIndex = (StringValueSetIndex)nullishIndexSupplier.as(StringValueSetIndex.class);
        DruidPredicateIndex nullishPredicateIndex = (DruidPredicateIndex)nullishIndexSupplier.as(DruidPredicateIndex.class);
        NullValueIndex nullishNulls = (NullValueIndex)nullishIndexSupplier.as(NullValueIndex.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)nullishPath, (Object)vPath, (Object)xPath, (Object)yPath, (Object)zPath), (Object)column.getNestedFields());
        for (int i = 0; i < this.data.size(); ++i) {
            Map<String, Object> row = this.data.get(i);
            Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawSelector.getObject())));
            this.testPath(row, i, "v", vSelector, vDimSelector, vValueIndex, vPredicateIndex, vNulls, null);
            this.testPath(row, i, "x", xSelector, xDimSelector, xValueIndex, xPredicateIndex, xNulls, ColumnType.LONG);
            this.testPath(row, i, "y", ySelector, yDimSelector, yValueIndex, yPredicateIndex, yNulls, ColumnType.DOUBLE);
            this.testPath(row, i, "z", zSelector, zDimSelector, zValueIndex, zPredicateIndex, zNulls, ColumnType.STRING);
            this.testPath(row, i, "nullish", nullishSelector, nullishDimSelector, nullishValueIndex, nullishPredicateIndex, nullishNulls, ColumnType.STRING);
            offset.increment();
        }
    }

    private void testPath(Map row, int rowNumber, String path, ColumnValueSelector<?> valueSelector, DimensionSelector dimSelector, StringValueSetIndex valueSetIndex, DruidPredicateIndex predicateIndex, NullValueIndex nullValueIndex, @Nullable ColumnType singleType) {
        boolean isStringAndNullEquivalent;
        Object inputValue = row.get(path);
        boolean bl = isStringAndNullEquivalent = inputValue instanceof String && NullHandling.isNullOrEquivalent((String)((String)inputValue));
        if (row.containsKey(path) && inputValue != null && !isStringAndNullEquivalent) {
            Assert.assertEquals(inputValue, (Object)valueSelector.getObject());
            if (ColumnType.LONG.equals((Object)singleType)) {
                Assert.assertEquals(inputValue, (Object)valueSelector.getLong());
                Assert.assertFalse((String)(path + " is not null"), (boolean)valueSelector.isNull());
            } else if (ColumnType.DOUBLE.equals((Object)singleType)) {
                Assert.assertEquals((double)((Double)inputValue), (double)valueSelector.getDouble(), (double)0.0);
                Assert.assertFalse((String)(path + " is not null"), (boolean)valueSelector.isNull());
            }
            String theString = String.valueOf(inputValue);
            Assert.assertEquals((Object)theString, (Object)dimSelector.getObject());
            String dimSelectorLookupVal = dimSelector.lookupName(dimSelector.getRow().get(0));
            Assert.assertEquals((Object)theString, (Object)dimSelectorLookupVal);
            Assert.assertEquals((long)dimSelector.idLookup().lookupId(dimSelectorLookupVal), (long)dimSelector.getRow().get(0));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(theString).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)theString))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(theString)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)NO_MATCH))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher(theString).matches());
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches());
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher(x -> Objects.equals(x, theString)).matches());
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(x -> Objects.equals(x, NO_MATCH)).matches());
        } else {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((String)path, (boolean)valueSelector.isNull());
            Assert.assertEquals((long)0L, (long)dimSelector.getRow().get(0));
            Assert.assertNull((Object)dimSelector.getObject());
            Assert.assertNull((Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(rowNumber));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((String)null).matches());
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches());
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher(x -> x == null).matches());
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(x -> Objects.equals(x, NO_MATCH)).matches());
        }
    }

    private static class OnlyPositionalReadsTypeStrategy<T>
    implements TypeStrategy<T> {
        private final TypeStrategy<T> delegate;

        private OnlyPositionalReadsTypeStrategy(TypeStrategy<T> delegate) {
            this.delegate = delegate;
        }

        public int estimateSizeBytes(T value) {
            return this.delegate.estimateSizeBytes(value);
        }

        public T read(ByteBuffer buffer) {
            throw new IllegalStateException("non-positional read");
        }

        public boolean readRetainsBufferReference() {
            return this.delegate.readRetainsBufferReference();
        }

        public int write(ByteBuffer buffer, T value, int maxSizeBytes) {
            return this.delegate.write(buffer, value, maxSizeBytes);
        }

        public T read(ByteBuffer buffer, int offset) {
            return (T)this.delegate.read(buffer, offset);
        }

        public int write(ByteBuffer buffer, int offset, T value, int maxSizeBytes) {
            return this.delegate.write(buffer, offset, value, maxSizeBytes);
        }

        public int compare(Object o1, Object o2) {
            return this.delegate.compare(o1, o2);
        }
    }

    private static class SettableSelector
    extends ObjectColumnSelector<StructuredData> {
        private StructuredData data;

        private SettableSelector() {
        }

        public void setObject(StructuredData o) {
            this.data = o;
        }

        @Nullable
        public StructuredData getObject() {
            return this.data;
        }

        public Class classOfObject() {
            return StructuredData.class;
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

