/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class NestedFieldTypeInfoTest {
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());

    @Test
    public void testSingleType() throws IOException {
        ImmutableList supportedTypes = ImmutableList.of((Object)ColumnType.STRING, (Object)ColumnType.LONG, (Object)ColumnType.DOUBLE, (Object)ColumnType.STRING_ARRAY, (Object)ColumnType.LONG_ARRAY, (Object)ColumnType.DOUBLE_ARRAY);
        for (ColumnType type : supportedTypes) {
            this.testSingleType(type);
        }
    }

    @Test
    public void testMultiType() throws IOException {
        ImmutableList tests = ImmutableList.of((Object)ImmutableSet.of((Object)ColumnType.STRING, (Object)ColumnType.LONG), (Object)ImmutableSet.of((Object)ColumnType.LONG, (Object)ColumnType.DOUBLE), (Object)ImmutableSet.of((Object)ColumnType.STRING, (Object)ColumnType.LONG, (Object)ColumnType.DOUBLE), (Object)ImmutableSet.of((Object)ColumnType.DOUBLE, (Object)ColumnType.DOUBLE_ARRAY), (Object)ImmutableSet.of((Object)ColumnType.LONG_ARRAY, (Object)ColumnType.DOUBLE_ARRAY));
        for (Set typeSet : tests) {
            this.testMultiType(typeSet);
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(FieldTypeInfo.TypeSet.class).usingGetClass().verify();
        EqualsVerifier.forClass(FieldTypeInfo.MutableTypeSet.class).suppress(new Warning[]{Warning.NONFINAL_FIELDS}).usingGetClass().verify();
    }

    private void testSingleType(ColumnType columnType) throws IOException {
        FieldTypeInfo.MutableTypeSet typeSet = new FieldTypeInfo.MutableTypeSet();
        Assert.assertNull((Object)typeSet.getSingleType());
        Assert.assertTrue((boolean)typeSet.isEmpty());
        typeSet.add(columnType);
        Assert.assertEquals((Object)columnType, (Object)typeSet.getSingleType());
        Assert.assertEquals((Object)ImmutableSet.of((Object)columnType), (Object)FieldTypeInfo.convertToSet((byte)typeSet.getByteValue()));
        NestedFieldTypeInfoTest.writeTypeSet(typeSet);
        FieldTypeInfo info = new FieldTypeInfo(BUFFER);
        Assert.assertEquals((long)0L, (long)BUFFER.position());
        FieldTypeInfo.TypeSet roundTrip = info.getTypes(0);
        Assert.assertEquals((Object)columnType, (Object)roundTrip.getSingleType());
        FieldTypeInfo info2 = FieldTypeInfo.read((ByteBuffer)BUFFER, (int)1);
        Assert.assertEquals((Object)info.getTypes(0), (Object)info2.getTypes(0));
        Assert.assertEquals((long)1L, (long)BUFFER.position());
    }

    private void testMultiType(Set<ColumnType> columnTypes) throws IOException {
        FieldTypeInfo.MutableTypeSet typeSet = new FieldTypeInfo.MutableTypeSet();
        Assert.assertNull((Object)typeSet.getSingleType());
        Assert.assertTrue((boolean)typeSet.isEmpty());
        FieldTypeInfo.MutableTypeSet merge = new FieldTypeInfo.MutableTypeSet();
        for (ColumnType columnType : columnTypes) {
            typeSet.add(columnType);
            merge.merge(new FieldTypeInfo.MutableTypeSet().add(columnType).getByteValue());
        }
        Assert.assertEquals((long)merge.getByteValue(), (long)typeSet.getByteValue());
        Assert.assertNull((Object)typeSet.getSingleType());
        Assert.assertEquals(columnTypes, (Object)FieldTypeInfo.convertToSet((byte)typeSet.getByteValue()));
        NestedFieldTypeInfoTest.writeTypeSet(typeSet);
        FieldTypeInfo info = new FieldTypeInfo(BUFFER);
        Assert.assertEquals((long)0L, (long)BUFFER.position());
        FieldTypeInfo.TypeSet roundTrip = info.getTypes(0);
        Assert.assertNull((Object)roundTrip.getSingleType());
        Assert.assertEquals(columnTypes, (Object)FieldTypeInfo.convertToSet((byte)roundTrip.getByteValue()));
        FieldTypeInfo info2 = FieldTypeInfo.read((ByteBuffer)BUFFER, (int)1);
        Assert.assertEquals((Object)info.getTypes(0), (Object)info2.getTypes(0));
        Assert.assertEquals((long)1L, (long)BUFFER.position());
    }

    private static void writeTypeSet(FieldTypeInfo.MutableTypeSet typeSet) throws IOException {
        BUFFER.position(0);
        FieldTypeInfo.Writer writer = new FieldTypeInfo.Writer((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium());
        writer.open();
        writer.write(typeSet);
        Assert.assertEquals((long)1L, (long)writer.getSerializedSize());
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                BUFFER.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        writer.writeTo(channel, null);
        Assert.assertEquals((long)1L, (long)BUFFER.position());
        BUFFER.position(0);
    }
}

