/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnSupplierTest;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplierTest;
import org.apache.druid.segment.nested.ScalarLongColumn;
import org.apache.druid.segment.nested.ScalarLongColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarLongColumnSerializer;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ScalarLongColumnSupplierTest
extends InitializedNullHandlingTest {
    private static final String NO_MATCH = "no";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    BitmapSerdeFactory bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(this.bitmapSerdeFactory.getBitmapFactory());
    List<Long> data = Arrays.asList(1L, 0L, null, 2L, 3L, 4L);
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;

    @BeforeClass
    public static void staticSetup() {
        NestedDataModule.registerHandlersAndSerde();
    }

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test";
        this.fileMapper = this.smooshify("test", this.tempFolder.newFolder(), this.data);
        this.baseBuffer = this.fileMapper.mapFile("test");
    }

    private SmooshedFileMapper smooshify(String fileNameBase, File tmpFile, List<?> data) throws IOException {
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            ScalarLongColumnSerializer serializer = new ScalarLongColumnSerializer(fileNameBase, IndexSpec.DEFAULT, writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), this.closer);
            AutoTypeColumnIndexer indexer = new AutoTypeColumnIndexer();
            for (Object o : data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            IndexableAdapter.NestedColumnMergable mergable = (IndexableAdapter.NestedColumnMergable)this.closer.register((Closeable)new IndexableAdapter.NestedColumnMergable(indexer.getSortedValueLookups(), indexer.getFieldTypeInfo()));
            SortedValueDictionary globalDictionarySortedCollector = mergable.getValueDictionary();
            mergable.mergeFieldsInto(sortedFields);
            serializer.openDictionaryWriter();
            serializer.serializeDictionaries((Iterable)globalDictionarySortedCollector.getSortedStrings(), (Iterable)globalDictionarySortedCollector.getSortedLongs(), (Iterable)globalDictionarySortedCollector.getSortedDoubles(), () -> new AutoTypeColumnMerger.ArrayDictionaryMergingIterator(new Iterable[]{globalDictionarySortedCollector.getSortedArrays()}, serializer.getGlobalLookup()));
            serializer.open();
            NestedDataColumnSupplierTest.SettableSelector valueSelector = new NestedDataColumnSupplierTest.SettableSelector();
            for (Object o : data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileNameBase, serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            SmooshedFileMapper smooshedFileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            return smooshedFileMapper;
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ScalarLongColumnAndIndexSupplier supplier = ScalarLongColumnAndIndexSupplier.read((ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        try (ScalarLongColumn column = (ScalarLongColumn)supplier.get();){
            this.smokeTest(supplier, column);
        }
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ScalarLongColumnAndIndexSupplier supplier = ScalarLongColumnAndIndexSupplier.read((ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)10, (String)"StandardNestedColumnSupplierTest-%d"));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        CountDownLatch threadsStartLatch = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    threadsStartLatch.await();
                    for (int iter = 0; iter < 5000; ++iter) {
                        try (ScalarLongColumn column = (ScalarLongColumn)supplier.get();){
                            this.smokeTest(supplier, column);
                            continue;
                        }
                    }
                }
                catch (Throwable ex) {
                    failureReason.set(ex.getMessage());
                }
            }));
        }
        threadsStartLatch.countDown();
        Futures.allAsList(futures).get();
        Assert.assertEquals((Object)"none", (Object)failureReason.get());
    }

    private void smokeTest(ScalarLongColumnAndIndexSupplier supplier, ScalarLongColumn column) {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(1, 0, this.data.size());
        ColumnValueSelector valueSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        VectorValueSelector vectorValueSelector = column.makeVectorValueSelector((ReadableVectorOffset)vectorOffset);
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)supplier.as(StringValueSetIndex.class);
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)supplier.as(DruidPredicateIndex.class);
        NullValueIndex nullValueIndex = (NullValueIndex)supplier.as(NullValueIndex.class);
        SortedMap fields = column.getFieldTypeInfo();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"$", (Object)new FieldTypeInfo.MutableTypeSet().add(ColumnType.LONG)), (Object)fields);
        for (int i = 0; i < this.data.size(); ++i) {
            Long row = this.data.get(i);
            if (row != null) {
                Assert.assertEquals((Object)row, (Object)valueSelector.getObject());
                Assert.assertEquals((long)row, (long)valueSelector.getLong());
                Assert.assertFalse((boolean)valueSelector.isNull());
                Assert.assertEquals((long)row, (long)vectorValueSelector.getLongVector()[0]);
                Assert.assertEquals((double)row.doubleValue(), (double)vectorValueSelector.getDoubleVector()[0], (double)0.0);
                Assert.assertEquals((double)row.floatValue(), (double)vectorValueSelector.getFloatVector()[0], (double)0.0);
                boolean[] nullVector = vectorValueSelector.getNullVector();
                if (NullHandling.sqlCompatible() && nullVector != null) {
                    Assert.assertFalse((boolean)nullVector[0]);
                } else {
                    Assert.assertNull((Object)nullVector);
                }
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(String.valueOf(row)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)String.valueOf(row)))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(String.valueOf(row))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)NO_MATCH))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            } else {
                if (NullHandling.sqlCompatible()) {
                    Assert.assertNull((Object)valueSelector.getObject());
                    Assert.assertTrue((boolean)valueSelector.isNull());
                    Assert.assertTrue((boolean)vectorValueSelector.getNullVector()[0]);
                    Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                    Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                    Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                } else {
                    Assert.assertEquals((Object)NullHandling.defaultLongValue(), (Object)valueSelector.getObject());
                    Assert.assertFalse((boolean)valueSelector.isNull());
                    Assert.assertNull((Object)vectorValueSelector.getNullVector());
                    Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                    Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                    Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                    String defaultString = String.valueOf(NullHandling.defaultLongValue());
                    Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(defaultString).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                    Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(defaultString)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                }
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
            }
            offset.increment();
            vectorOffset.advance();
        }
    }
}

