/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DruidPredicateIndex;
import org.apache.druid.segment.column.NullValueIndex;
import org.apache.druid.segment.column.StringValueSetIndex;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnSupplierTest;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplierTest;
import org.apache.druid.segment.nested.ScalarStringColumnAndIndexSupplier;
import org.apache.druid.segment.nested.ScalarStringColumnSerializer;
import org.apache.druid.segment.nested.ScalarStringDictionaryEncodedColumn;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ScalarStringColumnSupplierTest
extends InitializedNullHandlingTest {
    private static final String NO_MATCH = "no";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    BitmapSerdeFactory bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(this.bitmapSerdeFactory.getBitmapFactory());
    List<String> data = Arrays.asList("a", "b", null, "", "null", "c");
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;

    @BeforeClass
    public static void staticSetup() {
        NestedDataModule.registerHandlersAndSerde();
    }

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test";
        this.fileMapper = this.smooshify("test", this.tempFolder.newFolder(), this.data);
        this.baseBuffer = this.fileMapper.mapFile("test");
    }

    private SmooshedFileMapper smooshify(String fileNameBase, File tmpFile, List<?> data) throws IOException {
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            ScalarStringColumnSerializer serializer = new ScalarStringColumnSerializer(fileNameBase, IndexSpec.DEFAULT, writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), this.closer);
            AutoTypeColumnIndexer indexer = new AutoTypeColumnIndexer();
            for (Object o : data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            IndexableAdapter.NestedColumnMergable mergable = (IndexableAdapter.NestedColumnMergable)this.closer.register((Closeable)new IndexableAdapter.NestedColumnMergable(indexer.getSortedValueLookups(), indexer.getFieldTypeInfo()));
            SortedValueDictionary globalDictionarySortedCollector = mergable.getValueDictionary();
            mergable.mergeFieldsInto(sortedFields);
            serializer.openDictionaryWriter();
            serializer.serializeDictionaries((Iterable)globalDictionarySortedCollector.getSortedStrings(), (Iterable)globalDictionarySortedCollector.getSortedLongs(), (Iterable)globalDictionarySortedCollector.getSortedDoubles(), () -> new AutoTypeColumnMerger.ArrayDictionaryMergingIterator(new Iterable[]{globalDictionarySortedCollector.getSortedArrays()}, serializer.getGlobalLookup()));
            serializer.open();
            NestedDataColumnSupplierTest.SettableSelector valueSelector = new NestedDataColumnSupplierTest.SettableSelector();
            for (Object o : data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileNameBase, serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            SmooshedFileMapper smooshedFileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            return smooshedFileMapper;
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() throws IOException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ScalarStringColumnAndIndexSupplier supplier = ScalarStringColumnAndIndexSupplier.read((ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        try (ScalarStringDictionaryEncodedColumn column = (ScalarStringDictionaryEncodedColumn)supplier.get();){
            this.smokeTest(supplier, column);
        }
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        ScalarStringColumnAndIndexSupplier supplier = ScalarStringColumnAndIndexSupplier.read((ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)10, (String)"StandardNestedColumnSupplierTest-%d"));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        CountDownLatch threadsStartLatch = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    threadsStartLatch.await();
                    for (int iter = 0; iter < 5000; ++iter) {
                        try (ScalarStringDictionaryEncodedColumn column = (ScalarStringDictionaryEncodedColumn)supplier.get();){
                            this.smokeTest(supplier, column);
                            continue;
                        }
                    }
                }
                catch (Throwable ex) {
                    failureReason.set(ex.getMessage());
                }
            }));
        }
        threadsStartLatch.countDown();
        Futures.allAsList(futures).get();
        Assert.assertEquals((Object)"none", (Object)failureReason.get());
    }

    private void smokeTest(ScalarStringColumnAndIndexSupplier supplier, ScalarStringDictionaryEncodedColumn column) {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        ColumnValueSelector valueSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        HistoricalDimensionSelector dimSelector = column.makeDimensionSelector((ReadableOffset)offset, null);
        StringValueSetIndex valueSetIndex = (StringValueSetIndex)supplier.as(StringValueSetIndex.class);
        DruidPredicateIndex predicateIndex = (DruidPredicateIndex)supplier.as(DruidPredicateIndex.class);
        NullValueIndex nullValueIndex = (NullValueIndex)supplier.as(NullValueIndex.class);
        SortedMap fields = column.getFieldTypeInfo();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"$", (Object)new FieldTypeInfo.MutableTypeSet().add(ColumnType.STRING)), (Object)fields);
        for (int i = 0; i < this.data.size(); ++i) {
            String row = this.data.get(i);
            boolean isStringAndNullEquivalent = NullHandling.isNullOrEquivalent((String)row);
            if (row != null && !isStringAndNullEquivalent) {
                Assert.assertEquals((Object)row, (Object)valueSelector.getObject());
                Assert.assertEquals((Object)row, (Object)dimSelector.getObject());
                String dimSelectorLookupVal = dimSelector.lookupName(dimSelector.getRow().get(0));
                Assert.assertEquals((Object)row, (Object)dimSelectorLookupVal);
                Assert.assertEquals((long)dimSelector.idLookup().lookupId(dimSelectorLookupVal), (long)dimSelector.getRow().get(0));
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(row).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)row))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(row)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)NO_MATCH))).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)dimSelector.makeValueMatcher(row).matches());
                Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches());
                Assert.assertTrue((boolean)dimSelector.makeValueMatcher(x -> Objects.equals(x, row)).matches());
                Assert.assertFalse((boolean)dimSelector.makeValueMatcher(x -> Objects.equals(x, NO_MATCH)).matches());
            } else {
                Assert.assertNull((Object)valueSelector.getObject());
                Assert.assertEquals((long)0L, (long)dimSelector.getRow().get(0));
                Assert.assertNull((Object)dimSelector.getObject());
                Assert.assertNull((Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
                Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.forNull().computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory)).get(i));
                Assert.assertTrue((boolean)dimSelector.makeValueMatcher((String)null).matches());
                Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches());
                Assert.assertTrue((boolean)dimSelector.makeValueMatcher(x -> x == null).matches());
                Assert.assertFalse((boolean)dimSelector.makeValueMatcher(x -> Objects.equals(x, NO_MATCH)).matches());
            }
            offset.increment();
        }
    }
}

