/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.junit.Assert;

public class AlwaysTwoVectorizedVirtualColumn
implements VirtualColumn {
    static final String DONT_CALL_THIS = "don't call this";
    private final String outputName;
    private final ColumnCapabilities capabilities;
    private final boolean dictionaryEncoded;
    private final boolean canVectorize;

    public AlwaysTwoVectorizedVirtualColumn(String name, ColumnCapabilities capabilites) {
        this(name, capabilites, true);
    }

    public AlwaysTwoVectorizedVirtualColumn(String name, ColumnCapabilities capabilites, boolean canVectorize) {
        this.outputName = name;
        this.capabilities = capabilites;
        this.dictionaryEncoded = capabilites.isDictionaryEncoded().isTrue() && capabilites.areDictionaryValuesUnique().isTrue();
        this.canVectorize = canVectorize;
    }

    public boolean canVectorize(ColumnInspector inspector) {
        Assert.assertNotNull((Object)inspector);
        return this.canVectorize;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        throw new IllegalStateException(DONT_CALL_THIS);
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        throw new IllegalStateException(DONT_CALL_THIS);
    }

    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, final VectorColumnSelectorFactory factory) {
        Assert.assertEquals((Object)this.outputName, (Object)dimensionSpec.getOutputName());
        return new SingleValueDimensionVectorSelector(){
            private final VectorSizeInspector inspector;
            private final int[] rowVector;
            {
                this.inspector = factory.getReadableVectorInspector();
                this.rowVector = new int[this.inspector.getMaxVectorSize()];
            }

            public int[] getRowVector() {
                return this.rowVector;
            }

            public int getValueCardinality() {
                return AlwaysTwoVectorizedVirtualColumn.this.dictionaryEncoded ? 1 : -1;
            }

            @Nullable
            public String lookupName(int id) {
                return "2";
            }

            public boolean nameLookupPossibleInAdvance() {
                return AlwaysTwoVectorizedVirtualColumn.this.dictionaryEncoded;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public int getMaxVectorSize() {
                return this.inspector.getMaxVectorSize();
            }

            public int getCurrentVectorSize() {
                return this.inspector.getCurrentVectorSize();
            }
        };
    }

    public MultiValueDimensionVectorSelector makeMultiValueVectorDimensionSelector(DimensionSpec dimensionSpec, final VectorColumnSelectorFactory factory) {
        Assert.assertEquals((Object)this.outputName, (Object)dimensionSpec.getOutputName());
        Object[] rowVector = new IndexedInts[factory.getReadableVectorInspector().getMaxVectorSize()];
        Arrays.fill(rowVector, new ArrayBasedIndexedInts(new int[]{0, 0}));
        return new MultiValueDimensionVectorSelector((IndexedInts[])rowVector){
            private final VectorSizeInspector inspector;
            final /* synthetic */ IndexedInts[] val$rowVector;
            {
                this.val$rowVector = indexedIntsArray;
                this.inspector = factory.getReadableVectorInspector();
            }

            public IndexedInts[] getRowVector() {
                return this.val$rowVector;
            }

            public int getValueCardinality() {
                return AlwaysTwoVectorizedVirtualColumn.this.dictionaryEncoded ? 1 : -1;
            }

            @Nullable
            public String lookupName(int id) {
                return "2";
            }

            public boolean nameLookupPossibleInAdvance() {
                return AlwaysTwoVectorizedVirtualColumn.this.dictionaryEncoded;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public int getMaxVectorSize() {
                return this.inspector.getMaxVectorSize();
            }

            public int getCurrentVectorSize() {
                return this.inspector.getCurrentVectorSize();
            }
        };
    }

    public VectorValueSelector makeVectorValueSelector(String columnName, final VectorColumnSelectorFactory factory) {
        Assert.assertEquals((Object)this.outputName, (Object)columnName);
        final long[] longs = new long[factory.getReadableVectorInspector().getMaxVectorSize()];
        final double[] doubles = new double[factory.getReadableVectorInspector().getMaxVectorSize()];
        final float[] floats = new float[factory.getReadableVectorInspector().getMaxVectorSize()];
        Arrays.fill(longs, 2L);
        Arrays.fill(doubles, 2.0);
        Arrays.fill(floats, 2.0f);
        return new VectorValueSelector(){

            public long[] getLongVector() {
                return longs;
            }

            public float[] getFloatVector() {
                return floats;
            }

            public double[] getDoubleVector() {
                return doubles;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }

            public int getMaxVectorSize() {
                return factory.getReadableVectorInspector().getMaxVectorSize();
            }

            public int getCurrentVectorSize() {
                return factory.getReadableVectorInspector().getCurrentVectorSize();
            }
        };
    }

    public VectorObjectSelector makeVectorObjectSelector(String columnName, final VectorColumnSelectorFactory factory) {
        Assert.assertEquals((Object)this.outputName, (Object)columnName);
        final Object[] objects = new Object[factory.getReadableVectorInspector().getMaxVectorSize()];
        if (this.capabilities.hasMultipleValues().isTrue()) {
            Arrays.fill(objects, ImmutableList.of((Object)"2", (Object)"2"));
        } else {
            Arrays.fill(objects, "2");
        }
        return new VectorObjectSelector(){

            public int getMaxVectorSize() {
                return factory.getReadableVectorInspector().getMaxVectorSize();
            }

            public int getCurrentVectorSize() {
                return factory.getReadableVectorInspector().getCurrentVectorSize();
            }

            public Object[] getObjectVector() {
                return objects;
            }
        };
    }

    public ColumnCapabilities capabilities(String columnName) {
        return this.capabilities;
    }

    public List<String> requiredColumns() {
        return ImmutableList.of();
    }

    public boolean usesDotNotation() {
        return false;
    }

    public byte[] getCacheKey() {
        return new byte[0];
    }
}

