/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DeprecatedQueryableIndexColumnSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionVectorSelectorsTest
extends InitializedNullHandlingTest {
    private static List<String> EXPRESSIONS = ImmutableList.of((Object)"long1 * long2", (Object)"long1 * nonexistent", (Object)"double1 * double3", (Object)"float1 + float3", (Object)"(long1 - long4) / double3", (Object)"long5 * float3 * long1 * long4 * double1", (Object)"long5 * double3 * long1 * long4 * double1", (Object)"max(double3, double5)", (Object)"max(nonexistent, double5)", (Object)"min(double4, double1)", (Object)"cos(float3)", (Object)"sin(long4)", (Object[])new String[]{"parse_long(string1)", "parse_long(nonexistent)", "parse_long(string1) * double3", "parse_long(string5) * parse_long(string1)", "parse_long(string5) * parse_long(string1) * double3", "'string constant'", "1", "192412.24124", "null", "long2", "float2", "double2", "string3", "string1 + string3", "concat(string1, string2, string3)", "concat(string1, 'x')", "concat(string1, nonexistent)"});
    private static final int ROWS_PER_SEGMENT = 10000;
    private static QueryableIndex INDEX;
    private static QueryableIndex INDEX_OTHER_ENCODINGS;
    private static Closer CLOSER;
    private String encoding;
    private ExpressionType outputType;
    private String expression;
    private QueryableIndex queryableIndexToUse;
    private Closer perTestCloser = Closer.create();

    @BeforeClass
    public static void setupClass() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        INDEX = (QueryableIndex)CLOSER.register((Closeable)segmentGenerator.generate(dataSegment, schemaInfo, Granularities.HOUR, 10000));
        SegmentGenerator otherGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        DataSegment otherSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("2").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        IndexSpec otherEncodings = IndexSpec.builder().withStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(16), Byte.valueOf((byte)1))).withLongEncoding(CompressionFactory.LongEncodingStrategy.AUTO).build();
        INDEX_OTHER_ENCODINGS = (QueryableIndex)CLOSER.register((Closeable)otherGenerator.generate(otherSegment, schemaInfo, otherEncodings, Granularities.HOUR, 10000));
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        CLOSER.close();
    }

    @Parameterized.Parameters(name="expression = {0}, encoding = {1}")
    public static Iterable<?> constructorFeeder() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String encoding : new String[]{"default", "front-coded-and-auto-longs"}) {
            for (String expression : EXPRESSIONS) {
                params.add(new Object[]{expression, encoding});
            }
        }
        return params;
    }

    public ExpressionVectorSelectorsTest(String expression, String encoding) {
        this.expression = expression;
        this.encoding = encoding;
        this.queryableIndexToUse = "front-coded-and-auto-longs".equals(encoding) ? INDEX_OTHER_ENCODINGS : INDEX;
    }

    @Before
    public void setup() {
        Expr parsed = Parser.parse((String)this.expression, (ExprMacroTable)ExprMacroTable.nil());
        this.outputType = parsed.getOutputType((Expr.InputBindingInspector)new DeprecatedQueryableIndexColumnSelector(this.queryableIndexToUse));
        if (this.outputType == null) {
            this.outputType = ExpressionType.STRING;
        }
    }

    @After
    public void teardown() throws IOException {
        this.perTestCloser.close();
    }

    @Test
    public void sanityTestVectorizedExpressionSelector() {
        ExpressionVectorSelectorsTest.sanityTestVectorizedExpressionSelectors(this.expression, this.outputType, this.queryableIndexToUse, this.perTestCloser, 10000);
    }

    public static void sanityTestVectorizedExpressionSelectors(String expression, @Nullable ExpressionType outputType, QueryableIndex index, Closer closer, int rowsPerSegment) {
        SingleValueDimensionVectorSelector selector;
        ArrayList<Object> results = new ArrayList<Object>(rowsPerSegment);
        VirtualColumns virtualColumns = VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v", expression, ExpressionType.toColumnType((ExpressionType)outputType), TestExprMacroTable.INSTANCE)));
        QueryableIndexStorageAdapter storageAdapter = new QueryableIndexStorageAdapter(index);
        VectorCursor cursor = storageAdapter.makeVectorCursor(null, index.getDataInterval(), virtualColumns, false, 512, null);
        ColumnCapabilities capabilities = virtualColumns.getColumnCapabilities((ColumnInspector)storageAdapter, "v");
        int rowCount = 0;
        if (capabilities.isDictionaryEncoded().isTrue()) {
            selector = cursor.getColumnSelectorFactory().makeSingleValueDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"v"));
            while (!cursor.isDone()) {
                int[] row = selector.getRowVector();
                int i = 0;
                while (i < selector.getCurrentVectorSize()) {
                    results.add(selector.lookupName(row[i]));
                    ++i;
                    ++rowCount;
                }
                cursor.advance();
            }
        } else {
            selector = null;
            VectorObjectSelector objectSelector = null;
            if (outputType != null && outputType.isNumeric()) {
                selector = cursor.getColumnSelectorFactory().makeValueSelector("v");
            } else {
                objectSelector = cursor.getColumnSelectorFactory().makeObjectSelector("v");
            }
            while (!cursor.isDone()) {
                switch ((ExprType)outputType.getType()) {
                    case LONG: {
                        boolean[] nulls = selector.getNullVector();
                        long[] longs = selector.getLongVector();
                        int i = 0;
                        while (i < selector.getCurrentVectorSize()) {
                            results.add(nulls != null && nulls[i] ? null : Long.valueOf(longs[i]));
                            ++i;
                            ++rowCount;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i;
                        boolean[] nulls;
                        if ("float2".equals(expression)) {
                            nulls = selector.getNullVector();
                            float[] floats = selector.getFloatVector();
                            i = 0;
                            while (i < selector.getCurrentVectorSize()) {
                                results.add(nulls != null && nulls[i] ? null : Double.valueOf(floats[i]));
                                ++i;
                                ++rowCount;
                            }
                        } else {
                            nulls = selector.getNullVector();
                            double[] doubles = selector.getDoubleVector();
                            i = 0;
                            while (i < selector.getCurrentVectorSize()) {
                                results.add(nulls != null && nulls[i] ? null : Double.valueOf(doubles[i]));
                                ++i;
                                ++rowCount;
                            }
                        }
                        break;
                    }
                    case STRING: {
                        Object[] objects = objectSelector.getObjectVector();
                        int i = 0;
                        while (i < objectSelector.getCurrentVectorSize()) {
                            results.add(objects[i]);
                            ++i;
                            ++rowCount;
                        }
                        break;
                    }
                }
                cursor.advance();
            }
        }
        closer.register((Closeable)cursor);
        Sequence cursors = new QueryableIndexStorageAdapter(index).makeCursors(null, index.getDataInterval(), virtualColumns, Granularities.ALL, false, null);
        int rowCountCursor = (Integer)cursors.map(nonVectorized -> {
            ColumnValueSelector nonSelector = nonVectorized.getColumnSelectorFactory().makeColumnValueSelector("v");
            int rows = 0;
            while (!nonVectorized.isDone()) {
                Assert.assertEquals((String)("Failed at row " + rows), (Object)nonSelector.getObject(), results.get(rows));
                ++rows;
                nonVectorized.advance();
            }
            return rows;
        }).accumulate((Object)0, (acc, in) -> acc + in);
        Assert.assertTrue((rowCountCursor > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)rowCountCursor, (long)rowCount);
    }
}

