/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.VersionedIntervalTimelineTestBase;
import org.apache.druid.timeline.partition.IntegerPartitionChunk;
import org.apache.druid.timeline.partition.OvershadowableInteger;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionedIntervalTimelineTest
extends VersionedIntervalTimelineTestBase {
    @Before
    public void setUp() {
        this.timeline = VersionedIntervalTimelineTest.makeStringIntegerTimeline();
    }

    @Test
    public void testGetAllObjects() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-02/2011-01-05", "2", (Integer)1);
        ImmutableList allObjects = ImmutableList.copyOf((Iterable)VersionedIntervalTimeline.getAllObjects((List)this.timeline.lookup(Intervals.of((String)"2011-01-02T02/2011-01-04"))));
        Assert.assertEquals((Object)ImmutableList.of((Object)new OvershadowableInteger("2", 0, 1)), (Object)allObjects);
    }

    @Test
    public void testFindChunkWithOverlap() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-02/2011-01-05", "2", (Integer)1);
        VersionedIntervalTimelineTest.assertSingleElementChunks(VersionedIntervalTimelineTest.makeSingle("1", 1), (PartitionChunk<OvershadowableInteger>)this.timeline.findChunk(Intervals.of((String)"2011-01-02T02/2011-01-04"), (Object)"1", 0));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOverlapSameVersionThrowException() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-15", "1", (Integer)3);
    }

    @Test
    public void testOverlapSameVersionIsOkay() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)4);
        VersionedIntervalTimelineTest.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-10", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-10")));
    }

    @Test
    public void testOverlapSecondBetween() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstBetween() {
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstBefore() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapFirstAfter() {
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapSecondBefore() {
        this.add("2011-01-05/2011-01-15", "1", (Integer)3);
        this.add("2011-01-01/2011-01-10", "2", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 1), this.createExpected("2011-01-10/2011-01-15", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapSecondAfter() {
        this.add("2011-01-01/2011-01-10", "2", (Integer)3);
        this.add("2011-01-05/2011-01-15", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 3), this.createExpected("2011-01-10/2011-01-15", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapFirstLarger() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)2);
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 2), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondLarger() {
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-20", "1", (Integer)2);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 2), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondPartialAlign() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        this.add("2011-01-01/2011-01-15", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstPartialAlign() {
        this.add("2011-01-01/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAscending() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-20", "2", (Integer)2);
        this.add("2011-01-03/2011-01-06", "3", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapDescending() {
        this.add("2011-01-03/2011-01-06", "3", (Integer)3);
        this.add("2011-01-05/2011-01-20", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapMixed() {
        this.add("2011-01-05/2011-01-20", "2", (Integer)2);
        this.add("2011-01-03/2011-01-06", "3", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapContainedAscending() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-02/2011-01-10", "2", (Integer)2);
        this.add("2011-01-02/2011-01-06", "3", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-02", "1", 1), this.createExpected("2011-01-02/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapContainedDescending() {
        this.add("2011-01-02/2011-01-06", "3", (Integer)3);
        this.add("2011-01-02/2011-01-10", "2", (Integer)2);
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-02", "1", 1), this.createExpected("2011-01-02/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapContainedmixed() {
        this.add("2011-01-02/2011-01-10", "2", (Integer)2);
        this.add("2011-01-02/2011-01-06", "3", (Integer)3);
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-02", "1", 1), this.createExpected("2011-01-02/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondContained() {
        this.add("2011-01-01/2011-01-07", "1", (Integer)1);
        this.add("2011-01-07/2011-01-15", "1", (Integer)2);
        this.add("2011-01-15/2011-01-20", "1", (Integer)3);
        this.add("2011-01-10/2011-01-13", "2", (Integer)4);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-07", "1", 1), this.createExpected("2011-01-07/2011-01-10", "1", 2), this.createExpected("2011-01-10/2011-01-13", "2", 4), this.createExpected("2011-01-13/2011-01-15", "1", 2), this.createExpected("2011-01-15/2011-01-20", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstContained() {
        this.add("2011-01-10/2011-01-13", "2", (Integer)4);
        this.add("2011-01-01/2011-01-07", "1", (Integer)1);
        this.add("2011-01-07/2011-01-15", "1", (Integer)2);
        this.add("2011-01-15/2011-01-20", "1", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-07", "1", 1), this.createExpected("2011-01-07/2011-01-10", "1", 2), this.createExpected("2011-01-10/2011-01-13", "2", 4), this.createExpected("2011-01-13/2011-01-15", "1", 2), this.createExpected("2011-01-15/2011-01-20", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondContainsFirst() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)2);
        this.add("2011-01-10/2011-01-20", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstContainsSecond() {
        this.add("2011-01-10/2011-01-20", "2", (Integer)3);
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)2);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapLayeredAscending() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-15", "2", (Integer)2);
        this.add("2011-01-15/2011-01-25", "3", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-25", "3", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-25")));
    }

    @Test
    public void testOverlapLayeredDescending() {
        this.add("2011-01-15/2011-01-25", "3", (Integer)3);
        this.add("2011-01-05/2011-01-15", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-25", "3", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-25")));
    }

    @Test
    public void testOverlapV1Large() {
        this.add("2011-01-01/2011-01-15", "1", (Integer)1);
        this.add("2011-01-03/2011-01-05", "2", (Integer)2);
        this.add("2011-01-13/2011-01-20", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-13", "1", 1), this.createExpected("2011-01-13/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV2Large() {
        this.add("2011-01-01/2011-01-15", "2", (Integer)1);
        this.add("2011-01-03/2011-01-05", "1", (Integer)2);
        this.add("2011-01-13/2011-01-20", "1", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-15", "2", 1), this.createExpected("2011-01-15/2011-01-20", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1LargeIsAfter() {
        this.add("2011-01-03/2011-01-20", "1", (Integer)1);
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-13/2011-01-17", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-13", "1", 1), this.createExpected("2011-01-13/2011-01-17", "2", 3), this.createExpected("2011-01-17/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1SecondLargeIsAfter() {
        this.add("2011-01-13/2011-01-17", "2", (Integer)3);
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-03/2011-01-20", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-13", "1", 1), this.createExpected("2011-01-13/2011-01-17", "2", 3), this.createExpected("2011-01-17/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1FirstBetween() {
        this.add("2011-01-03/2011-01-17", "1", (Integer)1);
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-15/2011-01-20", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-15", "1", 1), this.createExpected("2011-01-15/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1SecondBetween() {
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-15/2011-01-20", "2", (Integer)3);
        this.add("2011-01-03/2011-01-17", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-15", "1", 1), this.createExpected("2011-01-15/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapLargeUnderlyingWithSmallDayAlignedOverlays() {
        this.add("2011-01-01/2011-01-05", "1", (Integer)1);
        this.add("2011-01-03/2011-01-04", "2", (Integer)2);
        this.add("2011-01-04/2011-01-05", "3", (Integer)3);
        this.add("2011-01-05/2011-01-06", "4", (Integer)4);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-04", "2", 2), this.createExpected("2011-01-04/2011-01-05", "3", 3), this.createExpected("2011-01-05/2011-01-06", "4", 4)), this.timeline.lookup(Intervals.ETERNITY));
    }

    @Test
    public void testOverlapCausesNullEntries() {
        this.add("2011-01-01T12/2011-01-02", "3", (Integer)3);
        this.add("2011-01-02/3011-01-03", "1", (Integer)1);
        this.add("2011-01-01/2011-01-02", "2", (Integer)2);
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-01T12", "2", 2), this.createExpected("2011-01-01T12/2011-01-02", "3", 3), this.createExpected("2011-01-02/3011-01-03", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/3011-01-03")));
    }

    @Test
    public void testOverlapOvershadowedThirdContains() {
        this.add("2011-01-03/2011-01-06", "1", (Integer)1);
        this.add("2011-01-09/2011-01-12", "1", (Integer)2);
        this.add("2011-01-02/2011-01-08", "2", (Integer)3);
        this.add("2011-01-10/2011-01-16", "2", (Integer)4);
        this.add("2011-01-01/2011-01-20", "3", (Integer)5);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-01-02/2011-01-08", "2", 3), this.createExpected("2011-01-10/2011-01-16", "2", 4), this.createExpected("2011-01-03/2011-01-06", "1", 1), this.createExpected("2011-01-09/2011-01-12", "1", 2)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOverlapOvershadowedAligned() {
        this.add("2011-01-01/2011-01-05", "2", (Integer)1);
        this.add("2011-01-05/2011-01-10", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "1", (Integer)3);
        this.add("2011-01-01/2011-01-10", "3", (Integer)4);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-01-01/2011-01-05", "2", 1), this.createExpected("2011-01-05/2011-01-10", "2", 2), this.createExpected("2011-01-01/2011-01-10", "1", 3)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOverlapOvershadowedSomeComplexOverlapsCantThinkOfBetterName() {
        this.add("2011-01-01/2011-01-05", "2", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.add("2011-01-03/2011-01-12", "1", (Integer)3);
        this.add("2011-01-01/2011-01-10", "3", (Integer)4);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-01-03/2011-01-12", "1", 3), this.createExpected("2011-01-01/2011-01-05", "2", 1)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOverlapAndRemove() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-15"), (Object)"2", VersionedIntervalTimelineTest.makeSingle("2", 2));
        VersionedIntervalTimelineTest.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAndRemove2() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "2", (Integer)2);
        this.add("2011-01-20/2011-01-30", "3", (Integer)4);
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-20"), (Object)"2", VersionedIntervalTimelineTest.makeSingle("2", 2));
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-20", "1", 1), this.createExpected("2011-01-20/2011-01-30", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-30")));
    }

    @Test
    public void testOverlapAndRemove3() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-02/2011-01-03", "2", (Integer)2);
        this.add("2011-01-10/2011-01-14", "2", (Integer)3);
        this.timeline.remove(Intervals.of((String)"2011-01-02/2011-01-03"), (Object)"2", VersionedIntervalTimelineTest.makeSingle("2", 2));
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-14"), (Object)"2", VersionedIntervalTimelineTest.makeSingle("2", 3));
        VersionedIntervalTimelineTest.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAndRemove4() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.add("2011-01-15/2011-01-20", "2", (Integer)3);
        this.timeline.remove(Intervals.of((String)"2011-01-15/2011-01-20"), (Object)"2", VersionedIntervalTimelineTest.makeSingle("2", 3));
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "1", 1), this.createExpected("2011-01-10/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAndRemove5() {
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-15"), (Object)"2", VersionedIntervalTimelineTest.makeSingle("2", 2));
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testRemoveNothingBacking() {
        this.add("2011-01-01/2011-01-05", "1", (Integer)1);
        this.add("2011-01-05/2011-01-10", "2", (Integer)2);
        this.add("2011-01-10/2011-01-15", "3", (Integer)3);
        this.add("2011-01-15/2011-01-20", "4", (Integer)4);
        this.timeline.remove(Intervals.of((String)"2011-01-15/2011-01-20"), (Object)"4", VersionedIntervalTimelineTest.makeSingle("4", 4));
        VersionedIntervalTimelineTest.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-15", "3", 3)), this.timeline.lookup(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.MAX)));
    }

    @Test
    public void testOvershadowingHigherVersionWins1() {
        this.add("2011-04-01/2011-04-03", "1", (Integer)2);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-06/2011-04-09", "1", (Integer)4);
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(this.createExpected("2011-04-01/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "1", 4)), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionWins2() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-03", "2", (Integer)2);
        this.add("2011-04-03/2011-04-06", "2", (Integer)3);
        this.add("2011-04-06/2011-04-09", "2", (Integer)4);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(this.createExpected("2011-04-01/2011-04-09", "1", 1)), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionWins3() {
        this.add("2011-04-01/2011-04-03", "1", (Integer)2);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-09/2011-04-12", "1", (Integer)4);
        this.add("2011-04-01/2011-04-12", "2", (Integer)1);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-09/2011-04-12", "1", 4)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionWins4() {
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-06/2011-04-09", "1", (Integer)4);
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "1", 4)), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower1() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-03/2011-04-06", "2", (Integer)3);
        this.add("2011-04-06/2011-04-09", "2", (Integer)4);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower2() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-03", "2", (Integer)2);
        this.add("2011-04-06/2011-04-09", "2", (Integer)4);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower3() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-03", "2", (Integer)2);
        this.add("2011-04-03/2011-04-06", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower4() {
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        this.add("2011-04-01/2011-04-03", "3", (Integer)2);
        this.add("2011-04-03/2011-04-06", "4", (Integer)3);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        VersionedIntervalTimelineTest.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableSet.of(this.createExpected("2011-04-03/2011-04-06", "1", 3)), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower5() {
        this.add("2011-04-01/2011-04-12", "2", (Integer)1);
        this.add("2011-04-01/2011-04-03", "3", (Integer)2);
        this.add("2011-04-06/2011-04-09", "4", (Integer)3);
        this.add("2011-04-09/2011-04-12", "1", (Integer)3);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-09/2011-04-12", "1", 3)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingSameIntervalHighVersionWins() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-09", "9", (Integer)2);
        this.add("2011-04-01/2011-04-09", "2", (Integer)3);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-09", "2", 3), this.createExpected("2011-04-01/2011-04-09", "1", 1)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowingSameIntervalSameVersionAllKept() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-09", "9", (Integer)2);
        this.add("2011-04-01/2011-04-09", "2", (Integer)3);
        this.add("2011-04-01/2011-04-09", "9", (Integer)4);
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-09", "2", 3), this.createExpected("2011-04-01/2011-04-09", "1", 1)}), this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testNotFoundReturnsEmpty() {
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        Assert.assertTrue((boolean)this.timeline.lookup(Intervals.of((String)"1970/1980")).isEmpty());
    }

    @Test
    public void testRemoveIncompleteKeepsComplete() {
        this.add("2011-04-01/2011-04-02", "1", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("1", 0, 77)));
        this.add("2011-04-01/2011-04-02", "1", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make((Integer)1, null, (int)1, (Overshadowable)new OvershadowableInteger("1", 1, 88)));
        this.add("2011-04-01/2011-04-02", "2", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("2", 0, 99)));
        VersionedIntervalTimelineTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-04-01/2011-04-02", "1", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("1", 0, 77)), IntegerPartitionChunk.make((Integer)1, null, (int)1, (Overshadowable)new OvershadowableInteger("1", 1, 88))))), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-02")));
        this.add("2011-04-01/2011-04-02", "3", (PartitionChunk<OvershadowableInteger>)IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("3", 0, 110)));
        VersionedIntervalTimelineTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-04-01/2011-04-02", "1", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("1", 0, 77)), IntegerPartitionChunk.make((Integer)1, null, (int)1, (Overshadowable)new OvershadowableInteger("1", 1, 88))))), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-02")));
        VersionedIntervalTimelineTest.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-02", "2", Collections.singletonList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("2", 0, 99))))}), this.timeline.findFullyOvershadowed());
        this.checkRemove();
        VersionedIntervalTimelineTest.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<OvershadowableInteger>>>>)ImmutableList.of(this.createExpected("2011-04-01/2011-04-02", "1", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Overshadowable)new OvershadowableInteger("1", 0, 77)), IntegerPartitionChunk.make((Integer)1, null, (int)1, (Overshadowable)new OvershadowableInteger("1", 1, 88))))), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-02")));
    }

    @Test
    public void testIsOvershadowedWithNonOverlappingSegmentsInTimeline() {
        this.add("2011-04-05/2011-04-07", "1", VersionedIntervalTimelineTest.makeSingle("1", 1));
        this.add("2011-04-07/2011-04-09", "1", VersionedIntervalTimelineTest.makeSingle("1", 1));
        this.add("2011-04-15/2011-04-17", "1", VersionedIntervalTimelineTest.makeSingle("1", 1));
        this.add("2011-04-17/2011-04-19", "1", VersionedIntervalTimelineTest.makeSingle("1", 1));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-03"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-05"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-06"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-07"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"1", (Overshadowable)new OvershadowableInteger("1", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"1", (Overshadowable)new OvershadowableInteger("1", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"1", (Overshadowable)new OvershadowableInteger("1", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"1", (Overshadowable)new OvershadowableInteger("1", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"2", (Overshadowable)new OvershadowableInteger("2", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"2", (Overshadowable)new OvershadowableInteger("2", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"2", (Overshadowable)new OvershadowableInteger("2", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"2", (Overshadowable)new OvershadowableInteger("2", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-07"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-08/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-08/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-08/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-15"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-17"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-19"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-16"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-17"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-18"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-19"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-20"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-19/2011-04-20"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-21/2011-04-22"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
    }

    @Test
    public void testIsOvershadowedWithOverlappingSegmentsInTimeline() {
        this.add("2011-04-05/2011-04-09", "11", VersionedIntervalTimelineTest.makeSingle("11", 1));
        this.add("2011-04-07/2011-04-11", "12", VersionedIntervalTimelineTest.makeSingle("12", 1));
        this.add("2011-04-15/2011-04-19", "12", VersionedIntervalTimelineTest.makeSingle("12", 1));
        this.add("2011-04-17/2011-04-21", "11", VersionedIntervalTimelineTest.makeSingle("11", 1));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-03"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-05"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-06"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-07"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-11"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-30"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-11"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"12", (Overshadowable)new OvershadowableInteger("12", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"12", (Overshadowable)new OvershadowableInteger("12", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"12", (Overshadowable)new OvershadowableInteger("12", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"12", (Overshadowable)new OvershadowableInteger("12", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-10"), (Object)"12", (Overshadowable)new OvershadowableInteger("12", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-11"), (Object)"12", (Overshadowable)new OvershadowableInteger("12", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"13", (Overshadowable)new OvershadowableInteger("13", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"13", (Overshadowable)new OvershadowableInteger("13", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"13", (Overshadowable)new OvershadowableInteger("13", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"13", (Overshadowable)new OvershadowableInteger("13", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-10"), (Object)"13", (Overshadowable)new OvershadowableInteger("13", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-11"), (Object)"13", (Overshadowable)new OvershadowableInteger("13", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-12"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-15"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-16"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-17"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-18"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-19"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-20"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-21"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-22"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-07"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-08"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-09"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-10"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-11"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-12"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-15"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-16"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-17"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-18"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-19"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-20"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-21"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-22"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-15"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-16"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-17"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-18"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-19"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-20"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-21"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-22"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-21"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-21/2011-04-22"), (Object)"0", (Overshadowable)new OvershadowableInteger("0", 0, 1)));
    }

    @Test
    public void testOvershadowedByReference() {
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 1, 0, 3, 1, 2));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 1, 0, 3, 1, 2));
        Assert.assertEquals((Object)ImmutableSet.of(this.makeTimelineObjectHolder("2019-01-01/2019-01-02", "0", (List<PartitionChunk<OvershadowableInteger>>)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("0", 0, 0), VersionedIntervalTimelineTest.makeNumbered("0", 1, 0), VersionedIntervalTimelineTest.makeNumbered("0", 2, 0)))), (Object)this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowedByReferenceChain() {
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 1, 0, 3, 1, 2));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 1, 0, 3, 1, 2));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 2, 2, 0, 3, 2, 2));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 3, 2, 0, 3, 2, 2));
        Assert.assertEquals((Object)ImmutableSet.of(this.makeTimelineObjectHolder("2019-01-01/2019-01-02", "0", (List<PartitionChunk<OvershadowableInteger>>)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("0", 0, 0), VersionedIntervalTimelineTest.makeNumbered("0", 1, 0), VersionedIntervalTimelineTest.makeNumbered("0", 2, 0), VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 1, 0, 3, 1, 2), VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 1, 0, 3, 1, 2)))), (Object)this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowedByReferenceAndThenVersion() {
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 1, 0, 3, 1, 2));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 1, 0, 3, 1, 2));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 0, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 1, 0));
        Assert.assertEquals((Object)ImmutableSet.of(this.makeTimelineObjectHolder("2019-01-01/2019-01-02", "0", (List<PartitionChunk<OvershadowableInteger>>)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("0", 0, 0), VersionedIntervalTimelineTest.makeNumbered("0", 1, 0), VersionedIntervalTimelineTest.makeNumbered("0", 2, 0), VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 1, 0, 3, 1, 2), VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 1, 0, 3, 1, 2)))), (Object)this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testOvershadowedByVersionAndThenReference() {
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 0, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 1, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 0, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 1, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3));
        Assert.assertEquals((Object)ImmutableSet.of(this.makeTimelineObjectHolder("2019-01-01/2019-01-02", "0", (List<PartitionChunk<OvershadowableInteger>>)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("0", 0, 0), VersionedIntervalTimelineTest.makeNumbered("0", 1, 0), VersionedIntervalTimelineTest.makeNumbered("0", 2, 0))), this.makeTimelineObjectHolder("2019-01-01/2019-01-02", "1", (List<PartitionChunk<OvershadowableInteger>>)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("1", 0, 0), VersionedIntervalTimelineTest.makeNumbered("1", 1, 0)))), (Object)this.timeline.findFullyOvershadowed());
    }

    @Test
    public void testFallbackOnMissingSegment() {
        Interval interval = Intervals.of((String)"2019-01-01/2019-01-02");
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add(interval, "1", VersionedIntervalTimelineTest.makeNumbered("1", 0, 0));
        this.add(interval, "1", VersionedIntervalTimelineTest.makeNumbered("1", 1, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 0, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 1, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3));
        this.timeline.remove(interval, (Object)"1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3));
        List holders = this.timeline.lookup(interval);
        Assert.assertEquals((Object)ImmutableList.of((Object)new TimelineObjectHolder(interval, (Object)"1", new PartitionHolder((List)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("1", 0, 0), VersionedIntervalTimelineTest.makeNumbered("1", 1, 0))))), (Object)holders);
    }

    @Test
    public void testAddSameChunkToFullAtomicUpdateGroup() {
        Interval interval = Intervals.of((String)"2019-01-01/2019-01-02");
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 0, 0, 1, 1, 1));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 1));
        Set overshadowed = this.timeline.findFullyOvershadowed();
        Assert.assertEquals((Object)ImmutableSet.of((Object)new TimelineObjectHolder(interval, (Object)"0", new PartitionHolder((List)ImmutableList.of(VersionedIntervalTimelineTest.makeNumbered("0", 0, 1))))), (Object)overshadowed);
    }

    @Test
    public void testOvershadowMultipleStandbyAtomicUpdateGroup() {
        Interval interval = Intervals.of((String)"2019-01-01/2019-01-02");
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 0, 0, 1, 1, 2));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 0, 1, 2, 2));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 2, 0, 0, 1, 3, 2));
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 3, 1, 0, 1, 3, 2));
        Set overshadowed = this.timeline.findFullyOvershadowed();
        Assert.assertEquals((Object)ImmutableSet.of((Object)new TimelineObjectHolder(interval, (Object)"0", new PartitionHolder((List)ImmutableList.of(VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 0, 0, 1, 1, 2), VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 0, 1, 2, 2))))), (Object)overshadowed);
    }

    @Test
    public void testIsOvershadowedForOverwritingSegments() {
        Interval interval = Intervals.of((String)"2019-01-01/2019-01-02");
        this.add(interval, "0", VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 0, 0, 5, 10, 10, 1));
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumbered("0", i + 5, 0).getObject()));
        }
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumbered("0", 4, 0).getObject()));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumbered("0", 11, 0).getObject()));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 5, 6, 5, 2).getObject()));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 7, 8, 5, 2).getObject()));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 8, 10, 5, 2).getObject()));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 5, 10, 12, 2).getObject()));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(interval, (Object)"0", (Overshadowable)VersionedIntervalTimelineTest.makeNumberedOverwriting("0", 1, 0, 4, 15, 12, 2).getObject()));
    }

    @Test
    public void testIterateAllObjects() {
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)3);
        Collection overshadowableIntegers = this.timeline.iterateAllObjects();
        Assert.assertEquals((long)2L, (long)overshadowableIntegers.size());
        Assert.assertEquals((long)2L, (long)Lists.newArrayList(overshadowableIntegers.iterator()).size());
    }

    @Test
    public void testFindNonOvershadowedObjectsInIntervalWithOnlyCompletePartitionsReturningValidResult() {
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-03/2019-01-04", "0", VersionedIntervalTimelineTest.makeNumbered("2", 0, 3, 0));
        this.add("2019-01-03/2019-01-04", "0", VersionedIntervalTimelineTest.makeNumbered("2", 1, 3, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 0, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 1, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 0, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 1, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 0, 1, 0, 2, 1, 3).getObject(), (Object)VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 1, 1, 0, 2, 1, 3).getObject(), (Object)VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3).getObject(), (Object)VersionedIntervalTimelineTest.makeNumbered("0", 0, 0).getObject(), (Object)VersionedIntervalTimelineTest.makeNumbered("0", 1, 0).getObject()), (Object)this.timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2019-01-01/2019-01-04"), Partitions.ONLY_COMPLETE));
    }

    @Test
    public void testFindNonOvershadowedObjectsInIntervalWithIncompleteOkReturningValidResult() {
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-01/2019-01-02", "0", VersionedIntervalTimelineTest.makeNumbered("0", 2, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 0, 0));
        this.add("2019-01-02/2019-01-03", "0", VersionedIntervalTimelineTest.makeNumbered("0", 1, 0));
        this.add("2019-01-03/2019-01-04", "0", VersionedIntervalTimelineTest.makeNumbered("2", 0, 3, 0));
        this.add("2019-01-03/2019-01-04", "0", VersionedIntervalTimelineTest.makeNumbered("2", 1, 3, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 0, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumbered("1", 1, 0));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 0, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 1, 1, 0, 2, 1, 3));
        this.add("2019-01-01/2019-01-02", "1", VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 0, 1, 0, 2, 1, 3).getObject(), (Object)VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 1, 1, 0, 2, 1, 3).getObject(), (Object)VersionedIntervalTimelineTest.makeNumberedOverwriting("1", 2, 1, 0, 2, 1, 3).getObject(), (Object)VersionedIntervalTimelineTest.makeNumbered("0", 0, 0).getObject(), (Object)VersionedIntervalTimelineTest.makeNumbered("0", 1, 0).getObject(), (Object)VersionedIntervalTimelineTest.makeNumbered("2", 0, 3, 0).getObject(), (Object[])new OvershadowableInteger[]{(OvershadowableInteger)VersionedIntervalTimelineTest.makeNumbered("2", 1, 3, 0).getObject()}), (Object)this.timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2019-01-01/2019-01-04"), Partitions.INCOMPLETE_OK));
    }
}

