/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.junit.Assert;
import org.junit.Test;

public class DimensionRangeShardSpecTest {
    private final List<String> dimensions = new ArrayList<String>();

    @Test
    public void testShardSpecLookup() {
        this.setDimensions("dim1", "dim2");
        ImmutableList shardSpecs = ImmutableList.of((Object)new DimensionRangeShardSpec(this.dimensions, null, StringTuple.create((String[])new String[]{"India", "Delhi"}), 1, Integer.valueOf(1)), (Object)new DimensionRangeShardSpec(this.dimensions, StringTuple.create((String[])new String[]{"India", "Delhi"}), StringTuple.create((String[])new String[]{"Spain", "Valencia"}), 2, Integer.valueOf(1)), (Object)new DimensionRangeShardSpec(this.dimensions, StringTuple.create((String[])new String[]{"Spain", "Valencia"}), null, 3, Integer.valueOf(1)));
        ShardSpecLookup lookup = ((ShardSpec)shardSpecs.get(0)).getLookup((List)shardSpecs);
        long currentTime = DateTimes.nowUtc().getMillis();
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, this.createRow("France", "Paris")));
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, this.createRow("India", null)));
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, this.createRow(null, null)));
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, this.createRow("India", "Delhi")));
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, this.createRow("India", "Kolkata")));
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, this.createRow("Spain", null)));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, this.createRow("Spain", "Valencia")));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, this.createRow("United Kingdom", "London")));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, this.createRow("United Kingdom", null)));
    }

    @Test
    public void testShardSpecLookupWithNull() {
        this.setDimensions("dim1", "dim2");
        DimensionRangeShardSpec shard0 = new DimensionRangeShardSpec(this.dimensions, null, StringTuple.create((String[])new String[]{"India", null}), 1, Integer.valueOf(1));
        DimensionRangeShardSpec shard1 = new DimensionRangeShardSpec(this.dimensions, StringTuple.create((String[])new String[]{"India", null}), StringTuple.create((String[])new String[]{"Spain", "Valencia"}), 10, Integer.valueOf(1));
        DimensionRangeShardSpec shard2 = new DimensionRangeShardSpec(this.dimensions, StringTuple.create((String[])new String[]{"Spain", "Valencia"}), StringTuple.create((String[])new String[]{"Tokyo", null}), 10, Integer.valueOf(1));
        DimensionRangeShardSpec shard3 = new DimensionRangeShardSpec(this.dimensions, StringTuple.create((String[])new String[]{"Tokyo", null}), null, 100, Integer.valueOf(1));
        ShardSpecLookup lookup = shard0.getLookup(Arrays.asList(shard0, shard1, shard2, shard3));
        long timestamp = System.currentTimeMillis();
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("India", "Delhi")));
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("India", "Kolkata")));
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("Japan", "Tokyo")));
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("Spain", "Barcelona")));
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("India", "Bengaluru")));
        Assert.assertEquals((Object)shard2, (Object)lookup.getShardSpec(timestamp, this.createRow("Spain", "Valencia")));
        Assert.assertEquals((Object)shard3, (Object)lookup.getShardSpec(timestamp, this.createRow("United Kingdom", "London")));
        Assert.assertEquals((Object)shard0, (Object)lookup.getShardSpec(timestamp, this.createRow(null, null)));
        Assert.assertEquals((Object)shard0, (Object)lookup.getShardSpec(timestamp, this.createRow(null, "Lyon")));
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("India", null)));
        Assert.assertEquals((Object)shard1, (Object)lookup.getShardSpec(timestamp, this.createRow("Spain", null)));
        Assert.assertEquals((Object)shard3, (Object)lookup.getShardSpec(timestamp, this.createRow("Tokyo", null)));
        Assert.assertEquals((Object)shard3, (Object)lookup.getShardSpec(timestamp, this.createRow("United Kingdom", null)));
    }

    @Test
    public void testPossibleInDomain_withNullStart() {
        this.setDimensions("planet", "country", "city");
        StringTuple start = null;
        StringTuple end = StringTuple.create((String[])new String[]{"Saturn", "Foo", "Bar"});
        TreeRangeSet universalSet = TreeRangeSet.create();
        universalSet.add(Range.all());
        DimensionRangeShardSpec shard = new DimensionRangeShardSpec(this.dimensions, start, end, 0, null);
        HashMap<String, RangeSet<String>> domain = new HashMap<String, RangeSet<String>>();
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Mars"))), this.getUnion(this.getRangeSet(Range.singleton((Comparable)((Object)"Zoo"))), this.getRangeSet(Range.singleton((Comparable)((Object)"Zuu")))), this.getUnion(this.getRangeSet(Range.singleton((Comparable)((Object)"Blah"))), this.getRangeSet(Range.singleton((Comparable)((Object)"Random")))));
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Saturn"))), (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Saturn"))), this.getRangeSet(Range.singleton((Comparable)((Object)"Zoo"))), (RangeSet<String>)universalSet);
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Xeon"))), (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
    }

    @Test
    public void testPossibleInDomain_withNullValues() {
        this.setDimensions("planet", "country", "city");
        StringTuple start = StringTuple.create((String[])new String[]{"Earth", "India", "Delhi"});
        StringTuple end = StringTuple.create((String[])new String[]{"Krypton", null, "Kryptonopolis"});
        TreeRangeSet universalSet = TreeRangeSet.create();
        universalSet.add(Range.all());
        DimensionRangeShardSpec shard = new DimensionRangeShardSpec(this.dimensions, start, end, 0, null);
        HashMap<String, RangeSet<String>> domain = new HashMap<String, RangeSet<String>>();
        this.populateDomain(domain, (RangeSet<String>)universalSet, (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Earth"))), (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getUnion(this.getRangeSet(Range.lessThan((Comparable)((Object)"Earth"))), this.getRangeSet(Range.greaterThan((Comparable)((Object)"Krypton")))), (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, (RangeSet<String>)universalSet, this.getRangeSet(Range.lessThan((Comparable)((Object)"France"))), (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Jupiter"))), this.getRangeSet(Range.singleton((Comparable)((Object)"Foo"))), this.getRangeSet(Range.singleton((Comparable)((Object)"Bar"))));
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Krypton"))), this.getRangeSet(Range.atMost((Comparable)((Object)"France"))), (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
    }

    @Test
    public void testPossibleInDomain_nonNullValues_acceptanceScenarios() {
        this.setDimensions("planet", "country", "city");
        StringTuple start = StringTuple.create((String[])new String[]{"Earth", "France", "Paris"});
        StringTuple end = StringTuple.create((String[])new String[]{"Earth", "USA", "New York"});
        TreeRangeSet universalSet = TreeRangeSet.create();
        universalSet.add(Range.all());
        DimensionRangeShardSpec shard = new DimensionRangeShardSpec(this.dimensions, start, end, 0, null);
        HashMap<String, RangeSet<String>> domain = new HashMap<String, RangeSet<String>>();
        this.populateDomain(domain, (RangeSet<String>)universalSet, (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Earth"))), (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, (RangeSet<String>)universalSet, this.getRangeSet(Range.atLeast((Comparable)((Object)"USA"))), this.getRangeSet(Range.singleton((Comparable)((Object)"New York"))));
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, (RangeSet<String>)universalSet, this.getRangeSet(Range.atMost((Comparable)((Object)"France"))), this.getRangeSet(Range.greaterThan((Comparable)((Object)"Paris"))));
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Earth"))), this.getRangeSet(Range.singleton((Comparable)((Object)"India"))), this.getRangeSet(Range.greaterThan((Comparable)((Object)"New York"))));
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
    }

    @Test
    public void testPossibleInDomain_nonNullValues_pruningScenarios() {
        this.setDimensions("planet", "country", "city");
        StringTuple start = StringTuple.create((String[])new String[]{"Earth", "France", "Paris"});
        StringTuple end = StringTuple.create((String[])new String[]{"Earth", "USA", "New York"});
        TreeRangeSet universalSet = TreeRangeSet.create();
        universalSet.add(Range.all());
        DimensionRangeShardSpec shard = new DimensionRangeShardSpec(this.dimensions, start, end, 0, null);
        HashMap<String, RangeSet<String>> domain = new HashMap<String, RangeSet<String>>();
        this.populateDomain(domain, this.getUnion(this.getRangeSet(Range.lessThan((Comparable)((Object)"Earth"))), this.getRangeSet(Range.greaterThan((Comparable)((Object)"Earth")))), (RangeSet<String>)universalSet, (RangeSet<String>)universalSet);
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, (RangeSet<String>)universalSet, this.getRangeSet(Range.lessThan((Comparable)((Object)"France"))), (RangeSet<String>)universalSet);
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, (RangeSet<String>)universalSet, this.getRangeSet(Range.atMost((Comparable)((Object)"France"))), this.getRangeSet(Range.lessThan((Comparable)((Object)"Paris"))));
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
        this.populateDomain(domain, this.getRangeSet(Range.singleton((Comparable)((Object)"Earth"))), this.getRangeSet(Range.singleton((Comparable)((Object)"USA"))), this.getRangeSet(Range.greaterThan((Comparable)((Object)"New York"))));
        Assert.assertFalse((boolean)shard.possibleInDomain(domain));
    }

    @Test
    public void testPossibleInDomain_falsePruning() {
        this.setDimensions("planet", "country", "city");
        StringTuple start = StringTuple.create((String[])new String[]{"Earth", "France", "Paris"});
        StringTuple end = StringTuple.create((String[])new String[]{"Mars", "USA", "New York"});
        TreeRangeSet universalSet = TreeRangeSet.create();
        universalSet.add(Range.all());
        DimensionRangeShardSpec shard = new DimensionRangeShardSpec(this.dimensions, start, end, 0, null);
        HashMap<String, RangeSet<String>> domain = new HashMap<String, RangeSet<String>>();
        this.populateDomain(domain, this.getUnion(this.getRangeSet(Range.singleton((Comparable)((Object)"Earth"))), this.getRangeSet(Range.singleton((Comparable)((Object)"Mars")))), this.getUnion(this.getRangeSet(Range.greaterThan((Comparable)((Object)"USA")))), (RangeSet<String>)universalSet);
        Assert.assertTrue((boolean)shard.possibleInDomain(domain));
    }

    private RangeSet<String> getRangeSet(Range range) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(range);
        return rangeSet;
    }

    private RangeSet<String> getUnion(RangeSet<String> ... rangeSets) {
        TreeRangeSet unionSet = TreeRangeSet.create();
        for (RangeSet<String> range : rangeSets) {
            unionSet.addAll(range);
        }
        return unionSet;
    }

    private void populateDomain(Map<String, RangeSet<String>> domain, RangeSet<String> planetSet, RangeSet<String> countrySet, RangeSet<String> citySet) {
        domain.clear();
        domain.put("planet", planetSet);
        domain.put("country", countrySet);
        domain.put("city", citySet);
    }

    private void setDimensions(String ... dimensionNames) {
        this.dimensions.clear();
        this.dimensions.addAll(Arrays.asList(dimensionNames));
    }

    private InputRow createRow(String ... values) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (int i = 0; i < this.dimensions.size(); ++i) {
            valueMap.put(this.dimensions.get(i), values[i]);
        }
        return new MapBasedInputRow(DateTimes.nowUtc(), this.dimensions, valueMap);
    }
}

