/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import java.util.Objects;
import org.apache.druid.timeline.Overshadowable;

public class OvershadowableInteger
implements Overshadowable<OvershadowableInteger> {
    private final String majorVersion;
    private final int partitionNum;
    private final int val;
    private final int startRootPartitionId;
    private final int endRootPartitionId;
    private final short minorVersion;
    private final short atomicUpdateGroupSize;

    public OvershadowableInteger(int val) {
        this("", 0, val);
    }

    public OvershadowableInteger(String majorVersion, int partitionNum, int val) {
        this(majorVersion, partitionNum, val, partitionNum, partitionNum + 1, 0, 1);
    }

    public OvershadowableInteger(String majorVersion, int partitionNum, int val, int startRootPartitionId, int endRootPartitionId, int minorVersion, int atomicUpdateGroupSize) {
        this.majorVersion = majorVersion;
        this.partitionNum = partitionNum;
        this.val = val;
        this.startRootPartitionId = startRootPartitionId;
        this.endRootPartitionId = endRootPartitionId;
        this.minorVersion = (short)minorVersion;
        this.atomicUpdateGroupSize = (short)atomicUpdateGroupSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OvershadowableInteger that = (OvershadowableInteger)o;
        return this.partitionNum == that.partitionNum && this.val == that.val && this.startRootPartitionId == that.startRootPartitionId && this.endRootPartitionId == that.endRootPartitionId && this.minorVersion == that.minorVersion && this.atomicUpdateGroupSize == that.atomicUpdateGroupSize && Objects.equals(this.majorVersion, that.majorVersion);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.partitionNum, this.val, this.startRootPartitionId, this.endRootPartitionId, this.minorVersion, this.atomicUpdateGroupSize);
    }

    public String toString() {
        return "OvershadowableInteger{majorVersion='" + this.majorVersion + '\'' + ", partitionNum=" + this.partitionNum + ", val=" + this.val + ", startRootPartitionId=" + this.startRootPartitionId + ", endRootPartitionId=" + this.endRootPartitionId + ", minorVersion=" + this.minorVersion + ", atomicUpdateGroupSize=" + this.atomicUpdateGroupSize + '}';
    }

    public int getStartRootPartitionId() {
        return this.startRootPartitionId;
    }

    public int getEndRootPartitionId() {
        return this.endRootPartitionId;
    }

    public String getVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short getAtomicUpdateGroupSize() {
        return this.atomicUpdateGroupSize;
    }
}

