/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.metadata.MapStringDynamicConfigProvider;
import org.apache.druid.utils.DynamicConfigProviderUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class DynamicConfigProviderUtilsTest {

    public static class ThrowIfURLHasNotAllowedPropertiesTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        private final String DYNAMIC_CONFIG_PROVIDER = "druid.dynamic.config.provider";

        @Test
        public void testExtraConfigAndSetStringMap() {
            MapStringDynamicConfigProvider dynamicConfigProvider = new MapStringDynamicConfigProvider((Map)ImmutableMap.of((Object)"prop2", (Object)"value2"));
            ImmutableMap properties = ImmutableMap.of((Object)"prop1", (Object)"value1", (Object)"prop2", (Object)"value3", (Object)"druid.dynamic.config.provider", (Object)OBJECT_MAPPER.convertValue((Object)dynamicConfigProvider, Map.class));
            Map res = DynamicConfigProviderUtils.extraConfigAndSetStringMap((Map)properties, (String)"druid.dynamic.config.provider", (ObjectMapper)OBJECT_MAPPER);
            Assert.assertEquals((long)2L, (long)res.size());
            Assert.assertEquals((Object)"value1", res.get("prop1"));
            Assert.assertEquals((Object)"value2", res.get("prop2"));
        }

        @Test
        public void testExtraConfigAndSetObjectMap() {
            MapStringDynamicConfigProvider dynamicConfigProvider = new MapStringDynamicConfigProvider((Map)ImmutableMap.of((Object)"prop2", (Object)"value2"));
            ImmutableMap properties = ImmutableMap.of((Object)"prop1", (Object)"value1", (Object)"prop2", (Object)"value3", (Object)"druid.dynamic.config.provider", (Object)OBJECT_MAPPER.convertValue((Object)dynamicConfigProvider, Map.class));
            Map res = DynamicConfigProviderUtils.extraConfigAndSetObjectMap((Map)properties, (String)"druid.dynamic.config.provider", (ObjectMapper)OBJECT_MAPPER);
            Assert.assertEquals((long)2L, (long)res.size());
            Assert.assertEquals((Object)"value1", (Object)res.get("prop1").toString());
            Assert.assertEquals((Object)"value2", (Object)res.get("prop2").toString());
        }
    }
}

