/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.CloudObjectSplitWidget;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.utils.CollectionUtils;
import org.apache.druid.utils.Streams;

public abstract class CloudObjectInputSource
extends AbstractInputSource
implements SplittableInputSource<List<CloudObjectLocation>> {
    private final String scheme;
    private final List<URI> uris;
    private final List<URI> prefixes;
    private final List<CloudObjectLocation> objects;
    private final String objectGlob;

    public CloudObjectInputSource(String scheme, @Nullable List<URI> uris, @Nullable List<URI> prefixes, @Nullable List<CloudObjectLocation> objects, @Nullable String objectGlob) {
        this.scheme = scheme;
        this.uris = uris;
        this.prefixes = prefixes;
        this.objects = objects;
        this.objectGlob = objectGlob;
        this.illegalArgsChecker();
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<URI> getUris() {
        return this.uris;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<URI> getPrefixes() {
        return this.prefixes;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CloudObjectLocation> getObjects() {
        return this.objects;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getObjectGlob() {
        return this.objectGlob;
    }

    protected abstract InputEntity createEntity(CloudObjectLocation var1);

    protected abstract CloudObjectSplitWidget getSplitWidget();

    @Override
    public Stream<InputSplit<List<CloudObjectLocation>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            return CloudObjectInputSource.getSplitsForObjects(this.getSplitWidget(), this.getSplitHintSpecOrDefault(splitHintSpec), this.objects, this.objectGlob);
        }
        if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            return CloudObjectInputSource.getSplitsForObjects(this.getSplitWidget(), this.getSplitHintSpecOrDefault(splitHintSpec), Lists.transform(this.uris, CloudObjectLocation::new), this.objectGlob);
        }
        return CloudObjectInputSource.getSplitsForPrefixes(this.getSplitWidget(), this.getSplitHintSpecOrDefault(splitHintSpec), this.prefixes, this.objectGlob);
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return Ints.checkedCast((long)this.createSplits(inputFormat, splitHintSpec).count());
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, this.createSplits(inputFormat, null).flatMap(split -> ((List)split.get()).stream()).map(this::createEntity).iterator(), temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudObjectInputSource that = (CloudObjectInputSource)o;
        return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.uris, that.uris) && Objects.equals(this.prefixes, that.prefixes) && Objects.equals(this.objects, that.objects) && Objects.equals(this.objectGlob, that.objectGlob);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.uris, this.prefixes, this.objects, this.objectGlob);
    }

    private void illegalArgsChecker() throws IllegalArgumentException {
        if (!CollectionUtils.isNullOrEmpty(this.objects)) {
            this.throwIfIllegalArgs(!CollectionUtils.isNullOrEmpty(this.uris) || !CollectionUtils.isNullOrEmpty(this.prefixes));
        } else if (!CollectionUtils.isNullOrEmpty(this.uris)) {
            this.throwIfIllegalArgs(!CollectionUtils.isNullOrEmpty(this.prefixes));
            this.uris.forEach(uri -> CloudObjectLocation.validateUriScheme(this.scheme, uri));
        } else if (!CollectionUtils.isNullOrEmpty(this.prefixes)) {
            this.prefixes.forEach(uri -> CloudObjectLocation.validateUriScheme(this.scheme, uri));
        } else {
            this.throwIfIllegalArgs(true);
        }
    }

    private void throwIfIllegalArgs(boolean clause) throws IllegalArgumentException {
        if (clause) {
            throw new IllegalArgumentException("Exactly one of uris, prefixes or objects must be specified");
        }
    }

    private static Stream<InputSplit<List<CloudObjectLocation>>> getSplitsForPrefixes(CloudObjectSplitWidget splitWidget, SplitHintSpec splitHintSpec, List<URI> prefixes, @Nullable String objectGlob) {
        UnmodifiableIterator iterator = splitWidget.getDescriptorIteratorForPrefixes(prefixes);
        if (StringUtils.isNotBlank((String)objectGlob)) {
            PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:" + objectGlob);
            iterator = Iterators.filter(iterator, location -> m.matches(Paths.get(location.getLocation().getPath(), new String[0])));
        }
        return CloudObjectInputSource.toSplitStream(splitWidget, splitHintSpec, (Iterator<CloudObjectSplitWidget.LocationWithSize>)Iterators.filter(iterator, object -> object.getSize() != 0L));
    }

    private static Stream<InputSplit<List<CloudObjectLocation>>> getSplitsForObjects(CloudObjectSplitWidget splitWidget, SplitHintSpec splitHintSpec, List<CloudObjectLocation> objectLocations, @Nullable String objectGlob) {
        UnmodifiableIterator iterator = objectLocations.iterator();
        if (StringUtils.isNotBlank((String)objectGlob)) {
            PathMatcher m = FileSystems.getDefault().getPathMatcher("glob:" + objectGlob);
            iterator = Iterators.filter(iterator, location -> m.matches(Paths.get(location.getPath(), new String[0])));
        }
        return CloudObjectInputSource.toSplitStream(splitWidget, splitHintSpec, Iterators.transform(iterator, location -> new CloudObjectSplitWidget.LocationWithSize((CloudObjectLocation)location, -1L)));
    }

    private static Stream<InputSplit<List<CloudObjectLocation>>> toSplitStream(CloudObjectSplitWidget splitWidget, SplitHintSpec splitHintSpec, Iterator<CloudObjectSplitWidget.LocationWithSize> objectIterator) {
        return Streams.sequentialStreamFrom(splitHintSpec.split(objectIterator, o -> {
            try {
                if (o.getSize() == -1L) {
                    return new InputFileAttribute(splitWidget.getObjectSize(o.getLocation()));
                }
                return new InputFileAttribute(o.getSize());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).map(locations -> new InputSplit(locations.stream().map(CloudObjectSplitWidget.LocationWithSize::getLocation).collect(Collectors.toList())));
    }
}

