/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.TextReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.ParserUtils;

public class DelimitedValueReader
extends TextReader {
    private final boolean findColumnsFromHeader;
    private final int skipHeaderRows;
    private final Function<String, Object> multiValueFunction;
    private final DelimitedValueParser parser;
    @Nullable
    private List<String> columns;

    DelimitedValueReader(InputRowSchema inputRowSchema, InputEntity source, @Nullable String listDelimiter, @Nullable List<String> columns, boolean findColumnsFromHeader, int skipHeaderRows, DelimitedValueParser parser) {
        super(inputRowSchema, source);
        this.findColumnsFromHeader = findColumnsFromHeader;
        this.skipHeaderRows = skipHeaderRows;
        String finalListDelimeter = listDelimiter == null ? "\u0001" : listDelimiter;
        this.multiValueFunction = ParserUtils.getMultiValueFunction(finalListDelimeter, Splitter.on((String)finalListDelimeter));
        this.columns = findColumnsFromHeader ? null : columns;
        this.parser = parser;
    }

    @Override
    public List<InputRow> parseInputRows(String line) throws IOException, ParseException {
        Map<String, Object> zipped = this.parseLine(line);
        return Collections.singletonList(MapInputRowParser.parse(this.getInputRowSchema(), zipped));
    }

    @Override
    public List<Map<String, Object>> toMap(String intermediateRow) throws IOException {
        return Collections.singletonList(this.parseLine(intermediateRow));
    }

    private Map<String, Object> parseLine(String line) throws IOException {
        List<String> parsed = this.parser.parseLine(line);
        return Utils.zipMapPartial((Iterable)Preconditions.checkNotNull(this.columns, (Object)"columns"), Iterables.transform(parsed, this.multiValueFunction));
    }

    @Override
    public int getNumHeaderLinesToSkip() {
        return this.skipHeaderRows;
    }

    @Override
    public boolean needsToProcessHeaderLine() {
        return this.findColumnsFromHeader;
    }

    @Override
    public void processHeaderLine(String line) throws IOException {
        if (!this.findColumnsFromHeader) {
            throw new ISE("Don't call this if findColumnsFromHeader = false", new Object[0]);
        }
        this.columns = DelimitedValueReader.findOrCreateColumnNames(this.parser.parseLine(line));
        if (this.columns.isEmpty()) {
            throw new ISE("Empty columns", new Object[0]);
        }
    }

    static interface DelimitedValueParser {
        public List<String> parseLine(String var1) throws IOException;
    }
}

