/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.NestedDataDimensionSchema;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndex;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=StringDimensionSchema.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="string", value=StringDimensionSchema.class), @JsonSubTypes.Type(name="long", value=LongDimensionSchema.class), @JsonSubTypes.Type(name="float", value=FloatDimensionSchema.class), @JsonSubTypes.Type(name="double", value=DoubleDimensionSchema.class), @JsonSubTypes.Type(name="spatial", value=NewSpatialDimensionSchema.class), @JsonSubTypes.Type(name="json", value=NestedDataDimensionSchema.class), @JsonSubTypes.Type(name="auto", value=AutoTypeColumnSchema.class)})
public abstract class DimensionSchema {
    public static final String STRING_TYPE_NAME = "string";
    public static final String LONG_TYPE_NAME = "long";
    public static final String FLOAT_TYPE_NAME = "float";
    public static final String SPATIAL_TYPE_NAME = "spatial";
    public static final String DOUBLE_TYPE_NAME = "double";
    private static final EmittingLogger log = new EmittingLogger(DimensionSchema.class);
    private final String name;
    private final MultiValueHandling multiValueHandling;
    private final boolean createBitmapIndex;

    public static DimensionSchema getDefaultSchemaForBuiltInType(String name, TypeSignature<ValueType> type) {
        switch (type.getType()) {
            case STRING: {
                return new StringDimensionSchema(name);
            }
            case LONG: {
                return new LongDimensionSchema(name);
            }
            case FLOAT: {
                return new FloatDimensionSchema(name);
            }
            case DOUBLE: {
                return new DoubleDimensionSchema(name);
            }
        }
        return new AutoTypeColumnSchema(name);
    }

    protected DimensionSchema(String name, MultiValueHandling multiValueHandling, boolean createBitmapIndex) {
        if (Strings.isNullOrEmpty((String)name)) {
            log.warn("Null or Empty Dimension found", new Object[0]);
        }
        this.name = name;
        this.multiValueHandling = multiValueHandling == null ? MultiValueHandling.ofDefault() : multiValueHandling;
        this.createBitmapIndex = createBitmapIndex;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public MultiValueHandling getMultiValueHandling() {
        return this.multiValueHandling;
    }

    @JsonProperty(value="createBitmapIndex")
    public boolean hasBitmapIndex() {
        return this.createBitmapIndex;
    }

    @JsonIgnore
    public abstract String getTypeName();

    @JsonIgnore
    public abstract ColumnType getColumnType();

    @JsonIgnore
    public DimensionHandler getDimensionHandler() {
        return DimensionHandlerUtils.getHandlerFromCapabilities(this.name, IncrementalIndex.makeDefaultCapabilitiesFromValueType(this.getColumnType()), this.multiValueHandling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionSchema that = (DimensionSchema)o;
        return this.createBitmapIndex == that.createBitmapIndex && Objects.equals(this.name, that.name) && Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals(this.getColumnType(), that.getColumnType()) && this.multiValueHandling == that.multiValueHandling;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.multiValueHandling, this.createBitmapIndex, this.getTypeName(), this.getColumnType()});
    }

    public String toString() {
        return "DimensionSchema{name='" + this.name + '\'' + ", valueType=" + this.getColumnType() + ", typeName=" + this.getTypeName() + ", multiValueHandling=" + (Object)((Object)this.multiValueHandling) + ", createBitmapIndex=" + this.createBitmapIndex + '}';
    }

    public static enum MultiValueHandling {
        SORTED_ARRAY,
        SORTED_SET,
        ARRAY{

            @Override
            public boolean needSorting() {
                return false;
            }
        };


        public boolean needSorting() {
            return true;
        }

        @JsonValue
        public String toString() {
            return StringUtils.toUpperCase(this.name());
        }

        @JsonCreator
        public static MultiValueHandling fromString(String name) {
            return name == null ? MultiValueHandling.ofDefault() : MultiValueHandling.valueOf(StringUtils.toUpperCase(name));
        }

        public static MultiValueHandling ofDefault() {
            return SORTED_ARRAY;
        }
    }
}

