/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MapInputRowParser
implements InputRowParser<Map<String, Object>> {
    private final ParseSpec parseSpec;

    @JsonCreator
    public MapInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parseSpec = parseSpec;
    }

    @Override
    public List<InputRow> parseBatch(Map<String, Object> theMap) {
        return ImmutableList.of((Object)MapInputRowParser.parse(this.parseSpec.getTimestampSpec(), this.parseSpec.getDimensionsSpec(), theMap));
    }

    public static InputRow parse(InputRowSchema inputRowSchema, Map<String, Object> theMap) throws ParseException {
        return MapInputRowParser.parse(inputRowSchema.getTimestampSpec(), inputRowSchema.getDimensionsSpec(), theMap);
    }

    private static List<String> findDimensions(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, Map<String, Object> rawInputRow) {
        String timestampColumn = timestampSpec.getTimestampColumn();
        Set<String> exclusions = dimensionsSpec.getDimensionExclusions();
        if (dimensionsSpec.isIncludeAllDimensions() || dimensionsSpec.useSchemaDiscovery()) {
            LinkedHashSet<String> dimensions = new LinkedHashSet<String>(dimensionsSpec.getDimensionNames());
            for (String field : rawInputRow.keySet()) {
                if (timestampColumn.equals(field) || exclusions.contains(field)) continue;
                dimensions.add(field);
            }
            return new ArrayList<String>(dimensions);
        }
        if (!dimensionsSpec.getDimensionNames().isEmpty()) {
            return dimensionsSpec.getDimensionNames();
        }
        ArrayList<String> dimensions = new ArrayList<String>();
        for (String field : rawInputRow.keySet()) {
            if (timestampColumn.equals(field) || exclusions.contains(field)) continue;
            dimensions.add(field);
        }
        return dimensions;
    }

    @VisibleForTesting
    static InputRow parse(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, Map<String, Object> theMap) throws ParseException {
        DateTime timestamp;
        List<String> dimensionsToUse = MapInputRowParser.findDimensions(timestampSpec, dimensionsSpec, theMap);
        try {
            timestamp = timestampSpec.extractTimestamp(theMap);
        }
        catch (Exception e) {
            String rawMap = MapInputRowParser.rawMapToPrint(theMap);
            throw new ParseException(rawMap, (Throwable)e, "Timestamp[%s] is unparseable! Event: %s", timestampSpec.getRawTimestamp(theMap), rawMap);
        }
        if (timestamp == null) {
            String rawMap = MapInputRowParser.rawMapToPrint(theMap);
            throw new ParseException(rawMap, "Timestamp[%s] is unparseable! Event: %s", timestampSpec.getRawTimestamp(theMap), rawMap);
        }
        if (!Intervals.ETERNITY.contains((ReadableInstant)timestamp)) {
            String rawMap = MapInputRowParser.rawMapToPrint(theMap);
            throw new ParseException(rawMap, "Encountered row with timestamp[%s] that cannot be represented as a long: [%s]", timestamp, rawMap);
        }
        return new MapBasedInputRow(timestamp, dimensionsToUse, theMap);
    }

    @Nullable
    private static String rawMapToPrint(@Nullable Map<String, Object> rawMap) {
        if (rawMap == null) {
            return null;
        }
        String input = rawMap.toString();
        return input.length() < 100 ? input : input.substring(0, 100) + "...";
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @Override
    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new MapInputRowParser(parseSpec);
    }
}

