/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.allocation;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.java.util.common.ISE;

public class HeapMemoryAllocator
implements MemoryAllocator {
    private final long capacity;
    private long bytesAllocated = 0L;

    private HeapMemoryAllocator(long capacity) {
        this.capacity = capacity;
    }

    public static HeapMemoryAllocator unlimited() {
        return new HeapMemoryAllocator(Long.MAX_VALUE);
    }

    @Override
    public Optional<ResourceHolder<WritableMemory>> allocate(final long size) {
        if (this.bytesAllocated < this.capacity - size) {
            this.bytesAllocated += size;
            return Optional.of(new ResourceHolder<WritableMemory>(){
                private WritableMemory memory;
                {
                    this.memory = WritableMemory.writableWrap((ByteBuffer)ByteBuffer.allocate(Ints.checkedCast((long)size)).order(ByteOrder.LITTLE_ENDIAN));
                }

                @Override
                public WritableMemory get() {
                    if (this.memory == null) {
                        throw new ISE("Already closed", new Object[0]);
                    }
                    return this.memory;
                }

                @Override
                public void close() {
                    this.memory = null;
                    HeapMemoryAllocator.this.bytesAllocated = HeapMemoryAllocator.this.bytesAllocated - size;
                }
            });
        }
        return Optional.empty();
    }

    @Override
    public long available() {
        return this.capacity - this.bytesAllocated;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }
}

