/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.write.columnar.FloatFrameMaker;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.BaseFloatVectorValueSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    FloatFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory, frame.numRows());
        boolean hasNulls = FloatFrameColumnReader.getHasNulls(memory);
        return new ColumnPlus(new FloatFrameColumn(frame, hasNulls, memory), ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.FLOAT).setHasNulls(NullHandling.sqlCompatible() && hasNulls), frame.numRows());
    }

    private void validate(Memory region, int numRows) {
        long memorySize = region.getCapacity();
        if (memorySize < 2L) {
            throw new ISE("Column is not big enough for a header", new Object[0]);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 2) {
            throw new ISE("Column does not have the correct type code", new Object[0]);
        }
        boolean hasNulls = FloatFrameColumnReader.getHasNulls(region);
        int sz = FloatFrameMaker.valueSize(hasNulls);
        if (memorySize != 2L + (long)sz * (long)numRows) {
            throw new ISE("Column does not have the correct length", new Object[0]);
        }
    }

    private static boolean getHasNulls(Memory memory) {
        return memory.getByte(1L) != 0;
    }

    private static class FloatFrameColumn
    implements NumericColumn {
        private final Frame frame;
        private final boolean hasNulls;
        private final int sz;
        private final Memory memory;
        private final long memoryPosition;

        private FloatFrameColumn(Frame frame, boolean hasNulls, Memory memory) {
            this.frame = frame;
            this.hasNulls = hasNulls;
            this.sz = FloatFrameMaker.valueSize(hasNulls);
            this.memory = memory;
            this.memoryPosition = 2L;
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new FloatColumnSelector(){

                @Override
                public float getFloat() {
                    assert (NullHandling.replaceWithDefault() || !this.isNull());
                    return this.getFloat(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public boolean isNull() {
                    return this.isNull(frame.physicalRow(offset.getOffset()));
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(final ReadableVectorOffset theOffset) {
            class FloatFrameColumnVectorValueSelector
            extends BaseFloatVectorValueSelector {
                private final float[] floatVector;
                private final boolean[] nullVector;
                private int id;

                FloatFrameColumnVectorValueSelector() {
                    super(readableVectorOffset);
                    this.id = -1;
                    this.floatVector = new float[this.offset.getMaxVectorSize()];
                    this.nullVector = FloatFrameColumn.this.hasNulls ? new boolean[this.offset.getMaxVectorSize()] : null;
                }

                @Override
                @Nullable
                public boolean[] getNullVector() {
                    this.computeVectorsIfNeeded();
                    return this.nullVector;
                }

                @Override
                public float[] getFloatVector() {
                    this.computeVectorsIfNeeded();
                    return this.floatVector;
                }

                private void computeVectorsIfNeeded() {
                    if (this.id == this.offset.getId()) {
                        return;
                    }
                    if (this.offset.isContiguous()) {
                        int start = this.offset.getStartOffset();
                        for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = FloatFrameColumn.this.frame.physicalRow(i + start);
                            this.floatVector[i] = FloatFrameColumn.this.getFloat(physicalRow);
                            if (!FloatFrameColumn.this.hasNulls) continue;
                            this.nullVector[i] = FloatFrameColumn.this.isNull(physicalRow);
                        }
                    } else {
                        int[] offsets = this.offset.getOffsets();
                        for (int i = 0; i < this.offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = FloatFrameColumn.this.frame.physicalRow(offsets[i]);
                            this.floatVector[i] = FloatFrameColumn.this.getFloat(physicalRow);
                            if (!FloatFrameColumn.this.hasNulls) continue;
                            this.nullVector[i] = FloatFrameColumn.this.isNull(physicalRow);
                        }
                    }
                    this.id = this.offset.getId();
                }
            }
            return new FloatFrameColumnVectorValueSelector();
        }

        @Override
        public int length() {
            return this.frame.numRows();
        }

        @Override
        public long getLongSingleValueRow(int rowNum) {
            if (rowNum < 0 || rowNum >= this.frame.numRows()) {
                throw new ISE("Row [%d] out of bounds", rowNum);
            }
            return (long)this.getFloat(this.frame.physicalRow(rowNum));
        }

        @Override
        public void close() {
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        private boolean isNull(int physicalRow) {
            if (NullHandling.sqlCompatible() && this.hasNulls) {
                long rowPosition = this.memoryPosition + (long)this.sz * (long)physicalRow;
                return this.memory.getByte(rowPosition) != 0;
            }
            return false;
        }

        private float getFloat(int physicalRow) {
            long rowPosition = this.memoryPosition + (long)this.sz * (long)physicalRow;
            if (this.hasNulls) {
                return this.memory.getFloat(rowPosition + 1L);
            }
            return this.memory.getFloat(rowPosition);
        }
    }
}

