/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.util;

import com.google.common.base.Splitter;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.StringUtils;

public class DurableStorageUtils {
    public static final String SUCCESS_MARKER_FILENAME = "__success";
    public static final Splitter SPLITTER = Splitter.on((String)"/").limit(2);

    public static String getControllerDirectory(String controllerTaskId) {
        return StringUtils.format("controller_%s", IdUtils.validateId("controller task ID", controllerTaskId));
    }

    public static String getSuccessFilePath(String controllerTaskId, int stageNumber, int workerNumber) {
        String folderName = DurableStorageUtils.getWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber);
        return StringUtils.format("%s/%s", folderName, SUCCESS_MARKER_FILENAME);
    }

    public static String getWorkerOutputFolderName(String controllerTaskId, int stageNumber, int workerNumber) {
        return StringUtils.format("%s/stage_%d/worker_%d", DurableStorageUtils.getControllerDirectory(controllerTaskId), stageNumber, workerNumber);
    }

    public static String getTaskIdOutputsFolderName(String controllerTaskId, int stageNumber, int workerNumber, String taskId) {
        return StringUtils.format("%s/taskId_%s", DurableStorageUtils.getWorkerOutputFolderName(controllerTaskId, stageNumber, workerNumber), taskId);
    }

    public static String getPartitionOutputsFileNameForPartition(String controllerTaskId, int stageNumber, int workerNumber, String taskId, int partitionNumber) {
        return StringUtils.format("%s/part_%d", DurableStorageUtils.getTaskIdOutputsFolderName(controllerTaskId, stageNumber, workerNumber, taskId), partitionNumber);
    }

    public static String getOutputsFileNameForPath(String controllerTaskId, int stageNumber, int workerNumber, String taskId, String path) {
        return StringUtils.format("%s/%s", DurableStorageUtils.getTaskIdOutputsFolderName(controllerTaskId, stageNumber, workerNumber, taskId), path);
    }

    @Nullable
    public static String getControllerTaskIdWithPrefixFromPath(String path) {
        if (path == null) {
            return null;
        }
        Iterator elements = SPLITTER.split((CharSequence)path).iterator();
        if (elements.hasNext()) {
            return (String)elements.next();
        }
        return null;
    }
}

