/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.google.inject.BindingAnnotation;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.druid.java.util.common.IAE;

public class GuiceAnnotationIntrospector
extends NopAnnotationIntrospector {
    public Object findInjectableValueId(AnnotatedMember m) {
        if (m.getAnnotation(JacksonInject.class) == null) {
            return null;
        }
        Annotation guiceAnnotation = null;
        for (Annotation annotation : m.annotations()) {
            if (!annotation.annotationType().isAnnotationPresent(BindingAnnotation.class)) continue;
            guiceAnnotation = annotation;
            break;
        }
        if (guiceAnnotation == null) {
            if (m instanceof AnnotatedMethod) {
                throw new IAE("Annotated methods don't work very well yet...", new Object[0]);
            }
            return Key.get((Type)m.getGenericType());
        }
        return Key.get((Type)m.getGenericType(), guiceAnnotation);
    }

    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated ac) {
        AnnotatedClass aClass;
        AnnotatedParameter ap;
        if (ac instanceof AnnotatedParameter && (ap = (AnnotatedParameter)ac).hasAnnotation(JsonProperty.class)) {
            return JsonIgnoreProperties.Value.empty();
        }
        if (ac instanceof AnnotatedClass && Map.class.isAssignableFrom((aClass = (AnnotatedClass)ac).getAnnotated())) {
            return JsonIgnoreProperties.Value.empty();
        }
        return JsonIgnoreProperties.Value.forIgnoredProperties((String[])new String[]{""}).withAllowGetters();
    }
}

