/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;

public class TaskLocation {
    private static final TaskLocation UNKNOWN = new TaskLocation(null, -1, -1);
    @Nullable
    private final String host;
    private final int port;
    private final int tlsPort;

    public static TaskLocation create(String host, int port, int tlsPort) {
        return new TaskLocation(host, port, tlsPort);
    }

    public static TaskLocation create(String host, int port, int tlsPort, boolean isTls) {
        return isTls ? new TaskLocation(host, -1, tlsPort) : new TaskLocation(host, port, -1);
    }

    public static TaskLocation unknown() {
        return UNKNOWN;
    }

    @JsonCreator
    public TaskLocation(@JsonProperty(value="host") @Nullable String host, @JsonProperty(value="port") int port, @JsonProperty(value="tlsPort") int tlsPort) {
        this.host = host;
        this.port = port;
        this.tlsPort = tlsPort;
    }

    @Nullable
    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public int getTlsPort() {
        return this.tlsPort;
    }

    public URL makeURL(String encodedPathAndQueryString) throws MalformedURLException {
        int portToUse;
        String scheme;
        if (this.tlsPort > 0) {
            scheme = "https";
            portToUse = this.tlsPort;
        } else {
            scheme = "http";
            portToUse = this.port;
        }
        if (!encodedPathAndQueryString.startsWith("/")) {
            throw new IAE("Path must start with '/'", new Object[0]);
        }
        return new URL(scheme, this.host, portToUse, encodedPathAndQueryString);
    }

    public String toString() {
        return "TaskLocation{host='" + this.host + '\'' + ", port=" + this.port + ", tlsPort=" + this.tlsPort + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLocation that = (TaskLocation)o;
        return this.port == that.port && this.tlsPort == that.tlsPort && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.tlsPort);
    }
}

