/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.chrono.ISOChronology;

public final class Intervals {
    public static final Interval ETERNITY = Intervals.utc(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    public static final ImmutableList<Interval> ONLY_ETERNITY = ImmutableList.of((Object)ETERNITY);

    public static Interval utc(long startInstant, long endInstant) {
        return new Interval(startInstant, endInstant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static Interval of(String interval) {
        return new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC());
    }

    public static Interval of(String format, Object ... formatArgs) {
        return Intervals.of(StringUtils.format(format, formatArgs));
    }

    public static boolean isEmpty(Interval interval) {
        return interval.getStart().equals((Object)interval.getEnd());
    }

    public static boolean canCompareEndpointsAsStrings(Interval interval) {
        return DateTimes.canCompareAsString(interval.getStart()) && DateTimes.canCompareAsString(interval.getEnd());
    }

    public static boolean isEternity(Interval interval) {
        return ETERNITY.equals((Object)interval);
    }

    @Nullable
    public static Interval findOverlappingInterval(Interval searchInterval, Interval[] sortedIntervals) {
        for (Interval interval : sortedIntervals) {
            if (interval.overlaps((ReadableInterval)searchInterval)) {
                return interval;
            }
            if (!interval.getStart().isAfter((ReadableInstant)searchInterval.getEnd())) continue;
            return null;
        }
        return null;
    }

    private Intervals() {
    }
}

