/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BySegmentResultValue;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.context.ResponseContext;

public class FinalizeResultsQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;

    public FinalizeResultsQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        MetricManipulationFn metricManipulationFn;
        Query<T> queryToRun;
        final Query<T> query = queryPlus.getQuery();
        QueryContext queryContext = query.context();
        boolean isBySegment = queryContext.isBySegment();
        boolean shouldFinalize = queryContext.isFinalize(true);
        if (shouldFinalize) {
            queryToRun = query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"finalize", (Object)false));
            metricManipulationFn = MetricManipulatorFns.finalizing();
        } else {
            queryToRun = query;
            metricManipulationFn = MetricManipulatorFns.identity();
        }
        Function finalizerFn = isBySegment ? new Function<T, Result<BySegmentResultValue<T>>>(){
            final Function<T, T> baseFinalizer;
            {
                this.baseFinalizer = FinalizeResultsQueryRunner.this.toolChest.makePostComputeManipulatorFn(query, metricManipulationFn);
            }

            public Result<BySegmentResultValue<T>> apply(T input) {
                Result result = (Result)input;
                if (input == null) {
                    throw new ISE("Cannot have a null result!", new Object[0]);
                }
                BySegmentResultValue resultsClass = (BySegmentResultValue)result.getValue();
                return new Result(result.getTimestamp(), new BySegmentResultValueClass(Lists.transform(resultsClass.getResults(), this.baseFinalizer), resultsClass.getSegmentId(), resultsClass.getInterval()));
            }
        } : this.toolChest.makePostComputeManipulatorFn(query, metricManipulationFn);
        return Sequences.map(this.baseRunner.run(queryPlus.withQuery(queryToRun), responseContext), finalizerFn);
    }
}

