/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.PrioritizedCallable;
import org.apache.druid.query.PrioritizedListenableFutureTask;
import org.apache.druid.query.PrioritizedRunnable;

public class PrioritizedExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    private final AtomicLong queuePosition = new AtomicLong(Long.MAX_VALUE);
    private final ListeningExecutorService delegate;
    private final BlockingQueue<Runnable> delegateQueue;
    private final boolean allowRegularTasks;
    private final int defaultPriority;
    private final DruidProcessingConfig config;
    final ThreadPoolExecutor threadPoolExecutor;

    public static PrioritizedExecutorService create(Lifecycle lifecycle, DruidProcessingConfig config) {
        final PrioritizedExecutorService service = new PrioritizedExecutorService(new ThreadPoolExecutor(config.getNumThreads(), config.getNumThreads(), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(config.getFormatString()).build()), config);
        lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() {
            }

            @Override
            public void stop() {
                service.shutdownNow();
            }
        });
        return service;
    }

    public PrioritizedExecutorService(ThreadPoolExecutor threadPoolExecutor, DruidProcessingConfig config) {
        this(threadPoolExecutor, false, 0, config);
    }

    public PrioritizedExecutorService(ThreadPoolExecutor threadPoolExecutor, boolean allowRegularTasks, int defaultPriority, DruidProcessingConfig config) {
        this.threadPoolExecutor = threadPoolExecutor;
        this.delegate = MoreExecutors.listeningDecorator((ExecutorService)((ExecutorService)Preconditions.checkNotNull((Object)threadPoolExecutor)));
        this.delegateQueue = threadPoolExecutor.getQueue();
        this.allowRegularTasks = allowRegularTasks;
        this.defaultPriority = defaultPriority;
        this.config = config;
    }

    protected <T> PrioritizedListenableFutureTask<T> newTaskFor(Runnable runnable, T value) {
        Preconditions.checkArgument((this.allowRegularTasks || runnable instanceof PrioritizedRunnable ? 1 : 0) != 0, (Object)"task does not implement PrioritizedRunnable");
        return PrioritizedListenableFutureTask.create(ListenableFutureTask.create((Runnable)runnable, value), runnable instanceof PrioritizedRunnable ? ((PrioritizedRunnable)runnable).getPriority() : this.defaultPriority, this.config.isFifo() ? this.queuePosition.decrementAndGet() : 0L);
    }

    protected <T> PrioritizedListenableFutureTask<T> newTaskFor(Callable<T> callable) {
        Preconditions.checkArgument((this.allowRegularTasks || callable instanceof PrioritizedCallable ? 1 : 0) != 0, (Object)"task does not implement PrioritizedCallable");
        return PrioritizedListenableFutureTask.create(ListenableFutureTask.create(callable), callable instanceof PrioritizedCallable ? ((PrioritizedCallable)callable).getPriority() : this.defaultPriority, this.config.isFifo() ? this.queuePosition.decrementAndGet() : 0L);
    }

    public ListenableFuture<?> submit(Runnable task) {
        return (ListenableFuture)super.submit(task);
    }

    public <T> ListenableFuture<T> submit(Runnable task, @Nullable T result) {
        return (ListenableFuture)super.submit(task, result);
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return (ListenableFuture)super.submit(task);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable instanceof PrioritizedListenableFutureTask) {
            this.delegate.execute(runnable);
        } else {
            this.delegate.execute((Runnable)this.newTaskFor(runnable, (Object)null));
        }
    }

    public int getQueueSize() {
        return this.delegateQueue.size();
    }
}

