/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BadQueryContextException;

public class QueryContexts {
    public static final String FINALIZE_KEY = "finalize";
    public static final String PRIORITY_KEY = "priority";
    public static final String LANE_KEY = "lane";
    public static final String TIMEOUT_KEY = "timeout";
    public static final String MAX_SCATTER_GATHER_BYTES_KEY = "maxScatterGatherBytes";
    public static final String MAX_QUEUED_BYTES_KEY = "maxQueuedBytes";
    public static final String DEFAULT_TIMEOUT_KEY = "defaultTimeout";
    public static final String BROKER_PARALLEL_MERGE_KEY = "enableParallelMerge";
    public static final String BROKER_PARALLEL_MERGE_INITIAL_YIELD_ROWS_KEY = "parallelMergeInitialYieldRows";
    public static final String BROKER_PARALLEL_MERGE_SMALL_BATCH_ROWS_KEY = "parallelMergeSmallBatchRows";
    public static final String BROKER_PARALLELISM = "parallelMergeParallelism";
    public static final String VECTORIZE_KEY = "vectorize";
    public static final String VECTORIZE_VIRTUAL_COLUMNS_KEY = "vectorizeVirtualColumns";
    public static final String VECTOR_SIZE_KEY = "vectorSize";
    public static final String MAX_SUBQUERY_ROWS_KEY = "maxSubqueryRows";
    public static final String JOIN_FILTER_PUSH_DOWN_KEY = "enableJoinFilterPushDown";
    public static final String JOIN_FILTER_REWRITE_ENABLE_KEY = "enableJoinFilterRewrite";
    public static final String JOIN_FILTER_REWRITE_VALUE_COLUMN_FILTERS_ENABLE_KEY = "enableJoinFilterRewriteValueColumnFilters";
    public static final String REWRITE_JOIN_TO_FILTER_ENABLE_KEY = "enableRewriteJoinToFilter";
    public static final String JOIN_FILTER_REWRITE_MAX_SIZE_KEY = "joinFilterRewriteMaxSize";
    public static final String MAX_NUMERIC_IN_FILTERS = "maxNumericInFilters";
    public static final String SQL_JOIN_LEFT_SCAN_DIRECT = "enableJoinLeftTableScanDirect";
    public static final String USE_FILTER_CNF_KEY = "useFilterCNF";
    public static final String NUM_RETRIES_ON_MISSING_SEGMENTS_KEY = "numRetriesOnMissingSegments";
    public static final String RETURN_PARTIAL_RESULTS_KEY = "returnPartialResults";
    public static final String USE_CACHE_KEY = "useCache";
    public static final String SECONDARY_PARTITION_PRUNING_KEY = "secondaryPartitionPruning";
    public static final String ENABLE_DEBUG = "debug";
    public static final String BY_SEGMENT_KEY = "bySegment";
    public static final String BROKER_SERVICE_NAME = "brokerService";
    public static final String IN_SUB_QUERY_THRESHOLD_KEY = "inSubQueryThreshold";
    public static final String TIME_BOUNDARY_PLANNING_KEY = "enableTimeBoundaryPlanning";
    public static final String POPULATE_CACHE_KEY = "populateCache";
    public static final String POPULATE_RESULT_LEVEL_CACHE_KEY = "populateResultLevelCache";
    public static final String USE_RESULT_LEVEL_CACHE_KEY = "useResultLevelCache";
    public static final String SERIALIZE_DATE_TIME_AS_LONG_KEY = "serializeDateTimeAsLong";
    public static final String SERIALIZE_DATE_TIME_AS_LONG_INNER_KEY = "serializeDateTimeAsLongInner";
    public static final String UNCOVERED_INTERVALS_LIMIT_KEY = "uncoveredIntervalsLimit";
    public static final String MIN_TOP_N_THRESHOLD = "minTopNThreshold";
    public static final String CTX_SQL_QUERY_ID = "sqlQueryId";
    public static final String CTX_SQL_STRINGIFY_ARRAYS = "sqlStringifyArrays";
    public static final boolean DEFAULT_BY_SEGMENT = false;
    public static final boolean DEFAULT_POPULATE_CACHE = true;
    public static final boolean DEFAULT_USE_CACHE = true;
    public static final boolean DEFAULT_POPULATE_RESULTLEVEL_CACHE = true;
    public static final boolean DEFAULT_USE_RESULTLEVEL_CACHE = true;
    public static final Vectorize DEFAULT_VECTORIZE = Vectorize.TRUE;
    public static final Vectorize DEFAULT_VECTORIZE_VIRTUAL_COLUMN = Vectorize.TRUE;
    public static final int DEFAULT_PRIORITY = 0;
    public static final int DEFAULT_UNCOVERED_INTERVALS_LIMIT = 0;
    public static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    public static final long NO_TIMEOUT = 0L;
    public static final boolean DEFAULT_ENABLE_PARALLEL_MERGE = true;
    public static final boolean DEFAULT_ENABLE_JOIN_FILTER_PUSH_DOWN = true;
    public static final boolean DEFAULT_ENABLE_JOIN_FILTER_REWRITE = true;
    public static final boolean DEFAULT_ENABLE_JOIN_FILTER_REWRITE_VALUE_COLUMN_FILTERS = false;
    public static final boolean DEFAULT_ENABLE_REWRITE_JOIN_TO_FILTER = true;
    public static final long DEFAULT_ENABLE_JOIN_FILTER_REWRITE_MAX_SIZE = 10000L;
    public static final boolean DEFAULT_ENABLE_SQL_JOIN_LEFT_SCAN_DIRECT = false;
    public static final boolean DEFAULT_USE_FILTER_CNF = false;
    public static final boolean DEFAULT_SECONDARY_PARTITION_PRUNING = true;
    public static final boolean DEFAULT_ENABLE_DEBUG = false;
    public static final int DEFAULT_IN_SUB_QUERY_THRESHOLD = Integer.MAX_VALUE;
    public static final boolean DEFAULT_ENABLE_TIME_BOUNDARY_PLANNING = false;

    private QueryContexts() {
    }

    public static long parseLong(Map<String, Object> context, String key, long defaultValue) {
        return QueryContexts.getAsLong(key, context.get(key), defaultValue);
    }

    public static int parseInt(Map<String, Object> context, String key, int defaultValue) {
        return QueryContexts.getAsInt(key, context.get(key), defaultValue);
    }

    @Nullable
    public static String parseString(Map<String, Object> context, String key) {
        return QueryContexts.parseString(context, key, null);
    }

    public static boolean parseBoolean(Map<String, Object> context, String key, boolean defaultValue) {
        return QueryContexts.getAsBoolean(key, context.get(key), defaultValue);
    }

    public static String parseString(Map<String, Object> context, String key, String defaultValue) {
        return QueryContexts.getAsString(key, context.get(key), defaultValue);
    }

    public static float parseFloat(Map<String, Object> context, String key, float defaultValue) {
        return QueryContexts.getAsFloat(key, context.get(key), defaultValue);
    }

    public static String getAsString(String key, Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw QueryContexts.badTypeException(key, "a String", value);
    }

    @Nullable
    public static Boolean getAsBoolean(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw QueryContexts.badTypeException(key, "a Boolean", value);
    }

    public static boolean getAsBoolean(String key, Object value, boolean defaultValue) {
        Boolean val = QueryContexts.getAsBoolean(key, value);
        return val == null ? defaultValue : val;
    }

    @Nullable
    public static Integer getAsInt(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Numbers.parseInt(value);
            }
            catch (NumberFormatException ignored) {
                try {
                    return new BigDecimal((String)value).intValueExact();
                }
                catch (Exception nfe) {
                    throw QueryContexts.badValueException(key, "in integer format", value);
                }
            }
        }
        throw QueryContexts.badTypeException(key, "an Integer", value);
    }

    public static int getAsInt(String key, Object value, int defaultValue) {
        Integer val = QueryContexts.getAsInt(key, value);
        return val == null ? defaultValue : val;
    }

    @Nullable
    public static Long getAsLong(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Numbers.parseLong(value);
            }
            catch (NumberFormatException ignored) {
                try {
                    return new BigDecimal((String)value).longValueExact();
                }
                catch (Exception nfe) {
                    throw QueryContexts.badValueException(key, "in long format", value);
                }
            }
        }
        throw QueryContexts.badTypeException(key, "a Long", value);
    }

    public static long getAsLong(String key, Object value, long defaultValue) {
        Long val = QueryContexts.getAsLong(key, value);
        return val == null ? defaultValue : val;
    }

    public static Float getAsFloat(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            catch (NumberFormatException ignored) {
                throw QueryContexts.badValueException(key, "in float format", value);
            }
        }
        throw QueryContexts.badTypeException(key, "a Float", value);
    }

    public static float getAsFloat(String key, Object value, float defaultValue) {
        Float val = QueryContexts.getAsFloat(key, value);
        return val == null ? defaultValue : val.floatValue();
    }

    public static HumanReadableBytes getAsHumanReadableBytes(String key, Object value, HumanReadableBytes defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return HumanReadableBytes.valueOf(Numbers.parseLong(value));
        }
        if (value instanceof String) {
            try {
                return HumanReadableBytes.valueOf(HumanReadableBytes.parse((String)value));
            }
            catch (IAE e) {
                throw QueryContexts.badValueException(key, "a human readable number", value);
            }
        }
        throw QueryContexts.badTypeException(key, "a human readable number", value);
    }

    public static Map<String, Object> override(Map<String, Object> context, String key, Object value) {
        HashMap<String, Object> overridden = new HashMap<String, Object>(context);
        if (value == null) {
            overridden.remove(key);
        } else {
            overridden.put(key, value);
        }
        return overridden;
    }

    public static Map<String, Object> override(Map<String, Object> context, Map<String, Object> overrides) {
        HashMap<String, Object> overridden = new HashMap<String, Object>();
        if (context != null) {
            overridden.putAll(context);
        }
        if (overrides != null) {
            overridden.putAll(overrides);
        }
        return overridden;
    }

    public static <E extends Enum<E>> E getAsEnum(String key, Object value, Class<E> clazz, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof String) {
                return Enum.valueOf(clazz, StringUtils.toUpperCase((String)value));
            }
            if (value instanceof Boolean) {
                return Enum.valueOf(clazz, StringUtils.toUpperCase(String.valueOf(value)));
            }
        }
        catch (IllegalArgumentException e) {
            throw QueryContexts.badValueException(key, StringUtils.format("a value of enum [%s]", clazz.getSimpleName()), value);
        }
        throw QueryContexts.badTypeException(key, StringUtils.format("of type [%s]", clazz.getSimpleName()), value);
    }

    public static BadQueryContextException badValueException(String key, String expected, Object actual) {
        return new BadQueryContextException(StringUtils.format("Expected key [%s] to be %s, but got [%s]", key, expected, actual));
    }

    public static BadQueryContextException badTypeException(String key, String expected, Object actual) {
        return new BadQueryContextException(StringUtils.format("Expected key [%s] to be %s, but got [%s]", key, expected, actual.getClass().getName()));
    }

    public static void addDefaults(Map<String, Object> context, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            context.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    public static enum Vectorize {
        FALSE{

            @Override
            public boolean shouldVectorize(boolean canVectorize) {
                return false;
            }
        }
        ,
        TRUE{

            @Override
            public boolean shouldVectorize(boolean canVectorize) {
                return canVectorize;
            }
        }
        ,
        FORCE{

            @Override
            public boolean shouldVectorize(boolean canVectorize) {
                if (!canVectorize) {
                    throw new ISE("Cannot vectorize!", new Object[0]);
                }
                return true;
            }
        };


        public abstract boolean shouldVectorize(boolean var1);

        @JsonCreator
        public static Vectorize fromString(String str) {
            return Vectorize.valueOf(StringUtils.toUpperCase(str));
        }

        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase(this.name()).replace('_', '-');
        }
    }
}

