/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class QueryRunnerHelper {
    public static <T> Sequence<Result<T>> makeCursorBasedQuery(StorageAdapter adapter, List<Interval> queryIntervals, Filter filter, VirtualColumns virtualColumns, boolean descending, Granularity granularity, Function<Cursor, Result<T>> mapFn, @Nullable QueryMetrics<?> queryMetrics) {
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        return Sequences.filter(Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), virtualColumns, granularity, descending, queryMetrics), mapFn), Objects::nonNull);
    }

    public static <T> QueryRunner<T> makeClosingQueryRunner(final QueryRunner<T> runner, final Closeable closeable) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return Sequences.withBaggage(runner.run(queryPlus, responseContext), closeable);
            }
        };
    }
}

