/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.serde.cell.StorableBuffer;

public class SerializablePairLongStringSimpleStagedSerde
implements StagedSerde<SerializablePairLongString> {
    @Override
    public StorableBuffer serializeDelayed(final @Nullable SerializablePairLongString value) {
        if (value == null) {
            return StorableBuffer.EMPTY;
        }
        String rhsString = (String)value.rhs;
        final byte[] rhsBytes = StringUtils.toUtf8WithNullToEmpty(rhsString);
        return new StorableBuffer(){

            @Override
            public void store(ByteBuffer byteBuffer) {
                Preconditions.checkNotNull((Object)value.lhs, (Object)"Long in SerializablePairLongString must be non-null");
                byteBuffer.putLong((Long)value.lhs);
                byteBuffer.putInt(rhsBytes.length);
                if (rhsBytes.length > 0) {
                    byteBuffer.put(rhsBytes);
                }
            }

            @Override
            public int getSerializedSize() {
                return 12 + rhsBytes.length;
            }
        };
    }

    @Override
    @Nullable
    public SerializablePairLongString deserialize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return null;
        }
        ByteBuffer readOnlyBuffer = byteBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
        long lhs = readOnlyBuffer.getLong();
        int stringSize = readOnlyBuffer.getInt();
        String lastString = null;
        if (stringSize > 0) {
            byte[] stringBytes = new byte[stringSize];
            readOnlyBuffer.get(stringBytes, 0, stringSize);
            lastString = StringUtils.fromUtf8(stringBytes);
        }
        return new SerializablePairLongString(lhs, lastString);
    }
}

